/*
 * Decompiled with CFR 0.152.
 */
package enterprises.iwakura.modularbot.objects;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import lombok.NonNull;

public final class ModuleInfo {
    private final String name;
    private final String mainClass;
    private final String author;
    private final String version;
    private final boolean sigewineRequired;
    private final String sigewinePackagePath;
    private final String[] depend;
    private final String[] softDepend;
    private final String[] loadBefore;
    private final String[] exceptionHandlingPackages;

    public static ModuleInfo createInternalModuleInfo(String name, String author, String version) {
        return ModuleInfo.builder().name(name).author(author).version(version).depend(new String[0]).softDepend(new String[0]).loadBefore(new String[0]).exceptionHandlingPackages(new String[0]).build();
    }

    public static ModuleInfo createInternalModuleInfo(@NonNull String name, @NonNull String author, @NonNull String version, boolean sigewineRequired, @NonNull String[] depend, @NonNull String[] softDepend, @NonNull String[] loadBefore, @NonNull String[] exceptionHandlingPackages) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (author == null) {
            throw new NullPointerException("author is marked non-null but is null");
        }
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        if (depend == null) {
            throw new NullPointerException("depend is marked non-null but is null");
        }
        if (softDepend == null) {
            throw new NullPointerException("softDepend is marked non-null but is null");
        }
        if (loadBefore == null) {
            throw new NullPointerException("loadBefore is marked non-null but is null");
        }
        if (exceptionHandlingPackages == null) {
            throw new NullPointerException("exceptionHandlingPackages is marked non-null but is null");
        }
        return ModuleInfo.builder().name(name).author(author).version(version).sigewineRequired(sigewineRequired).depend(depend).softDepend(softDepend).loadBefore(loadBefore).exceptionHandlingPackages(exceptionHandlingPackages).build();
    }

    public static ModuleInfo loadFromJsonObject(JsonObject jsonObject) throws IOException {
        if (!jsonObject.has("name")) {
            throw new IOException("ModuleInfo is missing name field!");
        }
        if (!jsonObject.has("mainClass")) {
            throw new IOException("ModuleInfo is missing mainClass field!");
        }
        String name = jsonObject.get("name").getAsString();
        String author = jsonObject.has("author") ? jsonObject.get("author").getAsString() : "Unknown author";
        String version = jsonObject.has("version") ? jsonObject.get("version").getAsString() : "Unknown version";
        String mainClass = jsonObject.get("mainClass").getAsString();
        boolean sigewineRequired = jsonObject.has("sigewineRequired") && jsonObject.get("sigewineRequired").getAsBoolean();
        String sigewinePackagePath = jsonObject.has("sigewinePackagePath") ? jsonObject.get("sigewinePackagePath").getAsString() : null;
        String[] depend = jsonObject.has("depend") ? ModuleInfo.jsonArrayToStringArray(jsonObject.getAsJsonArray("depend")) : new String[]{};
        String[] softDepend = jsonObject.has("softDepend") ? ModuleInfo.jsonArrayToStringArray(jsonObject.getAsJsonArray("softDepend")) : new String[]{};
        String[] loadBefore = jsonObject.has("loadBefore") ? ModuleInfo.jsonArrayToStringArray(jsonObject.getAsJsonArray("loadBefore")) : new String[]{};
        String[] exceptionHandlingPackages = jsonObject.has("exceptionHandlingPackages") ? ModuleInfo.jsonArrayToStringArray(jsonObject.getAsJsonArray("exceptionHandlingPackages")) : new String[]{};
        return new ModuleInfo(name, mainClass, author, version, sigewineRequired, sigewinePackagePath, depend, softDepend, loadBefore, exceptionHandlingPackages);
    }

    private static String[] jsonArrayToStringArray(JsonArray jsonArray) {
        String[] stringArray = new String[jsonArray.size()];
        for (int i = 0; i < jsonArray.size(); ++i) {
            stringArray[i] = jsonArray.get(i).getAsString();
        }
        return stringArray;
    }

    @Generated
    public static ModuleInfoBuilder builder() {
        return new ModuleInfoBuilder();
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getMainClass() {
        return this.mainClass;
    }

    @Generated
    public String getAuthor() {
        return this.author;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public boolean isSigewineRequired() {
        return this.sigewineRequired;
    }

    @Generated
    public String getSigewinePackagePath() {
        return this.sigewinePackagePath;
    }

    @Generated
    public String[] getDepend() {
        return this.depend;
    }

    @Generated
    public String[] getSoftDepend() {
        return this.softDepend;
    }

    @Generated
    public String[] getLoadBefore() {
        return this.loadBefore;
    }

    @Generated
    public String[] getExceptionHandlingPackages() {
        return this.exceptionHandlingPackages;
    }

    @Generated
    public ModuleInfo(String name, String mainClass, String author, String version, boolean sigewineRequired, String sigewinePackagePath, String[] depend, String[] softDepend, String[] loadBefore, String[] exceptionHandlingPackages) {
        this.name = name;
        this.mainClass = mainClass;
        this.author = author;
        this.version = version;
        this.sigewineRequired = sigewineRequired;
        this.sigewinePackagePath = sigewinePackagePath;
        this.depend = depend;
        this.softDepend = softDepend;
        this.loadBefore = loadBefore;
        this.exceptionHandlingPackages = exceptionHandlingPackages;
    }

    @Generated
    public static class ModuleInfoBuilder {
        @Generated
        private String name;
        @Generated
        private String mainClass;
        @Generated
        private String author;
        @Generated
        private String version;
        @Generated
        private boolean sigewineRequired;
        @Generated
        private String sigewinePackagePath;
        @Generated
        private String[] depend;
        @Generated
        private String[] softDepend;
        @Generated
        private String[] loadBefore;
        @Generated
        private String[] exceptionHandlingPackages;

        @Generated
        ModuleInfoBuilder() {
        }

        @Generated
        public ModuleInfoBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public ModuleInfoBuilder mainClass(String mainClass) {
            this.mainClass = mainClass;
            return this;
        }

        @Generated
        public ModuleInfoBuilder author(String author) {
            this.author = author;
            return this;
        }

        @Generated
        public ModuleInfoBuilder version(String version) {
            this.version = version;
            return this;
        }

        @Generated
        public ModuleInfoBuilder sigewineRequired(boolean sigewineRequired) {
            this.sigewineRequired = sigewineRequired;
            return this;
        }

        @Generated
        public ModuleInfoBuilder sigewinePackagePath(String sigewinePackagePath) {
            this.sigewinePackagePath = sigewinePackagePath;
            return this;
        }

        @Generated
        public ModuleInfoBuilder depend(String[] depend) {
            this.depend = depend;
            return this;
        }

        @Generated
        public ModuleInfoBuilder softDepend(String[] softDepend) {
            this.softDepend = softDepend;
            return this;
        }

        @Generated
        public ModuleInfoBuilder loadBefore(String[] loadBefore) {
            this.loadBefore = loadBefore;
            return this;
        }

        @Generated
        public ModuleInfoBuilder exceptionHandlingPackages(String[] exceptionHandlingPackages) {
            this.exceptionHandlingPackages = exceptionHandlingPackages;
            return this;
        }

        @Generated
        public ModuleInfo build() {
            return new ModuleInfo(this.name, this.mainClass, this.author, this.version, this.sigewineRequired, this.sigewinePackagePath, this.depend, this.softDepend, this.loadBefore, this.exceptionHandlingPackages);
        }

        @Generated
        public String toString() {
            return "ModuleInfo.ModuleInfoBuilder(name=" + this.name + ", mainClass=" + this.mainClass + ", author=" + this.author + ", version=" + this.version + ", sigewineRequired=" + this.sigewineRequired + ", sigewinePackagePath=" + this.sigewinePackagePath + ", depend=" + Arrays.deepToString(this.depend) + ", softDepend=" + Arrays.deepToString(this.softDepend) + ", loadBefore=" + Arrays.deepToString(this.loadBefore) + ", exceptionHandlingPackages=" + Arrays.deepToString(this.exceptionHandlingPackages) + ")";
        }
    }
}

