/*
 * Decompiled with CFR 0.152.
 */
package enterprises.iwakura.amber;

import lombok.Generated;

public class Dependency {
    private final String notation;
    private final String groupId;
    private final String name;
    private final String version;

    public Dependency(String notation) {
        this.notation = notation;
        String[] parts = notation.split(":");
        if (parts.length != 3) {
            throw new IllegalArgumentException("Invalid dependency notation: " + notation);
        }
        this.groupId = parts[0];
        this.name = parts[1];
        this.version = parts[2];
    }

    public String getGroupIdAsPath() {
        return this.groupId.replace('.', '/');
    }

    public String getFileName() {
        return this.name + "-" + this.version + ".jar";
    }

    public String toString() {
        return this.notation;
    }

    @Generated
    public String getNotation() {
        return this.notation;
    }

    @Generated
    public String getGroupId() {
        return this.groupId;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Dependency)) {
            return false;
        }
        Dependency other = (Dependency)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$notation = this.getNotation();
        String other$notation = other.getNotation();
        if (this$notation == null ? other$notation != null : !this$notation.equals(other$notation)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !this$version.equals(other$version));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Dependency;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $notation = this.getNotation();
        result = result * 59 + ($notation == null ? 43 : $notation.hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        return result;
    }
}

