/*
 * Decompiled with CFR 0.152.
 */
package enterprises.iwakura.modularbot.base;

import com.jagrosh.jdautilities.command.CommandClientBuilder;
import enterprises.iwakura.ganyu.Ganyu;
import enterprises.iwakura.modularbot.base.Module;
import java.util.List;
import java.util.Optional;
import net.dv8tion.jda.api.sharding.DefaultShardManagerBuilder;
import org.apache.logging.log4j.LogManager;

public interface ModuleManager {
    public List<Module> getModules();

    public void addInternalModules(Module ... var1);

    default public boolean isModuleLoaded(String moduleName) {
        return this.getModuleByName(moduleName).orElse(null) != null;
    }

    default public Optional<Module> getModuleByName(String moduleName) {
        return this.getModules().stream().filter(module -> module.getModuleInfo().getName().equals(moduleName)).findAny();
    }

    public boolean loadModules();

    public void loadModule(Module var1);

    public void enableModules();

    public void enableModule(Module var1);

    public void unloadModules();

    public void unloadModule(Module var1);

    default public void processCommandClientBuilder(CommandClientBuilder commandClientBuilder) {
        this.getModules().forEach(module -> module.onCommandClientBuilderInitialization(commandClientBuilder));
    }

    default public void processGanyu(Ganyu ganyu) {
        this.getModules().forEach(module -> module.onConsoleCommandRegistration(ganyu));
    }

    default public void processShardBuilder(DefaultShardManagerBuilder shardManagerBuilder) {
        this.getModules().forEach(module -> module.onShardManagerBuilderInitialization(shardManagerBuilder));
    }

    default public void processException(Throwable throwable) {
        this.getModules().forEach(module -> {
            try {
                for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
                    for (String packageName : module.getModuleInfo().getExceptionHandlingPackages()) {
                        if (!stackTraceElement.getClassName().contains(packageName)) continue;
                        module.onUncaughtException(throwable);
                        return;
                    }
                }
            }
            catch (Exception exception) {
                LogManager.getLogger(ModuleManager.class).error("Exception occurred while processing modules with uncaught exception!", (Throwable)exception);
            }
        });
    }
}

