/*
 * Decompiled with CFR 0.152.
 */
package enterprises.iwakura.modularbot.classloader;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.List;

public final class ModuleClassLoader
extends URLClassLoader {
    private final List<ClassLoader> otherClassLoaders;

    public ModuleClassLoader(List<Path> jarFiles, ClassLoader parent, List<ClassLoader> otherClassLoaders) throws MalformedURLException {
        super((URL[])jarFiles.stream().map(path -> {
            try {
                return path.toUri().toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }).toArray(URL[]::new), parent);
        this.otherClassLoaders = otherClassLoaders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        try {
            Class<?> result = super.loadClass(name, resolve);
            if (result.getClassLoader() == this) {
                return result;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        List<ClassLoader> list = this.otherClassLoaders;
        synchronized (list) {
            for (ClassLoader otherClassLoader : this.otherClassLoaders) {
                if (otherClassLoader == this) continue;
                try {
                    return otherClassLoader.loadClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
        }
        return this.getParent().loadClass(name);
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

