/*
 * Decompiled with CFR 0.152.
 */
package enterprises.iwakura.modularbot.objects;

import com.google.gson.JsonObject;
import dev.mayuna.mayusjsonutils.MayuJson;
import enterprises.iwakura.modularbot.objects.ModuleInfo;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import lombok.Generated;
import lombok.NonNull;

public final class ModuleConfig {
    private final ModuleInfo moduleInfo;
    private final JsonObject defaultConfig;
    private Path dataDirectoryPath;
    private Path configPath;
    private MayuJson mayuJson;

    public ModuleConfig(@NonNull ModuleInfo moduleInfo, @NonNull JsonObject defaultConfig) {
        if (moduleInfo == null) {
            throw new NullPointerException("moduleInfo is marked non-null but is null");
        }
        if (defaultConfig == null) {
            throw new NullPointerException("defaultConfig is marked non-null but is null");
        }
        this.moduleInfo = moduleInfo;
        this.defaultConfig = defaultConfig;
        this.reload();
    }

    public void reload() {
        this.dataDirectoryPath = Path.of(String.format("./modules/%s", this.moduleInfo.getName()), new String[0]);
        if (!Files.exists(this.dataDirectoryPath, new LinkOption[0])) {
            try {
                Files.createDirectories(this.dataDirectoryPath, new FileAttribute[0]);
            }
            catch (IOException exception) {
                throw new RuntimeException(new IOException("Could not create data folder for module " + this.moduleInfo.getName() + " (" + this.moduleInfo.getVersion() + ") with path " + String.valueOf(this.dataDirectoryPath) + "! Maybe the module name has illegal characters?"));
            }
        }
        this.configPath = Path.of(this.dataDirectoryPath.toString(), "config.json");
        try {
            this.mayuJson = MayuJson.createOrLoadJsonObject((Path)this.configPath);
        }
        catch (IOException exception) {
            throw new RuntimeException("Could not create/load config.json file for module " + this.moduleInfo.getName() + " (" + this.moduleInfo.getVersion() + ") with path " + String.valueOf(this.configPath) + "!");
        }
    }

    public void save() {
        try {
            this.mayuJson.save();
        }
        catch (Exception exception) {
            throw new RuntimeException("Could not save config for module " + this.moduleInfo.getName() + " (" + this.moduleInfo.getVersion() + ") with config path " + String.valueOf(this.mayuJson.getPath()) + "!", exception);
        }
    }

    public void copyDefaultsIfEmpty() {
        if (!this.mayuJson.getJsonObject().entrySet().isEmpty()) {
            return;
        }
        this.mayuJson.setJsonObject(this.defaultConfig);
        this.save();
    }

    @Generated
    public ModuleInfo getModuleInfo() {
        return this.moduleInfo;
    }

    @Generated
    public JsonObject getDefaultConfig() {
        return this.defaultConfig;
    }

    @Generated
    public Path getDataDirectoryPath() {
        return this.dataDirectoryPath;
    }

    @Generated
    public Path getConfigPath() {
        return this.configPath;
    }

    @Generated
    public MayuJson getMayuJson() {
        return this.mayuJson;
    }
}

