/*
 * Decompiled with CFR 0.152.
 */
package enterprises.iwakura.amber;

import enterprises.iwakura.amber.AmberManifest;
import enterprises.iwakura.amber.Dependency;
import enterprises.iwakura.amber.Repository;
import enterprises.iwakura.amber.RepositoryType;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public interface ManifestLoader {
    public static final String MANIFEST_FILE_PATH = "META-INF/MANIFEST.MF";
    public static final String ATTRIBUTE_AMBER_DIRECTORY = "Amber-Directory";
    public static final String ATTRIBUTE_AMBER_DEPENDENCIES = "Amber-Dependencies";
    public static final String ATTRIBUTE_AMBER_MAVEN_REPOSITORIES = "Amber-Maven-Repositories";
    public static final String ATTRIBUTE_SPLITTER = ",";

    public List<AmberManifest> loadManifest() throws IOException;

    default public AmberManifest parseManifest(Manifest manifest) {
        Attributes attributes = manifest.getMainAttributes();
        String directoryAttribute = attributes.getValue(ATTRIBUTE_AMBER_DIRECTORY);
        String dependenciesAttribute = attributes.getValue(ATTRIBUTE_AMBER_DEPENDENCIES);
        String mavenRepositoriesAttribute = attributes.getValue(ATTRIBUTE_AMBER_MAVEN_REPOSITORIES);
        if (directoryAttribute == null && dependenciesAttribute == null && mavenRepositoriesAttribute == null) {
            return null;
        }
        Path directoryPath = directoryAttribute != null ? Paths.get(directoryAttribute, new String[0]) : null;
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        ArrayList<Repository> repositories = new ArrayList<Repository>();
        if (dependenciesAttribute != null) {
            for (String dependency : dependenciesAttribute.split(ATTRIBUTE_SPLITTER)) {
                dependencies.add(new Dependency(dependency.trim()));
            }
        }
        if (mavenRepositoriesAttribute != null) {
            for (String repository : mavenRepositoriesAttribute.split(ATTRIBUTE_SPLITTER)) {
                repositories.add(new Repository(RepositoryType.MAVEN, repository.trim()));
            }
        }
        return new AmberManifest(directoryPath, dependencies, repositories);
    }
}

