/*
 * Decompiled with CFR 0.152.
 */
package enterprises.iwakura.modularbot.objects.activity;

import enterprises.iwakura.modularbot.base.Module;
import enterprises.iwakura.modularbot.objects.activity.ModuleActivity;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Function;
import lombok.NonNull;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.entities.Activity;

public final class ModuleActivities {
    private final List<ModuleActivity> activities = Collections.synchronizedList(new LinkedList());
    private final Module module;

    public ModuleActivities(@NonNull Module module) {
        if (module == null) {
            throw new NullPointerException("module is marked non-null but is null");
        }
        this.module = module;
    }

    public void createActivity(@NonNull String name, @NonNull Function<JDA, Activity> onActivityRefresh) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (onActivityRefresh == null) {
            throw new NullPointerException("onActivityRefresh is marked non-null but is null");
        }
        this.removeActivity(name);
        this.activities.add(new ModuleActivity(this.module, name, onActivityRefresh));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeActivity(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        List<ModuleActivity> list = this.activities;
        synchronized (list) {
            ListIterator<ModuleActivity> iterator = this.activities.listIterator();
            boolean removedSomething = false;
            while (iterator.hasNext()) {
                ModuleActivity activity = (ModuleActivity)iterator.next();
                if (!activity.getName().equals(name)) continue;
                iterator.remove();
                removedSomething = true;
            }
            return removedSomething;
        }
    }

    public List<ModuleActivity> getActivities() {
        return Collections.unmodifiableList(this.activities);
    }
}

