/*
 * Decompiled with CFR 0.152.
 */
package enterprises.iwakura.modularbot;

import dev.mayuna.mayuslibrary.exceptionreporting.UncaughtExceptionReporter;
import enterprises.iwakura.ganyu.Ganyu;
import enterprises.iwakura.modularbot.ModularBotConfig;
import enterprises.iwakura.modularbot.ModularBotConstants;
import enterprises.iwakura.modularbot.ModularBotShardManager;
import enterprises.iwakura.modularbot.managers.ModuleManager;
import enterprises.iwakura.sigewine.core.Sigewine;
import enterprises.iwakura.sigewine.core.SigewineOptions;
import enterprises.iwakura.sigewine.core.annotations.RomaritimeBean;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@RomaritimeBean
public final class ModularBot {
    @Generated
    private static final Logger log = LogManager.getLogger(ModularBot.class);
    private static final Sigewine sigewine = new Sigewine(SigewineOptions.builder().build());
    private static ModularBot instance;
    private final Ganyu ganyu;
    private final ModularBotShardManager modularBotShardManager;
    private final ModularBotConfig config;
    private final ModuleManager moduleManager;
    private boolean running;
    private boolean stopping;

    public ModularBot(Ganyu ganyu, ModularBotShardManager modularBotShardManager, ModularBotConfig config, ModuleManager moduleManager) {
        this.ganyu = ganyu;
        this.modularBotShardManager = modularBotShardManager;
        this.config = config;
        this.moduleManager = moduleManager;
        instance = this;
    }

    public static ModularBot get() {
        return instance;
    }

    public void start(String[] args) {
        log.info("Starting ModularDiscordBot @ {}", (Object)ModularBotConstants.getVersion());
        log.info("Made by Mayuna");
        log.info("Java Runtime Information:");
        log.info("Java Version: {}", (Object)System.getProperty("java.version"));
        log.info("Java Vendor: {}", (Object)System.getProperty("java.vendor"));
        log.info("Java VM Name: {}", (Object)System.getProperty("java.vm.name"));
        log.info("Java VM Version: {}", (Object)System.getProperty("java.vm.version"));
        log.info("Java VM Vendor: {}", (Object)System.getProperty("java.vm.vendor"));
        log.info(" \n \n\u001b[0;35m 88b           d88  88888888ba,    88888888ba\n\u001b[0;35m 888b         d888  88      `\"8b   88      \"8b\n\u001b[0;35m 88`8b       d8'88  88        `8b  88      ,8P\n\u001b[0;35m 88 `8b     d8' 88  88         88  88aaaaaa8P'\n\u001b[0;35m 88  `8b   d8'  88  88         88  88\"\"\"\"\"\"8b,\n\u001b[0;35m 88   `8b d8'   88  88         8P  88      `8b\n\u001b[0;35m 88    `888'    88  88      .a8P   88      a8P\n\u001b[0;35m 88     `8'     88  88888888Y\"'    88888888P\"\n \n\u001b[0;35M =========== Modular Discord Bot 3 ===========\n\u001b[0;35M ==     Created by: Iwakura Enterprises     ==\n\u001b[0;35M =============================================\u001b[0m\n");
        log.info("Loading...");
        long startMillis = System.currentTimeMillis();
        log.info("Phase 1/5 - Loading core...");
        log.info("Checking configuration");
        this.checkConfiguration();
        log.info("Registering Shutdown hook");
        this.registerShutdownHook();
        log.info("Registering UncaughtExceptionReporter");
        this.registerUncaughtExceptionReporter();
        log.info("Phase 2/5 - Loading modules...");
        this.loadModules();
        log.info("Phase 3/5 - Enabling modules...");
        this.enableModules();
        log.info("Phase 4/5 - Preparing JDA...");
        log.info("Creating ModularBotShardManager...");
        this.createModularBotShardManager();
        log.info("Initializing modules...");
        this.initializeModules();
        log.info("Finishing ModularBotShardManager...");
        this.finishModularBotShardManager();
        log.info("Phase 5/5 - Connecting to Discord...");
        this.connectToDiscord();
        log.info("Successfully started ModularDiscordBot (took {}ms)", (Object)(System.currentTimeMillis() - startMillis));
        this.running = true;
        log.info("Initializing Presence Activity Cycle...");
        this.initializePresenceActivityCycle();
    }

    private void checkConfiguration() {
        if (this.config == null) {
            this.shutdown();
        }
    }

    private void registerShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (!this.stopping) {
                log.warn("Modular Discord Bot has not stopped gracefully! Please, use command 'stop' to stop the application. There is a chance that the modules won't be unloaded fully before JVM termination.");
                log.info("Shutting down Modular Discord Bot...");
                this.shutdown();
            }
        }));
    }

    private void registerUncaughtExceptionReporter() {
        UncaughtExceptionReporter.register();
        UncaughtExceptionReporter.addExceptionReportConsumer(exceptionReport -> {
            log.warn("Uncaught exception occurred! Sending to modules...", exceptionReport.getThrowable());
            this.moduleManager.processException(exceptionReport.getThrowable());
        });
    }

    private void loadModules() {
        if (!this.moduleManager.loadModules()) {
            this.shutdown();
        }
    }

    private void enableModules() {
        this.moduleManager.enableModules();
    }

    private void initializeModules() {
        log.info("Processing Ganyu...");
        this.moduleManager.processGanyu(this.ganyu);
        log.info("Processing CommandClientBuilder...");
        this.moduleManager.processCommandClientBuilder(this.modularBotShardManager.getCommandClientBuilder());
        log.info("Processing ShardManagerBuilder...");
        this.moduleManager.processShardBuilder(this.modularBotShardManager.getShardManagerBuilder());
    }

    private void createModularBotShardManager() {
        log.info("Initializing ModularBotShardManager...");
        if (!this.modularBotShardManager.init()) {
            this.shutdown();
        }
    }

    private void finishModularBotShardManager() {
        if (!this.modularBotShardManager.finish()) {
            this.shutdown();
        }
    }

    private void connectToDiscord() {
        if (!this.modularBotShardManager.connect()) {
            this.shutdown();
        }
    }

    private void initializePresenceActivityCycle() {
        this.modularBotShardManager.initPresenceActivityCycle();
    }

    public void shutdown() {
        this.stopping = true;
        log.info("Shutting down ModularDiscordBot @ {}", (Object)ModularBotConstants.getVersion());
        log.info("Shutting down Ganyu...");
        this.ganyu.stop();
        log.info("Unloading modules...");
        this.moduleManager.unloadModules();
        log.info("Disconnecting from Discord...");
        if (this.modularBotShardManager != null) {
            this.modularBotShardManager.shutdown();
        }
        log.info("Shutdown completed");
        log.info("Halting JVM...");
        Runtime.getRuntime().halt(0);
    }

    @Generated
    public Ganyu getGanyu() {
        return this.ganyu;
    }

    @Generated
    public ModularBotShardManager getModularBotShardManager() {
        return this.modularBotShardManager;
    }

    @Generated
    public ModularBotConfig getConfig() {
        return this.config;
    }

    @Generated
    public ModuleManager getModuleManager() {
        return this.moduleManager;
    }

    @Generated
    public boolean isRunning() {
        return this.running;
    }

    @Generated
    public boolean isStopping() {
        return this.stopping;
    }

    @Generated
    public void setRunning(boolean running) {
        this.running = running;
    }

    @Generated
    public void setStopping(boolean stopping) {
        this.stopping = stopping;
    }

    @Generated
    public static Sigewine getSigewine() {
        return sigewine;
    }
}

