/*
 * Decompiled with CFR 0.152.
 */
package enterprises.iwakura.modularbot.objects;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;

public final class ModuleInfo {
    private final String name;
    private final String mainClass;
    private final String configClass;
    private final String author;
    private final String version;
    private final boolean sigewineRequired;
    private final String sigewinePackagePath;
    private final String[] depend;
    private final String[] softDepend;
    private final String[] loadBefore;
    private final String[] exceptionHandlingPackages;

    public static ModuleInfo loadFromJsonObject(JsonObject jsonObject) throws IOException {
        if (!jsonObject.has("name")) {
            throw new IOException("ModuleInfo is missing name field!");
        }
        if (!jsonObject.has("mainClass")) {
            throw new IOException("ModuleInfo is missing mainClass field!");
        }
        String name = jsonObject.get("name").getAsString();
        String configClass = jsonObject.has("configClass") ? jsonObject.get("configClass").getAsString() : null;
        String author = jsonObject.has("author") ? jsonObject.get("author").getAsString() : "Unknown author";
        String version = jsonObject.has("version") ? jsonObject.get("version").getAsString() : "Unknown version";
        String mainClass = jsonObject.get("mainClass").getAsString();
        boolean sigewineRequired = jsonObject.has("sigewineRequired") && jsonObject.get("sigewineRequired").getAsBoolean();
        String sigewinePackagePath = jsonObject.has("sigewinePackagePath") ? jsonObject.get("sigewinePackagePath").getAsString() : null;
        String[] depend = jsonObject.has("depend") ? ModuleInfo.jsonArrayToStringArray(jsonObject.getAsJsonArray("depend")) : new String[]{};
        String[] softDepend = jsonObject.has("softDepend") ? ModuleInfo.jsonArrayToStringArray(jsonObject.getAsJsonArray("softDepend")) : new String[]{};
        String[] loadBefore = jsonObject.has("loadBefore") ? ModuleInfo.jsonArrayToStringArray(jsonObject.getAsJsonArray("loadBefore")) : new String[]{};
        String[] exceptionHandlingPackages = jsonObject.has("exceptionHandlingPackages") ? ModuleInfo.jsonArrayToStringArray(jsonObject.getAsJsonArray("exceptionHandlingPackages")) : new String[]{};
        return new ModuleInfo(name, mainClass, configClass, author, version, sigewineRequired, sigewinePackagePath, depend, softDepend, loadBefore, exceptionHandlingPackages);
    }

    private static String[] jsonArrayToStringArray(JsonArray jsonArray) {
        String[] stringArray = new String[jsonArray.size()];
        for (int i = 0; i < jsonArray.size(); ++i) {
            stringArray[i] = jsonArray.get(i).getAsString();
        }
        return stringArray;
    }

    @Generated
    public static ModuleInfoBuilder builder() {
        return new ModuleInfoBuilder();
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getMainClass() {
        return this.mainClass;
    }

    @Generated
    public String getConfigClass() {
        return this.configClass;
    }

    @Generated
    public String getAuthor() {
        return this.author;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public boolean isSigewineRequired() {
        return this.sigewineRequired;
    }

    @Generated
    public String getSigewinePackagePath() {
        return this.sigewinePackagePath;
    }

    @Generated
    public String[] getDepend() {
        return this.depend;
    }

    @Generated
    public String[] getSoftDepend() {
        return this.softDepend;
    }

    @Generated
    public String[] getLoadBefore() {
        return this.loadBefore;
    }

    @Generated
    public String[] getExceptionHandlingPackages() {
        return this.exceptionHandlingPackages;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModuleInfo)) {
            return false;
        }
        ModuleInfo other = (ModuleInfo)o;
        if (this.isSigewineRequired() != other.isSigewineRequired()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$mainClass = this.getMainClass();
        String other$mainClass = other.getMainClass();
        if (this$mainClass == null ? other$mainClass != null : !this$mainClass.equals(other$mainClass)) {
            return false;
        }
        String this$configClass = this.getConfigClass();
        String other$configClass = other.getConfigClass();
        if (this$configClass == null ? other$configClass != null : !this$configClass.equals(other$configClass)) {
            return false;
        }
        String this$author = this.getAuthor();
        String other$author = other.getAuthor();
        if (this$author == null ? other$author != null : !this$author.equals(other$author)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$sigewinePackagePath = this.getSigewinePackagePath();
        String other$sigewinePackagePath = other.getSigewinePackagePath();
        if (this$sigewinePackagePath == null ? other$sigewinePackagePath != null : !this$sigewinePackagePath.equals(other$sigewinePackagePath)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getDepend(), other.getDepend())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getSoftDepend(), other.getSoftDepend())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getLoadBefore(), other.getLoadBefore())) {
            return false;
        }
        return Arrays.deepEquals(this.getExceptionHandlingPackages(), other.getExceptionHandlingPackages());
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSigewineRequired() ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $mainClass = this.getMainClass();
        result = result * 59 + ($mainClass == null ? 43 : $mainClass.hashCode());
        String $configClass = this.getConfigClass();
        result = result * 59 + ($configClass == null ? 43 : $configClass.hashCode());
        String $author = this.getAuthor();
        result = result * 59 + ($author == null ? 43 : $author.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $sigewinePackagePath = this.getSigewinePackagePath();
        result = result * 59 + ($sigewinePackagePath == null ? 43 : $sigewinePackagePath.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getDepend());
        result = result * 59 + Arrays.deepHashCode(this.getSoftDepend());
        result = result * 59 + Arrays.deepHashCode(this.getLoadBefore());
        result = result * 59 + Arrays.deepHashCode(this.getExceptionHandlingPackages());
        return result;
    }

    @Generated
    public String toString() {
        return "ModuleInfo(name=" + this.getName() + ", mainClass=" + this.getMainClass() + ", configClass=" + this.getConfigClass() + ", author=" + this.getAuthor() + ", version=" + this.getVersion() + ", sigewineRequired=" + this.isSigewineRequired() + ", sigewinePackagePath=" + this.getSigewinePackagePath() + ", depend=" + Arrays.deepToString(this.getDepend()) + ", softDepend=" + Arrays.deepToString(this.getSoftDepend()) + ", loadBefore=" + Arrays.deepToString(this.getLoadBefore()) + ", exceptionHandlingPackages=" + Arrays.deepToString(this.getExceptionHandlingPackages()) + ")";
    }

    @Generated
    public ModuleInfo(String name, String mainClass, String configClass, String author, String version, boolean sigewineRequired, String sigewinePackagePath, String[] depend, String[] softDepend, String[] loadBefore, String[] exceptionHandlingPackages) {
        this.name = name;
        this.mainClass = mainClass;
        this.configClass = configClass;
        this.author = author;
        this.version = version;
        this.sigewineRequired = sigewineRequired;
        this.sigewinePackagePath = sigewinePackagePath;
        this.depend = depend;
        this.softDepend = softDepend;
        this.loadBefore = loadBefore;
        this.exceptionHandlingPackages = exceptionHandlingPackages;
    }

    @Generated
    public static class ModuleInfoBuilder {
        @Generated
        private String name;
        @Generated
        private String mainClass;
        @Generated
        private String configClass;
        @Generated
        private String author;
        @Generated
        private String version;
        @Generated
        private boolean sigewineRequired;
        @Generated
        private String sigewinePackagePath;
        @Generated
        private String[] depend;
        @Generated
        private String[] softDepend;
        @Generated
        private String[] loadBefore;
        @Generated
        private String[] exceptionHandlingPackages;

        @Generated
        ModuleInfoBuilder() {
        }

        @Generated
        public ModuleInfoBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public ModuleInfoBuilder mainClass(String mainClass) {
            this.mainClass = mainClass;
            return this;
        }

        @Generated
        public ModuleInfoBuilder configClass(String configClass) {
            this.configClass = configClass;
            return this;
        }

        @Generated
        public ModuleInfoBuilder author(String author) {
            this.author = author;
            return this;
        }

        @Generated
        public ModuleInfoBuilder version(String version) {
            this.version = version;
            return this;
        }

        @Generated
        public ModuleInfoBuilder sigewineRequired(boolean sigewineRequired) {
            this.sigewineRequired = sigewineRequired;
            return this;
        }

        @Generated
        public ModuleInfoBuilder sigewinePackagePath(String sigewinePackagePath) {
            this.sigewinePackagePath = sigewinePackagePath;
            return this;
        }

        @Generated
        public ModuleInfoBuilder depend(String[] depend) {
            this.depend = depend;
            return this;
        }

        @Generated
        public ModuleInfoBuilder softDepend(String[] softDepend) {
            this.softDepend = softDepend;
            return this;
        }

        @Generated
        public ModuleInfoBuilder loadBefore(String[] loadBefore) {
            this.loadBefore = loadBefore;
            return this;
        }

        @Generated
        public ModuleInfoBuilder exceptionHandlingPackages(String[] exceptionHandlingPackages) {
            this.exceptionHandlingPackages = exceptionHandlingPackages;
            return this;
        }

        @Generated
        public ModuleInfo build() {
            return new ModuleInfo(this.name, this.mainClass, this.configClass, this.author, this.version, this.sigewineRequired, this.sigewinePackagePath, this.depend, this.softDepend, this.loadBefore, this.exceptionHandlingPackages);
        }

        @Generated
        public String toString() {
            return "ModuleInfo.ModuleInfoBuilder(name=" + this.name + ", mainClass=" + this.mainClass + ", configClass=" + this.configClass + ", author=" + this.author + ", version=" + this.version + ", sigewineRequired=" + this.sigewineRequired + ", sigewinePackagePath=" + this.sigewinePackagePath + ", depend=" + Arrays.deepToString(this.depend) + ", softDepend=" + Arrays.deepToString(this.softDepend) + ", loadBefore=" + Arrays.deepToString(this.loadBefore) + ", exceptionHandlingPackages=" + Arrays.deepToString(this.exceptionHandlingPackages) + ")";
        }
    }
}

