/*
 * Decompiled with CFR 0.152.
 */
package enterprises.iwakura.amber;

import enterprises.iwakura.amber.AmberManifest;
import java.nio.file.Path;
import java.nio.file.Paths;
import lombok.Generated;

public class BootstrapOptions {
    private Path tempDirectory;
    private boolean validateChecksums;
    private boolean failOnInvalidChecksum;
    private boolean forceRedownload;
    private boolean failOnMissingDependency;
    private Integer exitCodeAfterDownload;
    private String exitMessageAfterDownload;
    private Path libraryDirectoryOverride;
    private int downloaderThreadCount;

    public Path getPrefferedLibraryDirectory(AmberManifest manifest) {
        return this.libraryDirectoryOverride != null ? this.libraryDirectoryOverride : manifest.getDirectory();
    }

    @Generated
    private static Path $default$tempDirectory() {
        return Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
    }

    @Generated
    private static boolean $default$validateChecksums() {
        return true;
    }

    @Generated
    private static boolean $default$failOnInvalidChecksum() {
        return true;
    }

    @Generated
    private static boolean $default$forceRedownload() {
        return false;
    }

    @Generated
    private static boolean $default$failOnMissingDependency() {
        return true;
    }

    @Generated
    private static int $default$downloaderThreadCount() {
        return Runtime.getRuntime().availableProcessors() * 2;
    }

    @Generated
    BootstrapOptions(Path tempDirectory, boolean validateChecksums, boolean failOnInvalidChecksum, boolean forceRedownload, boolean failOnMissingDependency, Integer exitCodeAfterDownload, String exitMessageAfterDownload, Path libraryDirectoryOverride, int downloaderThreadCount) {
        this.tempDirectory = tempDirectory;
        this.validateChecksums = validateChecksums;
        this.failOnInvalidChecksum = failOnInvalidChecksum;
        this.forceRedownload = forceRedownload;
        this.failOnMissingDependency = failOnMissingDependency;
        this.exitCodeAfterDownload = exitCodeAfterDownload;
        this.exitMessageAfterDownload = exitMessageAfterDownload;
        this.libraryDirectoryOverride = libraryDirectoryOverride;
        this.downloaderThreadCount = downloaderThreadCount;
    }

    @Generated
    public static BootstrapOptionsBuilder builder() {
        return new BootstrapOptionsBuilder();
    }

    @Generated
    public Path getTempDirectory() {
        return this.tempDirectory;
    }

    @Generated
    public boolean isValidateChecksums() {
        return this.validateChecksums;
    }

    @Generated
    public boolean isFailOnInvalidChecksum() {
        return this.failOnInvalidChecksum;
    }

    @Generated
    public boolean isForceRedownload() {
        return this.forceRedownload;
    }

    @Generated
    public boolean isFailOnMissingDependency() {
        return this.failOnMissingDependency;
    }

    @Generated
    public Integer getExitCodeAfterDownload() {
        return this.exitCodeAfterDownload;
    }

    @Generated
    public String getExitMessageAfterDownload() {
        return this.exitMessageAfterDownload;
    }

    @Generated
    public Path getLibraryDirectoryOverride() {
        return this.libraryDirectoryOverride;
    }

    @Generated
    public int getDownloaderThreadCount() {
        return this.downloaderThreadCount;
    }

    @Generated
    public void setTempDirectory(Path tempDirectory) {
        this.tempDirectory = tempDirectory;
    }

    @Generated
    public void setValidateChecksums(boolean validateChecksums) {
        this.validateChecksums = validateChecksums;
    }

    @Generated
    public void setFailOnInvalidChecksum(boolean failOnInvalidChecksum) {
        this.failOnInvalidChecksum = failOnInvalidChecksum;
    }

    @Generated
    public void setForceRedownload(boolean forceRedownload) {
        this.forceRedownload = forceRedownload;
    }

    @Generated
    public void setFailOnMissingDependency(boolean failOnMissingDependency) {
        this.failOnMissingDependency = failOnMissingDependency;
    }

    @Generated
    public void setExitCodeAfterDownload(Integer exitCodeAfterDownload) {
        this.exitCodeAfterDownload = exitCodeAfterDownload;
    }

    @Generated
    public void setExitMessageAfterDownload(String exitMessageAfterDownload) {
        this.exitMessageAfterDownload = exitMessageAfterDownload;
    }

    @Generated
    public void setLibraryDirectoryOverride(Path libraryDirectoryOverride) {
        this.libraryDirectoryOverride = libraryDirectoryOverride;
    }

    @Generated
    public void setDownloaderThreadCount(int downloaderThreadCount) {
        this.downloaderThreadCount = downloaderThreadCount;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BootstrapOptions)) {
            return false;
        }
        BootstrapOptions other = (BootstrapOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isValidateChecksums() != other.isValidateChecksums()) {
            return false;
        }
        if (this.isFailOnInvalidChecksum() != other.isFailOnInvalidChecksum()) {
            return false;
        }
        if (this.isForceRedownload() != other.isForceRedownload()) {
            return false;
        }
        if (this.isFailOnMissingDependency() != other.isFailOnMissingDependency()) {
            return false;
        }
        if (this.getDownloaderThreadCount() != other.getDownloaderThreadCount()) {
            return false;
        }
        Integer this$exitCodeAfterDownload = this.getExitCodeAfterDownload();
        Integer other$exitCodeAfterDownload = other.getExitCodeAfterDownload();
        if (this$exitCodeAfterDownload == null ? other$exitCodeAfterDownload != null : !((Object)this$exitCodeAfterDownload).equals(other$exitCodeAfterDownload)) {
            return false;
        }
        Path this$tempDirectory = this.getTempDirectory();
        Path other$tempDirectory = other.getTempDirectory();
        if (this$tempDirectory == null ? other$tempDirectory != null : !((Object)this$tempDirectory).equals(other$tempDirectory)) {
            return false;
        }
        String this$exitMessageAfterDownload = this.getExitMessageAfterDownload();
        String other$exitMessageAfterDownload = other.getExitMessageAfterDownload();
        if (this$exitMessageAfterDownload == null ? other$exitMessageAfterDownload != null : !this$exitMessageAfterDownload.equals(other$exitMessageAfterDownload)) {
            return false;
        }
        Path this$libraryDirectoryOverride = this.getLibraryDirectoryOverride();
        Path other$libraryDirectoryOverride = other.getLibraryDirectoryOverride();
        return !(this$libraryDirectoryOverride == null ? other$libraryDirectoryOverride != null : !((Object)this$libraryDirectoryOverride).equals(other$libraryDirectoryOverride));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BootstrapOptions;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isValidateChecksums() ? 79 : 97);
        result = result * 59 + (this.isFailOnInvalidChecksum() ? 79 : 97);
        result = result * 59 + (this.isForceRedownload() ? 79 : 97);
        result = result * 59 + (this.isFailOnMissingDependency() ? 79 : 97);
        result = result * 59 + this.getDownloaderThreadCount();
        Integer $exitCodeAfterDownload = this.getExitCodeAfterDownload();
        result = result * 59 + ($exitCodeAfterDownload == null ? 43 : ((Object)$exitCodeAfterDownload).hashCode());
        Path $tempDirectory = this.getTempDirectory();
        result = result * 59 + ($tempDirectory == null ? 43 : ((Object)$tempDirectory).hashCode());
        String $exitMessageAfterDownload = this.getExitMessageAfterDownload();
        result = result * 59 + ($exitMessageAfterDownload == null ? 43 : $exitMessageAfterDownload.hashCode());
        Path $libraryDirectoryOverride = this.getLibraryDirectoryOverride();
        result = result * 59 + ($libraryDirectoryOverride == null ? 43 : ((Object)$libraryDirectoryOverride).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BootstrapOptions(tempDirectory=" + this.getTempDirectory() + ", validateChecksums=" + this.isValidateChecksums() + ", failOnInvalidChecksum=" + this.isFailOnInvalidChecksum() + ", forceRedownload=" + this.isForceRedownload() + ", failOnMissingDependency=" + this.isFailOnMissingDependency() + ", exitCodeAfterDownload=" + this.getExitCodeAfterDownload() + ", exitMessageAfterDownload=" + this.getExitMessageAfterDownload() + ", libraryDirectoryOverride=" + this.getLibraryDirectoryOverride() + ", downloaderThreadCount=" + this.getDownloaderThreadCount() + ")";
    }

    @Generated
    public static class BootstrapOptionsBuilder {
        @Generated
        private boolean tempDirectory$set;
        @Generated
        private Path tempDirectory$value;
        @Generated
        private boolean validateChecksums$set;
        @Generated
        private boolean validateChecksums$value;
        @Generated
        private boolean failOnInvalidChecksum$set;
        @Generated
        private boolean failOnInvalidChecksum$value;
        @Generated
        private boolean forceRedownload$set;
        @Generated
        private boolean forceRedownload$value;
        @Generated
        private boolean failOnMissingDependency$set;
        @Generated
        private boolean failOnMissingDependency$value;
        @Generated
        private Integer exitCodeAfterDownload;
        @Generated
        private String exitMessageAfterDownload;
        @Generated
        private Path libraryDirectoryOverride;
        @Generated
        private boolean downloaderThreadCount$set;
        @Generated
        private int downloaderThreadCount$value;

        @Generated
        BootstrapOptionsBuilder() {
        }

        @Generated
        public BootstrapOptionsBuilder tempDirectory(Path tempDirectory) {
            this.tempDirectory$value = tempDirectory;
            this.tempDirectory$set = true;
            return this;
        }

        @Generated
        public BootstrapOptionsBuilder validateChecksums(boolean validateChecksums) {
            this.validateChecksums$value = validateChecksums;
            this.validateChecksums$set = true;
            return this;
        }

        @Generated
        public BootstrapOptionsBuilder failOnInvalidChecksum(boolean failOnInvalidChecksum) {
            this.failOnInvalidChecksum$value = failOnInvalidChecksum;
            this.failOnInvalidChecksum$set = true;
            return this;
        }

        @Generated
        public BootstrapOptionsBuilder forceRedownload(boolean forceRedownload) {
            this.forceRedownload$value = forceRedownload;
            this.forceRedownload$set = true;
            return this;
        }

        @Generated
        public BootstrapOptionsBuilder failOnMissingDependency(boolean failOnMissingDependency) {
            this.failOnMissingDependency$value = failOnMissingDependency;
            this.failOnMissingDependency$set = true;
            return this;
        }

        @Generated
        public BootstrapOptionsBuilder exitCodeAfterDownload(Integer exitCodeAfterDownload) {
            this.exitCodeAfterDownload = exitCodeAfterDownload;
            return this;
        }

        @Generated
        public BootstrapOptionsBuilder exitMessageAfterDownload(String exitMessageAfterDownload) {
            this.exitMessageAfterDownload = exitMessageAfterDownload;
            return this;
        }

        @Generated
        public BootstrapOptionsBuilder libraryDirectoryOverride(Path libraryDirectoryOverride) {
            this.libraryDirectoryOverride = libraryDirectoryOverride;
            return this;
        }

        @Generated
        public BootstrapOptionsBuilder downloaderThreadCount(int downloaderThreadCount) {
            this.downloaderThreadCount$value = downloaderThreadCount;
            this.downloaderThreadCount$set = true;
            return this;
        }

        @Generated
        public BootstrapOptions build() {
            Path tempDirectory$value = this.tempDirectory$value;
            if (!this.tempDirectory$set) {
                tempDirectory$value = BootstrapOptions.$default$tempDirectory();
            }
            boolean validateChecksums$value = this.validateChecksums$value;
            if (!this.validateChecksums$set) {
                validateChecksums$value = BootstrapOptions.$default$validateChecksums();
            }
            boolean failOnInvalidChecksum$value = this.failOnInvalidChecksum$value;
            if (!this.failOnInvalidChecksum$set) {
                failOnInvalidChecksum$value = BootstrapOptions.$default$failOnInvalidChecksum();
            }
            boolean forceRedownload$value = this.forceRedownload$value;
            if (!this.forceRedownload$set) {
                forceRedownload$value = BootstrapOptions.$default$forceRedownload();
            }
            boolean failOnMissingDependency$value = this.failOnMissingDependency$value;
            if (!this.failOnMissingDependency$set) {
                failOnMissingDependency$value = BootstrapOptions.$default$failOnMissingDependency();
            }
            int downloaderThreadCount$value = this.downloaderThreadCount$value;
            if (!this.downloaderThreadCount$set) {
                downloaderThreadCount$value = BootstrapOptions.$default$downloaderThreadCount();
            }
            return new BootstrapOptions(tempDirectory$value, validateChecksums$value, failOnInvalidChecksum$value, forceRedownload$value, failOnMissingDependency$value, this.exitCodeAfterDownload, this.exitMessageAfterDownload, this.libraryDirectoryOverride, downloaderThreadCount$value);
        }

        @Generated
        public String toString() {
            return "BootstrapOptions.BootstrapOptionsBuilder(tempDirectory$value=" + this.tempDirectory$value + ", validateChecksums$value=" + this.validateChecksums$value + ", failOnInvalidChecksum$value=" + this.failOnInvalidChecksum$value + ", forceRedownload$value=" + this.forceRedownload$value + ", failOnMissingDependency$value=" + this.failOnMissingDependency$value + ", exitCodeAfterDownload=" + this.exitCodeAfterDownload + ", exitMessageAfterDownload=" + this.exitMessageAfterDownload + ", libraryDirectoryOverride=" + this.libraryDirectoryOverride + ", downloaderThreadCount$value=" + this.downloaderThreadCount$value + ")";
        }
    }
}

