/*
 * Decompiled with CFR 0.152.
 */
package enterprises.iwakura.modularbot;

import com.jagrosh.jdautilities.command.CommandClientBuilder;
import enterprises.iwakura.jdainteractables.InteractableListener;
import enterprises.iwakura.modularbot.ModularBotConfig;
import enterprises.iwakura.modularbot.managers.ModuleManager;
import enterprises.iwakura.modularbot.objects.ModuleStatus;
import enterprises.iwakura.modularbot.objects.activity.ModuleActivity;
import enterprises.iwakura.sigewine.core.annotations.RomaritimeBean;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import lombok.Generated;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.sharding.DefaultShardManagerBuilder;
import net.dv8tion.jda.api.sharding.ShardManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@RomaritimeBean
public final class ModularBotShardManager {
    @Generated
    private static final Logger log = LogManager.getLogger(ModularBotShardManager.class);
    public static final int INVALID_SHARD_ID = -1;
    private final ModularBotConfig modularBotConfig;
    private final ModuleManager moduleManager;
    private final Timer presenceActivityUpdaterTimer = new Timer();
    private CommandClientBuilder commandClientBuilder;
    private DefaultShardManagerBuilder shardManagerBuilder;
    private ShardManager shardManager;
    private boolean connected = false;
    private int lastActivityIndex = 0;

    public boolean init() {
        ModularBotConfig.Discord discordSettings = this.modularBotConfig.getDiscord();
        log.info("Creating CommandClientBuilder...");
        this.commandClientBuilder = new CommandClientBuilder().setOwnerId(discordSettings.getOwnerId()).setActivity(null);
        try {
            ModularBotConfig.Discord.ShardManager shardManagerSettings = discordSettings.getShardManager();
            if (discordSettings.getShardManager().isLight()) {
                log.info("Creating light DefaultShardManagerBuilder...");
                this.shardManagerBuilder = DefaultShardManagerBuilder.createLight((String)discordSettings.getToken(), shardManagerSettings.getGatewayIntents());
            } else {
                log.info("Creating default DefaultShardManagerBuilder...");
                this.shardManagerBuilder = DefaultShardManagerBuilder.createDefault((String)discordSettings.getToken(), shardManagerSettings.getGatewayIntents());
            }
            log.info("Modular Bot's config Gateway intents: {}", (Object)discordSettings.getShardManager().getGatewayIntents().toString());
            if (!shardManagerSettings.getShardIds().isEmpty()) {
                log.info("Using these shard IDs: {}", (Object)shardManagerSettings.getShardIds().toString());
                this.shardManagerBuilder.setShards(shardManagerSettings.getShardIds());
                return true;
            }
            if (shardManagerSettings.getMinShardId() != -1 && shardManagerSettings.getMaxShardId() != -1) {
                log.info("Using shard IDs from {} to {}", (Object)shardManagerSettings.getMinShardId(), (Object)shardManagerSettings.getMaxShardId());
                this.shardManagerBuilder.setShards(shardManagerSettings.getMinShardId(), shardManagerSettings.getMaxShardId());
                return true;
            }
            int totalShards = shardManagerSettings.getTotalShards();
            if (totalShards == -1) {
                log.info("Using recommended amount of shards by Discord");
                this.shardManagerBuilder.setShardsTotal(-1);
                return true;
            }
            log.info("Using total of {} shard(s)", (Object)shardManagerSettings.getTotalShards());
            this.shardManagerBuilder.setShardsTotal(shardManagerSettings.getTotalShards());
            return true;
        }
        catch (Exception exception) {
            log.error("Failed to create Shard Manager!", (Throwable)exception);
            return false;
        }
    }

    public boolean finish() {
        if (this.shardManagerBuilder == null) {
            log.warn("Cannot build shard manager twice.");
            return false;
        }
        log.info("Registering CommandClientBuilder...");
        this.shardManagerBuilder.addEventListeners(new Object[]{this.commandClientBuilder.build()});
        log.info("Registering JDA-Interactable's InteractableListener...");
        this.shardManagerBuilder.addEventListeners(new Object[]{new InteractableListener()});
        log.info("Building ShardManager...");
        try {
            this.shardManager = this.shardManagerBuilder.build(false);
            this.shardManagerBuilder = null;
            return true;
        }
        catch (Exception exception) {
            log.error("Could not build ShardManager!", (Throwable)exception);
            return false;
        }
    }

    public boolean connect() {
        if (this.connected) {
            log.warn("Cannot connect twice.");
            return false;
        }
        this.connected = true;
        try {
            this.shardManager.login();
            log.info("Connected to Discord!");
            return true;
        }
        catch (Exception exception) {
            log.error("Could not connect to Discord!", (Throwable)exception);
            return false;
        }
    }

    public void initPresenceActivityCycle() {
        ModularBotConfig.Discord.PresenceActivityCycle presenceActivityCycle = this.modularBotConfig.getDiscord().getPresenceActivityCycle();
        if (!presenceActivityCycle.isEnabled()) {
            log.warn("Presence Activity Cycle is disabled, skipping.");
            return;
        }
        long intervalMillis = presenceActivityCycle.getCycleIntervalMillis();
        if (intervalMillis < 10000L) {
            log.error("Presence Activity Cycle interval must be higher than or equal to 10000ms!");
            return;
        }
        this.presenceActivityUpdaterTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                LinkedList allActivities = new LinkedList();
                ModularBotShardManager.this.moduleManager.getModules().forEach(module -> {
                    if (module.getModuleStatus() == ModuleStatus.ENABLED) {
                        List<ModuleActivity> activities;
                        List<ModuleActivity> list = activities = module.getModuleActivities().getActivities();
                        synchronized (list) {
                            allActivities.addAll(activities);
                        }
                    }
                });
                if (allActivities.isEmpty()) {
                    return;
                }
                ModularBotShardManager.this.lastActivityIndex = allActivities.size() <= ModularBotShardManager.this.lastActivityIndex + 1 ? 0 : ++ModularBotShardManager.this.lastActivityIndex;
                ModuleActivity moduleActivity = (ModuleActivity)allActivities.get(ModularBotShardManager.this.lastActivityIndex);
                ModularBotShardManager.this.shardManager.getShardCache().forEach(jda -> {
                    try {
                        jda.getPresence().setActivity(moduleActivity.getOnActivityRefresh().apply((JDA)jda));
                    }
                    catch (Exception exception) {
                        log.error("Failed to set activity from module {} with activity name of {} on shard ID {}", (Object)moduleActivity.getModule().getModuleInfo().getName(), (Object)moduleActivity.getName(), (Object)jda.getShardInfo().getShardId());
                    }
                });
            }
        }, 0L, intervalMillis);
    }

    public void shutdown() {
        this.presenceActivityUpdaterTimer.cancel();
        if (this.shardManager != null) {
            this.shardManager.shutdown();
        }
    }

    public ShardManager get() {
        return this.shardManager;
    }

    @Generated
    public ModularBotShardManager(ModularBotConfig modularBotConfig, ModuleManager moduleManager) {
        this.modularBotConfig = modularBotConfig;
        this.moduleManager = moduleManager;
    }

    @Generated
    public CommandClientBuilder getCommandClientBuilder() {
        return this.commandClientBuilder;
    }

    @Generated
    public DefaultShardManagerBuilder getShardManagerBuilder() {
        return this.shardManagerBuilder;
    }
}

