/*
 * Decompiled with CFR 0.152.
 */
package enterprises.iwakura.modularbot.config;

import enterprises.iwakura.modularbot.config.ConfigSerializer;
import enterprises.iwakura.modularbot.objects.ModuleInfo;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;

public abstract class ModuleConfig {
    private final Map<Class<?>, RegisteredConfig> registeredConfigs = Collections.synchronizedMap(new HashMap());
    private final Map<Class<?>, Object> loadedConfigs = Collections.synchronizedMap(new HashMap());
    private final ModuleInfo moduleInfo;
    private final String modulesDirectoryPath;

    public ModuleConfig(ModuleInfo moduleInfo, String modulesDirectoryPath) {
        this.moduleInfo = moduleInfo;
        this.modulesDirectoryPath = Optional.ofNullable(modulesDirectoryPath).orElse("./modules");
    }

    public abstract void register();

    public void register(Class<?> clazz, String name, ConfigSerializer configSerializer) {
        if (this.registeredConfigs.containsKey(clazz)) {
            throw new IllegalStateException("Config class " + clazz.getName() + " is already registered!");
        }
        this.registeredConfigs.put(clazz, new RegisteredConfig(clazz, name, configSerializer));
    }

    public void copyResourceConfigs(ClassLoader classLoader) {
        for (RegisteredConfig registeredConfig : this.registeredConfigs.values()) {
            Path configPath = Path.of("%s/%s/%s".formatted(this.modulesDirectoryPath, this.moduleInfo.getName(), registeredConfig.getName()), new String[0]);
            try {
                Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
                if (Files.exists(configPath, new LinkOption[0])) continue;
                InputStream inputStream = classLoader.getResourceAsStream(registeredConfig.getName());
                try {
                    if (inputStream == null) continue;
                    Files.copy(inputStream, configPath, new CopyOption[0]);
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            catch (IOException exception) {
                throw new RuntimeException("Could not copy resource config file for class %s at path %s!".formatted(registeredConfig.getClazz().getName(), configPath), exception);
            }
        }
    }

    public <T> T getOrLoad(Class<T> clazz) {
        String contents;
        RegisteredConfig registeredConfig = this.registeredConfigs.get(clazz);
        if (registeredConfig == null) {
            throw new IllegalStateException("Config class " + clazz.getName() + " is not registered!");
        }
        if (this.loadedConfigs.containsKey(clazz)) {
            return clazz.cast(this.loadedConfigs.get(clazz));
        }
        Path configPath = Path.of("%s/%s/%s".formatted(this.modulesDirectoryPath, this.moduleInfo.getName(), registeredConfig.getName()), new String[0]);
        try {
            Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
            if (!Files.exists(configPath, new LinkOption[0])) {
                Files.createFile(configPath, new FileAttribute[0]);
                Files.writeString(configPath, (CharSequence)registeredConfig.getConfigSerializer().serialize(clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])), new OpenOption[0]);
            }
            contents = Files.readString(configPath);
        }
        catch (IOException exception) {
            throw new RuntimeException("Could not read config file for class " + clazz.getName() + " at path " + String.valueOf(configPath) + "!", exception);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Could not create new instance of the config class! (missing public no-args constructor?)", e);
        }
        T config = registeredConfig.getConfigSerializer().deserialize(contents, clazz);
        this.loadedConfigs.put(clazz, config);
        return config;
    }

    public void save(Object object) {
        Class<?> clazz = object.getClass();
        RegisteredConfig registeredConfig = this.registeredConfigs.get(clazz);
        if (registeredConfig == null) {
            throw new IllegalStateException("Config class " + clazz.getName() + " is not registered!");
        }
        Path configPath = Path.of("%s/%s/%s".formatted(this.modulesDirectoryPath, this.moduleInfo.getName(), registeredConfig.getName()), new String[0]);
        String contents = registeredConfig.getConfigSerializer().serialize(object);
        try {
            Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
            Files.writeString(configPath, (CharSequence)contents, new OpenOption[0]);
        }
        catch (IOException exception) {
            throw new RuntimeException("Could not write config file for class " + clazz.getName() + " at path " + String.valueOf(configPath) + "!", exception);
        }
    }

    public static class RegisteredConfig {
        private final Class<?> clazz;
        private final String name;
        private final ConfigSerializer configSerializer;

        @Generated
        public Class<?> getClazz() {
            return this.clazz;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public ConfigSerializer getConfigSerializer() {
            return this.configSerializer;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RegisteredConfig)) {
                return false;
            }
            RegisteredConfig other = (RegisteredConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Class<?> this$clazz = this.getClazz();
            Class<?> other$clazz = other.getClazz();
            if (this$clazz == null ? other$clazz != null : !this$clazz.equals(other$clazz)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            ConfigSerializer this$configSerializer = this.getConfigSerializer();
            ConfigSerializer other$configSerializer = other.getConfigSerializer();
            return !(this$configSerializer == null ? other$configSerializer != null : !this$configSerializer.equals(other$configSerializer));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof RegisteredConfig;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<?> $clazz = this.getClazz();
            result = result * 59 + ($clazz == null ? 43 : $clazz.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            ConfigSerializer $configSerializer = this.getConfigSerializer();
            result = result * 59 + ($configSerializer == null ? 43 : $configSerializer.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ModuleConfig.RegisteredConfig(clazz=" + String.valueOf(this.getClazz()) + ", name=" + this.getName() + ", configSerializer=" + String.valueOf(this.getConfigSerializer()) + ")";
        }

        @Generated
        public RegisteredConfig(Class<?> clazz, String name, ConfigSerializer configSerializer) {
            this.clazz = clazz;
            this.name = name;
            this.configSerializer = configSerializer;
        }
    }
}

