/*
 * Decompiled with CFR 0.152.
 */
package enterprises.iwakura.modularbot.util;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import lombok.NonNull;

public final class InputStreamUtils {
    private InputStreamUtils() {
    }

    public static InputStream openFileAsInputStream(@NonNull ZipFile zipFile, @NonNull String fileName) {
        if (zipFile == null) {
            throw new NullPointerException("zipFile is marked non-null but is null");
        }
        if (fileName == null) {
            throw new NullPointerException("fileName is marked non-null but is null");
        }
        Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
        while (zipEntries.hasMoreElements()) {
            ZipEntry zipEntry = zipEntries.nextElement();
            if (!Objects.equals(zipEntry.getName(), fileName)) continue;
            try {
                return zipFile.getInputStream(zipEntry);
            }
            catch (Exception exception) {
                throw new RuntimeException("Could not open file " + fileName + " as input stream in zip file " + zipFile.getName() + "!");
            }
        }
        return null;
    }

    public static String readStreamAsString(@NonNull InputStream inputStream) {
        if (inputStream == null) {
            throw new NullPointerException("inputStream is marked non-null but is null");
        }
        return new BufferedReader(new InputStreamReader(inputStream)).lines().collect(Collectors.joining());
    }
}

