/*
 * Decompiled with CFR 0.152.
 */
package enterprises.iwakura.modularbot.console;

import enterprises.iwakura.ganyu.GanyuCommand;
import enterprises.iwakura.ganyu.annotation.Command;
import enterprises.iwakura.ganyu.annotation.Description;
import enterprises.iwakura.ganyu.annotation.OptionalArg;
import enterprises.iwakura.ganyu.annotation.SubCommand;
import enterprises.iwakura.ganyu.annotation.Syntax;
import enterprises.iwakura.modularbot.ModularBot;
import enterprises.iwakura.modularbot.base.Module;
import enterprises.iwakura.modularbot.managers.ModuleManager;
import enterprises.iwakura.modularbot.objects.ModuleInfo;
import enterprises.iwakura.sigewine.core.annotations.RomaritimeBean;
import java.util.List;
import lombok.Generated;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.sharding.ShardManager;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@RomaritimeBean
@Command(value="modular")
@Description(value="Allows you to manage ModularDiscordBot's modules and see other various information")
@Syntax(value="")
public final class ModularConsoleCommand
implements GanyuCommand {
    @Generated
    private static final Logger log = LogManager.getLogger(ModularConsoleCommand.class);

    @SubCommand(value="modules")
    @Description(value="Shows all modules")
    public void showAllModules() {
        ModularBot modularBot = (ModularBot)ModularBot.getSigewine().syringe(ModularBot.class);
        ModuleManager moduleManager = modularBot.getModuleManager();
        List<Module<?>> modules = moduleManager.getModules();
        log.info("== Modules - {} ==", (Object)modules.size());
        modules.forEach(module -> {
            ModuleInfo moduleInfo = module.getModuleInfo();
            log.info("- {} @ {} (by {}) [{}]", (Object)moduleInfo.getName(), (Object)moduleInfo.getVersion(), (Object)moduleInfo.getAuthor(), (Object)module.getModuleStatus());
        });
        log.info("Listing modules done.");
    }

    @SubCommand(value="shards")
    @Description(value="Shows information about shards")
    @Syntax(value="[verbose]")
    public void showShards(@OptionalArg Boolean verbose) {
        ModularBot modularBot = (ModularBot)ModularBot.getSigewine().syringe(ModularBot.class);
        ShardManager shardManager = modularBot.getModularBotShardManager().get();
        log.info("== Shard Info ==");
        log.info("Total shards: {}", (Object)shardManager.getShardsTotal());
        if (!verbose.booleanValue()) {
            return;
        }
        log.info("Running shards: {}", (Object)shardManager.getShardsRunning());
        log.info("");
        log.info("! [ID] -> Status (x guilds, y users)");
        log.info("");
        shardManager.getShardCache().forEach(shard -> {
            Level logLevel = shard.getStatus() == JDA.Status.CONNECTED ? Level.INFO : Level.WARN;
            log.log(logLevel, "[{}] -> {} ({} guilds, {} users)", (Object)shard.getShardInfo().getShardId(), (Object)shard.getStatus(), (Object)shard.getGuildCache().size(), (Object)shard.getUserCache().size());
        });
    }

    @Generated
    public ModularConsoleCommand() {
    }
}

