/*
 * Decompiled with CFR 0.152.
 */
package enterprises.iwakura.modularbot.managers;

import com.google.gson.JsonParser;
import com.jagrosh.jdautilities.command.CommandClientBuilder;
import enterprises.iwakura.amber.Amber;
import enterprises.iwakura.amber.Logger;
import enterprises.iwakura.ganyu.Ganyu;
import enterprises.iwakura.modularbot.ModularBot;
import enterprises.iwakura.modularbot.ModularBotConfig;
import enterprises.iwakura.modularbot.ModularBotConstants;
import enterprises.iwakura.modularbot.amber.ModuleAmberLogger;
import enterprises.iwakura.modularbot.base.Module;
import enterprises.iwakura.modularbot.classloader.ModuleClassLoader;
import enterprises.iwakura.modularbot.config.ModuleConfig;
import enterprises.iwakura.modularbot.irminsul.ModularBotIrminsul;
import enterprises.iwakura.modularbot.objects.ModuleInfo;
import enterprises.iwakura.modularbot.objects.ModuleStatus;
import enterprises.iwakura.modularbot.util.InputStreamUtils;
import enterprises.iwakura.sigewine.core.BeanDefinition;
import enterprises.iwakura.sigewine.core.annotations.RomaritimeBean;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import java.util.zip.ZipFile;
import lombok.Generated;
import net.dv8tion.jda.api.sharding.DefaultShardManagerBuilder;
import org.apache.commons.collections4.ListUtils;
import org.apache.logging.log4j.LogManager;

@RomaritimeBean
public final class ModuleManager {
    @Generated
    private static final org.apache.logging.log4j.Logger log = LogManager.getLogger(ModuleManager.class);
    private final ModularBotIrminsul irminsul;
    private final ModularBotConfig modularBotConfig;
    private final List<ClassLoader> moduleClassLoaders = Collections.synchronizedList(new LinkedList());
    private final List<Module<?>> modules = Collections.synchronizedList(new LinkedList());

    public ModuleManager(ModularBotIrminsul irminsul, ModularBotConfig modularBotConfig) {
        this.irminsul = irminsul;
        this.modularBotConfig = modularBotConfig;
    }

    public List<Module<?>> getModules() {
        return this.modules;
    }

    public Optional<Module<?>> getModuleByName(String name) {
        return this.modules.stream().filter(module -> module.getModuleInfo().getName().equalsIgnoreCase(name)).findFirst();
    }

    public boolean loadModules() {
        log.info("Loading modules...");
        if (!this.modules.isEmpty()) {
            log.warn("Some modules are loaded - unloading them...");
            this.unloadModules();
        }
        ArrayList<Path> loadedModuleDirectories = new ArrayList<Path>();
        List directories = ListUtils.emptyIfNull(this.modularBotConfig.getModules().getModuleDirectories());
        for (Object directory : directories) {
            Path moduleDirectoryPath = Path.of((String)directory, new String[0]);
            if (Files.exists(moduleDirectoryPath, new LinkOption[0]) && Files.isDirectory(moduleDirectoryPath, new LinkOption[0])) {
                if (loadedModuleDirectories.contains(moduleDirectoryPath)) {
                    log.warn("Module directory {} is already loaded, skipping...", (Object)moduleDirectoryPath);
                    continue;
                }
                loadedModuleDirectories.add(moduleDirectoryPath);
                continue;
            }
            log.warn("Module directory {} does not exist or is not a directory, skipping...", (Object)moduleDirectoryPath);
        }
        ArrayList<Path> moduleFiles = new ArrayList<Path>();
        for (Path moduleDirectory : loadedModuleDirectories) {
            if (!Files.exists(moduleDirectory, new LinkOption[0])) {
                try {
                    Files.createDirectories(moduleDirectory, new FileAttribute[0]);
                }
                catch (IOException exception) {
                    log.error("Failed to create modules directory!");
                    return false;
                }
                log.warn("The modules directory was just created, there won't be any modules.");
                return true;
            }
            try {
                Stream<Path> paths = Files.walk(moduleDirectory, 1, new FileVisitOption[0]);
                try {
                    moduleFiles.addAll(paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.getFileName().toString().endsWith(".jar")).toList());
                }
                finally {
                    if (paths == null) continue;
                    paths.close();
                }
            }
            catch (IOException exception) {
                log.error("Failed to list files in modules directory!", (Throwable)exception);
                return false;
            }
        }
        ArrayList irminsulEntities = new ArrayList();
        for (Path moduleFile : moduleFiles) {
            Optional<Module<?>> optionalModule = this.loadModuleFile(moduleFile);
            if (optionalModule.isEmpty()) continue;
            Module<?> module = optionalModule.get();
            this.loadModule(module);
            if (module.getIrminsulEntities() == null) continue;
            irminsulEntities.addAll(module.getIrminsulEntities());
        }
        if (!irminsulEntities.isEmpty()) {
            log.info("Initializing {} Irminsul entities...", (Object)irminsulEntities.size());
            this.irminsul.initialize(irminsulEntities.toArray(new Class[0]));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<Module<?>> loadModuleFile(Path moduleFile) {
        ModuleClassLoader moduleClassLoader;
        log.info("Loading module: {}", (Object)moduleFile.getFileName());
        log.info("Bootstrapping module with Amber...");
        Amber amber = Amber.jarFiles(List.of(moduleFile), (Logger)new ModuleAmberLogger());
        ArrayList<Path> moduleJarDependencies = new ArrayList<Path>();
        moduleJarDependencies.add(moduleFile);
        try {
            moduleJarDependencies.addAll(amber.bootstrap());
        }
        catch (Exception exception) {
            log.error("Failed to bootstrap module: {}", (Object)moduleFile.getFileName(), (Object)exception);
            return Optional.empty();
        }
        try {
            moduleClassLoader = new ModuleClassLoader(moduleJarDependencies, ModuleManager.class.getClassLoader(), this.moduleClassLoaders);
        }
        catch (MalformedURLException exception) {
            log.error("Failed to create class loader for module: {}", (Object)moduleFile.getFileName(), (Object)exception);
            return Optional.empty();
        }
        try (ZipFile zipFile = new ZipFile(moduleFile.toFile());){
            Module module;
            InputStream moduleInfoInputStream = InputStreamUtils.openFileAsInputStream(zipFile, "module_info.json");
            if (moduleInfoInputStream == null) {
                log.warn("Module {} does not contain module_info.json! However, it will be loaded in classpath.", (Object)moduleFile.getFileName());
                Optional<Module<?>> optional = Optional.empty();
                return optional;
            }
            String moduleInfoFileContent = InputStreamUtils.readStreamAsString(moduleInfoInputStream);
            ModuleInfo moduleInfo = ModuleInfo.loadFromJsonObject(JsonParser.parseString((String)moduleInfoFileContent).getAsJsonObject());
            Class<?> moduleConfigClass = null;
            ModuleConfig moduleConfig = null;
            if (moduleInfo.getConfigClass() != null) {
                moduleConfigClass = moduleClassLoader.loadClass(moduleInfo.getConfigClass());
                if (!ModuleConfig.class.isAssignableFrom(moduleConfigClass)) {
                    log.error("Module {} specified config class {} which does not extend ModuleConfig!", (Object)moduleInfo.getName(), (Object)moduleInfo.getConfigClass());
                    Optional<Module<?>> optional = Optional.empty();
                    return optional;
                }
                log.info("Loading configuration for module {}...", (Object)moduleInfo.getName());
                moduleConfig = (ModuleConfig)moduleConfigClass.getConstructor(ModuleInfo.class, String.class).newInstance(moduleInfo, ModularBotConstants.PATH_FOLDER_MODULES.toString());
                moduleConfig.register();
                moduleConfig.copyResourceConfigs(moduleClassLoader);
            } else {
                log.warn("Module {} does not specify a config class, proceeding without configuration...", (Object)moduleInfo.getName());
            }
            if (moduleInfo.isSigewineRequired()) {
                Class<?> mainClass = moduleClassLoader.loadClass(moduleInfo.getMainClass());
                if (moduleConfigClass != null) {
                    String moduleConfigBeanName = moduleConfigClass.getSimpleName();
                    log.debug("Adding module config class {} to sigewine", moduleConfigClass);
                    BeanDefinition beanDefinition = new BeanDefinition(moduleConfigBeanName, moduleConfigClass, null);
                    ModularBot.getSigewine().getSingletonBeans().put(beanDefinition, moduleConfig);
                }
                String modulePackagePath = Optional.ofNullable(moduleInfo.getSigewinePackagePath()).orElse(mainClass.getPackageName());
                log.info("Module {} requires Sigewine, treating its package {} (class loader {})...", (Object)moduleInfo.getName(), (Object)modulePackagePath, (Object)mainClass.getClassLoader());
                ModularBot.getSigewine().treatment(modulePackagePath, (ClassLoader)moduleClassLoader);
                log.info("Syringing main class {} for module {}...", (Object)mainClass.getCanonicalName(), (Object)moduleInfo.getName());
                module = (Module)ModularBot.getSigewine().syringe(mainClass);
            } else {
                module = (Module)moduleClassLoader.loadClass(moduleInfo.getMainClass()).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            module.setModuleInfo(moduleInfo);
            module.setModuleStatus(ModuleStatus.NOT_LOADED);
            module.setModuleConfig(moduleConfig);
            Object object = this.moduleClassLoaders;
            synchronized (object) {
                this.moduleClassLoaders.add(moduleClassLoader);
            }
            object = Optional.of(module);
            return object;
        }
        catch (IOException exception) {
            log.error("Failed to read module: {}", (Object)moduleFile.getFileName(), (Object)exception);
            return Optional.empty();
        }
        catch (ClassNotFoundException exception) {
            log.error("Could not find main class for module: {}", (Object)moduleFile.getFileName(), (Object)exception);
            return Optional.empty();
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
            log.error("Could not create module instance for module: {} (does the main class have public no-args constructor?)", (Object)moduleFile.getFileName(), (Object)exception);
            return Optional.empty();
        }
        catch (Throwable exception) {
            log.error("Failed to load module: {}", (Object)moduleFile.getFileName(), (Object)exception);
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadModule(Module<?> module) {
        String moduleName = module.getModuleInfo().getName();
        if (module.getModuleStatus() != ModuleStatus.NOT_LOADED) {
            log.warn("Tried loading module {}, which does not have status of NOT_LOADED!", (Object)moduleName);
            return;
        }
        log.info("Loading module {}...", (Object)moduleName);
        module.setModuleStatus(ModuleStatus.LOADING);
        try {
            module.onLoad();
        }
        catch (Exception exception) {
            log.error("Exception occurred while loading module {}!", (Object)moduleName, (Object)exception);
            module.setModuleStatus(ModuleStatus.FAILED);
            List<ClassLoader> list = this.moduleClassLoaders;
            synchronized (list) {
                this.moduleClassLoaders.remove(module.getClass().getClassLoader());
            }
            return;
        }
        log.info("Module {} loaded successfully.", (Object)moduleName);
        module.setModuleStatus(ModuleStatus.LOADED);
        this.modules.add(module);
    }

    public void enableModules() {
        log.info("Enabling {} modules...", (Object)this.modules.size());
        this.modules.forEach(module -> {
            try {
                this.enableModule((Module<?>)module);
            }
            catch (StackOverflowError stackOverflowError) {
                String moduleName = module.getModuleInfo().getName();
                String depend = Arrays.toString(module.getModuleInfo().getDepend());
                String softDepend = Arrays.toString(module.getModuleInfo().getSoftDepend());
                log.error("StackOverflowError occurred while loading module {}! It depends on {}, soft-depends on {}", (Object)moduleName, (Object)depend, (Object)softDepend);
                this.unloadModule((Module<?>)module);
            }
        });
        log.debug("Unloading modules that failed to enable, if any...");
        this.modules.forEach(module -> {
            if (module.getModuleStatus() != ModuleStatus.ENABLED) {
                this.unloadModule((Module<?>)module);
            }
        });
        log.info("Enabled {} modules successfully.", (Object)this.modules.size());
    }

    public void enableModule(Module<?> module) {
        Optional<Module<?>> optionalDependentModule;
        if (module.getModuleStatus() == ModuleStatus.ENABLED) {
            return;
        }
        ModuleInfo moduleInfo = module.getModuleInfo();
        for (String dependentName : moduleInfo.getDepend()) {
            optionalDependentModule = this.getModuleByName(dependentName);
            if (optionalDependentModule.isEmpty()) {
                log.error("Module {} specified {} as dependent but the module is not loaded!", (Object)moduleInfo.getName(), (Object)dependentName);
                return;
            }
            this.enableModule(optionalDependentModule.get());
        }
        for (String dependentModule : moduleInfo.getSoftDepend()) {
            optionalDependentModule = this.getModuleByName(dependentModule);
            if (optionalDependentModule.isEmpty()) {
                log.warn("Module {} specified {} as soft-dependent but the module is not loaded.", (Object)moduleInfo.getName(), (Object)dependentModule);
                continue;
            }
            this.enableModule(optionalDependentModule.get());
        }
        log.info("Enabling module {}...", (Object)moduleInfo.getName());
        module.setModuleStatus(ModuleStatus.ENABLING);
        try {
            module.onEnable();
        }
        catch (Exception exception) {
            log.error("Failed to enable module {}!", (Object)moduleInfo.getName(), (Object)exception);
            this.unloadModule(module);
            return;
        }
        log.info("Module {} enabled successfully.", (Object)moduleInfo.getName());
        module.setModuleStatus(ModuleStatus.ENABLED);
    }

    public void unloadModules() {
        if (this.modules.isEmpty()) {
            return;
        }
        this.modules.forEach(this::unloadModule);
        log.info("Unloaded {} modules successfully.", (Object)this.modules.size());
    }

    public void unloadModule(Module<?> module) {
        String moduleName = module.getModuleInfo().getName();
        switch (module.getModuleStatus()) {
            case NOT_LOADED: {
                log.warn("Tried unloading module ({}) which is not loaded!", (Object)moduleName);
                break;
            }
            case LOADED: 
            case ENABLING: 
            case DISABLED: {
                log.info("Unloading module {}...", (Object)moduleName);
                module.setModuleStatus(ModuleStatus.UNLOADING);
                try {
                    module.onUnload();
                }
                catch (Exception unloadException) {
                    log.error("Exception occurred while unloading module {}!", (Object)moduleName, (Object)unloadException);
                }
                module.setModuleStatus(ModuleStatus.NOT_LOADED);
                log.info("Module {} unloaded successfully.", (Object)moduleName);
                break;
            }
            case ENABLED: {
                log.info("Disabling module {}...", (Object)moduleName);
                module.setModuleStatus(ModuleStatus.DISABLING);
                try {
                    module.onDisable();
                }
                catch (Exception disableException) {
                    log.error("Exception occurred while disabling module {}!", (Object)moduleName, (Object)disableException);
                }
                module.setModuleStatus(ModuleStatus.DISABLED);
                log.info("Module {} disabled successfully.", (Object)moduleName);
                this.unloadModule(module);
            }
        }
    }

    public void processCommandClientBuilder(CommandClientBuilder commandClientBuilder) {
        this.modules.forEach(module -> module.onCommandClientBuilderInitialization(commandClientBuilder));
    }

    public void processGanyu(Ganyu ganyu) {
        this.modules.forEach(module -> module.onConsoleCommandRegistration(ganyu));
    }

    public void processShardBuilder(DefaultShardManagerBuilder shardManagerBuilder) {
        this.modules.forEach(module -> module.onShardManagerBuilderInitialization(shardManagerBuilder));
    }

    public void processException(Throwable throwable) {
        this.modules.forEach(module -> {
            try {
                for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
                    for (String packageName : module.getModuleInfo().getExceptionHandlingPackages()) {
                        if (!stackTraceElement.getClassName().contains(packageName)) continue;
                        module.onUncaughtException(throwable);
                        return;
                    }
                }
            }
            catch (Exception exception) {
                log.error("Exception occurred while processing modules with uncaught exception!", (Throwable)exception);
            }
        });
    }
}

