/*
 * Decompiled with CFR 0.152.
 */
package enterprises.iwakura.sigewine.aop.sentry;

import enterprises.iwakura.sigewine.aop.MethodWrapper;
import enterprises.iwakura.sigewine.aop.sentry.SentryTransaction;
import enterprises.iwakura.sigewine.aop.sentry.TransactionConfigurator;
import io.sentry.ISpan;
import io.sentry.ITransaction;
import io.sentry.Sentry;
import io.sentry.SentryTracer;
import io.sentry.SpanOptions;
import io.sentry.SpanStatus;
import io.sentry.TransactionOptions;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SentryTransactionMethodWrapper
extends MethodWrapper<SentryTransaction> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SentryTransactionMethodWrapper.class);
    private static final ThreadLocal<ISpan> spanThreadLocal = new ThreadLocal();
    private static final Map<Class<? extends TransactionConfigurator>, TransactionConfigurator> configuratorCache = new ConcurrentHashMap<Class<? extends TransactionConfigurator>, TransactionConfigurator>();

    public SentryTransactionMethodWrapper() {
        super(SentryTransaction.class);
    }

    protected void beforeInvocation(Object target, Method method, Object[] args, SentryTransaction annotation, Object proxy) {
        ITransaction span;
        ITransaction currentTransaction = Sentry.getCurrentScopes().getTransaction();
        if (annotation.onlySpan() && currentTransaction == null) {
            return;
        }
        TransactionOptions txOptions = new TransactionOptions();
        TransactionConfigurator configurator = this.getConfigurator(annotation);
        txOptions.setBindToScope(annotation.bindToScope());
        configurator.configure(annotation, txOptions, target.getClass(), method, args);
        String spanName = this.getName(annotation, target.getClass(), method);
        if (currentTransaction == null) {
            span = Sentry.startTransaction((String)spanName, (String)annotation.operation(), (TransactionOptions)txOptions);
            log.debug("Started new transaction: {}", (Object)spanName);
        } else {
            span = currentTransaction.startChild(spanName, annotation.operation(), (SpanOptions)txOptions);
            log.debug("Started child span: {} in transaction: {}", (Object)spanName, (Object)currentTransaction.getName());
        }
        if (!annotation.bindToScope()) {
            spanThreadLocal.set((ISpan)span);
        }
    }

    protected void afterInvocation(Object target, Method method, Object[] args, SentryTransaction annotation, Optional<Object> optionalResult, Optional<Throwable> optionalThrowable, Object proxy) {
        String name;
        ISpan span;
        if (annotation.bindToScope()) {
            span = Sentry.getSpan();
        } else {
            span = spanThreadLocal.get();
            spanThreadLocal.remove();
        }
        if (span == null) {
            log.warn("No span found for transaction. This might happen if the method was called without an active transaction or span.");
            return;
        }
        if (optionalThrowable.isPresent() && annotation.captureExceptions()) {
            span.setThrowable(optionalThrowable.get());
        }
        span.finish(optionalThrowable.isPresent() ? SpanStatus.INTERNAL_ERROR : SpanStatus.OK);
        if (span instanceof SentryTracer) {
            SentryTracer sentryTracer = (SentryTracer)span;
            name = sentryTracer.getName();
        } else {
            name = span.getOperation();
        }
        log.debug("Finished span {} with status {}", (Object)name, (Object)span.getStatus());
    }

    private TransactionConfigurator getConfigurator(SentryTransaction annotation) {
        return configuratorCache.computeIfAbsent(annotation.configurator(), clazz -> {
            try {
                return (TransactionConfigurator)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception exception) {
                throw new RuntimeException("Failed to instantiate configurator " + clazz.getName() + " (missing no-arg constructor?)", exception);
            }
        });
    }

    private String getName(SentryTransaction annotation, Class<?> callerClass, Method callerMethod) {
        if (!annotation.name().equals("$default-name$")) {
            return annotation.name();
        }
        return callerClass.getSimpleName() + "#" + callerMethod.getName() + "()";
    }

    @Generated
    public static ThreadLocal<ISpan> getSpanThreadLocal() {
        return spanThreadLocal;
    }
}

