/*
 * Decompiled with CFR 0.152.
 */
package enterprises.iwakura.sigewine.aop;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;

public abstract class MethodWrapper<T extends Annotation> {
    private final Class<T> annotationClass;
    private final Map<Class<?>, Map<String, Annotation>> annotatedMethodsCache = new ConcurrentHashMap();

    public MethodWrapper(Class<T> annotationClass) {
        this.annotationClass = annotationClass;
    }

    protected abstract void beforeInvocation(Object var1, Method var2, Object[] var3, T var4, Object var5);

    protected abstract void afterInvocation(Object var1, Method var2, Object[] var3, T var4, Optional<Object> var5, Optional<Throwable> var6, Object var7);

    void beforeInvocationInternal(Object target, Method method, Object[] args, Annotation annotation, Object proxy) {
        T castedAnnotation = this.castAnnotationObject(annotation);
        this.beforeInvocation(target, method, args, castedAnnotation, proxy);
    }

    void afterInvocationInternal(Object target, Method method, Object[] args, Annotation annotation, Optional<Object> optionalResult, Optional<Throwable> optionalThrowable, Object proxy) {
        T castedAnnotation = this.castAnnotationObject(annotation);
        this.afterInvocation(target, method, args, castedAnnotation, optionalResult, optionalThrowable, proxy);
    }

    private T castAnnotationObject(Object annotation) {
        if (this.annotationClass.isInstance(annotation)) {
            return (T)((Annotation)this.annotationClass.cast(annotation));
        }
        throw new IllegalArgumentException("Annotation is not of type " + this.annotationClass.getName());
    }

    public Map<String, Annotation> getAnnotatedMethods(Object target) {
        Map<String, Annotation> cachedMethods = this.annotatedMethodsCache.get(target.getClass());
        if (cachedMethods != null) {
            return cachedMethods;
        }
        ConcurrentHashMap<String, Annotation> map = new ConcurrentHashMap<String, Annotation>();
        if (target.getClass().isAnnotationPresent(this.annotationClass)) {
            T classAnnotation = target.getClass().getAnnotation(this.annotationClass);
            Method[] methodArray = target.getClass().getDeclaredMethods();
            int n = methodArray.length;
            for (int i = 0; i < n; ++i) {
                Method method = methodArray[i];
                map.put(method.getName(), (Annotation)classAnnotation);
            }
        }
        for (Method method : target.getClass().getDeclaredMethods()) {
            if (!method.isAnnotationPresent(this.annotationClass)) continue;
            map.put(method.getName(), (Annotation)method.getAnnotation(this.annotationClass));
        }
        this.annotatedMethodsCache.put(target.getClass(), map);
        return map;
    }

    @Generated
    public Class<T> getAnnotationClass() {
        return this.annotationClass;
    }

    @Generated
    public Map<Class<?>, Map<String, Annotation>> getAnnotatedMethodsCache() {
        return this.annotatedMethodsCache;
    }
}

