/*
 * Decompiled with CFR 0.152.
 */
package enterprises.iwakura.sigewine.aop;

import enterprises.iwakura.sigewine.aop.MethodWrapper;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;

public final class SigewineInvocationHandler
implements InvocationHandler {
    private final Collection<MethodWrapper<? extends Annotation>> methodWrappers;
    private final Object target;

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Annotation annotation;
        Map<String, Annotation> annotatedMethods;
        Optional<Object> optionalResult = Optional.empty();
        Optional<Object> optionalThrowable = Optional.empty();
        for (MethodWrapper<? extends Annotation> methodWrapper : this.methodWrappers) {
            annotatedMethods = methodWrapper.getAnnotatedMethods(this.target);
            if (annotatedMethods.isEmpty() || (annotation = annotatedMethods.get(method.getName())) == null) continue;
            methodWrapper.beforeInvocationInternal(this.target, method, args, annotation, proxy);
        }
        try {
            optionalResult = Optional.ofNullable(method.invoke(this.target, args));
        }
        catch (Throwable throwable) {
            optionalThrowable = Optional.of(throwable);
        }
        for (MethodWrapper<? extends Annotation> methodWrapper : this.methodWrappers) {
            annotatedMethods = methodWrapper.getAnnotatedMethods(this.target);
            if (annotatedMethods.isEmpty() || (annotation = annotatedMethods.get(method.getName())) == null) continue;
            methodWrapper.afterInvocationInternal(this.target, method, args, annotation, optionalResult, optionalThrowable, proxy);
        }
        if (optionalThrowable.isPresent()) {
            throw (Throwable)optionalThrowable.get();
        }
        return optionalResult.orElse(null);
    }

    @Generated
    public SigewineInvocationHandler(Collection<MethodWrapper<? extends Annotation>> methodWrappers, Object target) {
        this.methodWrappers = methodWrappers;
        this.target = target;
    }
}

