/*
 * Decompiled with CFR 0.152.
 */
package enterprises.iwakura.sigewine.utils;

import enterprises.iwakura.sigewine.annotations.RomaritimeBean;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public final class Preconditions {
    private Preconditions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static void checkNoArgConstructor(Class<?> clazz) {
        if (clazz.getConstructors().length == 0) {
            throw new IllegalArgumentException("Class " + clazz.getName() + " has no constructor");
        }
        boolean hasNoArgsConstructor = false;
        for (Constructor<?> constructor : clazz.getConstructors()) {
            if (constructor.getParameterCount() != 0) continue;
            hasNoArgsConstructor = true;
            break;
        }
        if (!hasNoArgsConstructor) {
            throw new IllegalArgumentException("Class " + clazz.getName() + " has no no-arg constructor");
        }
    }

    public static void checkOneConstructor(Class<?> clazz) {
        if (clazz.getConstructors().length != 1) {
            throw new IllegalArgumentException("Class " + clazz.getName() + " must have exactly one constructor");
        }
    }

    public static void checkNoVoidReturnType(Method method) {
        if (method.getReturnType() == Void.TYPE) {
            throw new IllegalArgumentException("Method " + String.valueOf(method) + " cannot have a void return type");
        }
    }

    public static void checkNoPrimitiveReturnType(Method method) {
        if (method.getReturnType().isPrimitive()) {
            throw new IllegalArgumentException("Method " + String.valueOf(method) + " cannot have a primitive return type");
        }
    }

    public static void checkAnnotated(Class<?> clazz, Class<RomaritimeBean> romaritimeClass) {
        if (!clazz.isAnnotationPresent(romaritimeClass)) {
            throw new IllegalArgumentException("Class " + clazz.getName() + " is not annotated with " + romaritimeClass.getName());
        }
    }

    public static <E> void isOfType(Object object, Class<E> type) {
        if (!type.isInstance(object)) {
            throw new IllegalArgumentException("Object " + String.valueOf(object) + " is not of type " + type.getName());
        }
    }
}

