package enterprises.iwakura.sigewine;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import org.slf4j.event.Level;

/**
 * Holds configuration options for {@link Sigewine}.
 */
@Getter
@AllArgsConstructor
@Builder
public class SigewineOptions {

    /**
     * The log level for the {@link Sigewine}.
     * <p>
     * This determines the verbosity of logs generated by the framework.
     * Default is {@link Level#DEBUG}.
     * </p>
     */
    protected Level logLevel;

    /**
     * Default constructor for {@link SigewineOptions}.
     */
    public SigewineOptions() {
        this.logLevel = Level.DEBUG;
    }
}
