/*
 * Decompiled with CFR 0.152.
 */
package enterprises.iwakura.sigewine;

import enterprises.iwakura.sigewine.SigewineOptions;
import enterprises.iwakura.sigewine.annotations.RomaritimeBean;
import enterprises.iwakura.sigewine.utils.Preconditions;
import enterprises.iwakura.sigewine.utils.collections.TypedCollection;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import lombok.Generated;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.Scanners;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sigewine {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Sigewine.class);
    protected final SigewineOptions sigewineOptions;
    protected final Map<String, Object> beans = new HashMap<String, Object>();
    protected final List<Class<?>> initializeLaterMethodBeans = new ArrayList();
    protected final Map<Class<?>, Object> methodBeanDeclaringClassCache = new HashMap();

    public Sigewine(SigewineOptions sigewineOptions) {
        this.sigewineOptions = sigewineOptions;
    }

    public void treatment(Class<?> clazz) {
        this.treatment(clazz.getPackageName(), clazz.getClassLoader());
    }

    public synchronized void treatment(String packageName, ClassLoader classLoader) {
        log.atLevel(this.sigewineOptions.getLogLevel()).log("Scanning package '{}' for classes annotated with @Romaritime", (Object)packageName);
        ConfigurationBuilder config = new ConfigurationBuilder().setUrls(ClasspathHelper.forPackage((String)packageName, (ClassLoader[])new ClassLoader[]{classLoader})).setScanners(new Scanner[]{Scanners.TypesAnnotated, Scanners.MethodsAnnotated}).filterInputsBy((Predicate)new FilterBuilder().includePackage(packageName));
        config.setClassLoaders(new ClassLoader[]{classLoader});
        Reflections reflections = new Reflections((Configuration)config);
        Set annotatedClasses = reflections.getTypesAnnotatedWith(RomaritimeBean.class);
        Set annotatedMethods = reflections.getMethodsAnnotatedWith(RomaritimeBean.class);
        log.atLevel(this.sigewineOptions.getLogLevel()).log("Found '{}' classes annotated with @Romaritime", (Object)annotatedClasses.size());
        log.atLevel(this.sigewineOptions.getLogLevel()).log("Found '{}' methods annotated with @Romaritime", (Object)annotatedMethods.size());
        log.atLevel(this.sigewineOptions.getLogLevel()).log("Registering methods annotated with @Romaritime");
        for (Method method : annotatedMethods) {
            this.registerMethodBean(method);
        }
        log.atLevel(this.sigewineOptions.getLogLevel()).log("Initializing later-initialization method beans");
        for (Class clazz : this.initializeLaterMethodBeans) {
            Method[] beanMethods;
            log.atLevel(this.sigewineOptions.getLogLevel()).log("Initializing method beans for class '{}'", (Object)clazz.getName());
            this.registerClassBean(clazz, false);
            log.atLevel(this.sigewineOptions.getLogLevel()).log("Going through methods of class '{}'", (Object)clazz.getName());
            for (Method beanMethod : beanMethods = clazz.getDeclaredMethods()) {
                if (!beanMethod.isAnnotationPresent(RomaritimeBean.class)) continue;
                this.registerMethodBean(beanMethod);
            }
        }
        this.initializeLaterMethodBeans.clear();
        log.atLevel(this.sigewineOptions.getLogLevel()).log("Registering classes annotated with @Romaritime");
        for (Class clazz : annotatedClasses) {
            this.registerClassBean(clazz, false);
        }
        log.atLevel(this.sigewineOptions.getLogLevel()).log("Going through beans to inject beans into TypedCollections");
        for (Map.Entry entry : this.beans.entrySet()) {
            Field[] declaredFields;
            String beanName = (String)entry.getKey();
            Object bean = entry.getValue();
            log.atLevel(this.sigewineOptions.getLogLevel()).log("Going through bean '{}': '{}'", (Object)beanName, bean);
            for (Field field : declaredFields = bean.getClass().getDeclaredFields()) {
                boolean annotationPresent = field.isAnnotationPresent(RomaritimeBean.class);
                boolean isCollection = Collection.class.isAssignableFrom(field.getType());
                if (!annotationPresent || !isCollection) continue;
                boolean wasAccessible = field.canAccess(bean);
                field.setAccessible(true);
                Object collectionObject = field.get(bean);
                if (!(collectionObject instanceof TypedCollection)) {
                    log.atLevel(this.sigewineOptions.getLogLevel()).log("Field '{}' is collection, but is not instance of TypedCollection. Ignoring", (Object)field.getName());
                    continue;
                }
                TypedCollection collection = (TypedCollection)collectionObject;
                Class collectionType = collection.getType();
                if (collectionType == null) {
                    throw new IllegalArgumentException("Field " + field.getName() + " must have a type");
                }
                if (collectionType.isAssignableFrom(TypedCollection.class)) {
                    throw new IllegalArgumentException("Type of TypedCollection " + field.getName() + " cannot be a TypedCollection");
                }
                Set<Object> beansToInject = this.getAllBeansThatAreAssignableFrom(collectionType);
                log.atLevel(this.sigewineOptions.getLogLevel()).log("Injecting '{}' beans into bean named '{}' for collection named '{}' of type '{}'", new Object[]{beansToInject.size(), beanName, field.getName(), collectionType.getName()});
                beansToInject.forEach(collection::addTypedObject);
                field.setAccessible(wasAccessible);
            }
        }
        log.atLevel(this.sigewineOptions.getLogLevel()).log("Finished scanning package '{}', bean count: '{}'", (Object)packageName, (Object)this.beans.size());
    }

    public <T> T syringe(Class<T> clazz) {
        return this.syringeInternal(clazz, c -> {
            throw new IllegalArgumentException("No bean found for class " + c.getName());
        });
    }

    protected <T> T syringeInternal(Class<T> clazz, Function<Class<?>, Object> onUnknownBean) {
        String beanName = this.getBeanName(clazz.getAnnotation(RomaritimeBean.class), clazz.getName());
        if (this.beans.containsKey(beanName)) {
            Object beanObject = this.beans.get(beanName);
            if (!clazz.isAssignableFrom(beanObject.getClass())) {
                throw new IllegalArgumentException("Bug! Bean " + beanName + " is not of type " + clazz.getName());
            }
            log.atLevel(this.sigewineOptions.getLogLevel()).log("Returning registered bean '{}' of class '{}': '{}'", new Object[]{beanName, clazz.getName(), beanObject});
            return clazz.cast(this.beans.get(beanName));
        }
        log.atLevel(this.sigewineOptions.getLogLevel()).log("Injecting beans into class bean '{}' of class '{}'", (Object)beanName, (Object)clazz.getName());
        Preconditions.checkOneConstructor(clazz);
        Constructor<?> constructor = clazz.getConstructors()[0];
        Parameter[] parameters = constructor.getParameters();
        Object[] args = new Object[parameters.length];
        log.atLevel(this.sigewineOptions.getLogLevel()).log("Found '{}' parameters for bean '{}' of class '{}': '{}'", new Object[]{parameters.length, beanName, clazz.getName(), parameters});
        for (int i = 0; i < parameters.length; ++i) {
            Object argInstance;
            Parameter parameter = parameters[i];
            RomaritimeBean romaritimeAnnotation = parameter.getAnnotation(RomaritimeBean.class);
            Class<?> parameterType = parameter.getType();
            String parameterName = parameter.getName();
            if (romaritimeAnnotation != null && !romaritimeAnnotation.name().isBlank() && this.beans.containsKey(romaritimeAnnotation.name())) {
                argInstance = this.beans.get(romaritimeAnnotation.name());
            } else if (this.beans.containsKey(parameterType.getName())) {
                argInstance = this.beans.get(parameterType.getName());
            } else if (this.beans.containsKey(parameterName)) {
                argInstance = this.beans.get(parameterName);
            } else {
                log.atLevel(this.sigewineOptions.getLogLevel()).log("No bean found for parameter '{}' of type '{}' in class '{}', using onUnknownBean function", new Object[]{parameterName, parameterType.getName(), clazz.getName()});
                argInstance = onUnknownBean.apply(parameterType);
            }
            args[i] = argInstance;
        }
        log.atLevel(this.sigewineOptions.getLogLevel()).log("Resolved '{}' args for bean '{}' of class '{}', creating instance: '{}'", new Object[]{args.length, beanName, clazz.getName(), args});
        return clazz.cast(constructor.newInstance(args));
    }

    protected void registerMethodBean(Method method) {
        RomaritimeBean romaritime = method.getAnnotation(RomaritimeBean.class);
        Class<?> declaringClass = method.getDeclaringClass();
        Class<?> returnType = method.getReturnType();
        Preconditions.checkNoVoidReturnType(method);
        Preconditions.checkNoPrimitiveReturnType(method);
        String beanName = this.getBeanName(romaritime, returnType.getName());
        log.atLevel(this.sigewineOptions.getLogLevel()).log("Registering method '{}' of declaring class '{}' as bean '{}'", new Object[]{method, method.getDeclaringClass(), beanName});
        if (this.beans.containsKey(beanName)) {
            throw new IllegalArgumentException("Class " + returnType.getName() + " already registered as " + beanName);
        }
        Object beanClassInstance = this.methodBeanDeclaringClassCache.computeIfAbsent(declaringClass, clazz -> {
            boolean hasNoArgConstructor = Arrays.stream(clazz.getConstructors()).anyMatch(constructor -> constructor.getParameterCount() == 0);
            if (hasNoArgConstructor) {
                try {
                    return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception exception) {
                    throw new RuntimeException("Failed to create instance of " + clazz.getName() + " for bean " + beanName + " (nos no-args constructor?)", exception);
                }
            }
            try {
                return this.syringeInternal((Class)clazz, otherClass -> {
                    throw new IllegalStateException();
                });
            }
            catch (IllegalStateException ignored) {
                log.atLevel(this.sigewineOptions.getLogLevel()).log("Class '{}' has no no-args constructor, will be initialized later", (Object)clazz.getName());
                this.initializeLaterMethodBeans.add((Class<?>)clazz);
                return null;
            }
        });
        if (beanClassInstance != null) {
            Object beanInstance = method.invoke(beanClassInstance, new Object[0]);
            if (beanInstance == null) {
                throw new IllegalArgumentException("Method " + String.valueOf(method) + " cannot return null");
            }
            this.registerBeanWithInstance(returnType, beanName, beanInstance);
        }
    }

    protected void registerClassBean(Class<?> clazz, boolean ignoreDuplicates) {
        String beanName = this.getBeanName(clazz.getAnnotation(RomaritimeBean.class), clazz.getName());
        if (this.beans.containsKey(beanName)) {
            if (ignoreDuplicates) {
                log.atLevel(this.sigewineOptions.getLogLevel()).log("Class '{}' already registered as '{}', ignoring per ignoreDuplicates", (Object)clazz.getName(), (Object)beanName);
                return;
            }
            if (this.beans.get(beanName).getClass() == clazz) {
                log.atLevel(this.sigewineOptions.getLogLevel()).log("Class '{}' already registered as '{}', ignoring per same class instance", (Object)clazz.getName(), (Object)beanName);
                return;
            }
            throw new IllegalArgumentException("Class " + clazz.getName() + " already registered as " + beanName);
        }
        Constructor<?>[] constructors = clazz.getConstructors();
        if (constructors.length == 1 && constructors[0].getParameters().length == 0) {
            this.registerBeanWithInstance(clazz, beanName, clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
            return;
        }
        Preconditions.checkOneConstructor(clazz);
        Object beanClassInstance = this.syringeInternal(clazz, this::recursiveOnUnknownBean);
        if (beanClassInstance == null) {
            throw new IllegalArgumentException("Class " + clazz.getName() + " cannot return null");
        }
        this.registerBeanWithInstance(clazz, beanName, beanClassInstance);
    }

    protected void registerBeanWithInstance(Class<?> clazz, String beanName, Object instance) {
        if (this.beans.containsKey(beanName)) {
            throw new IllegalArgumentException("Class " + instance.getClass().getName() + " already registered as " + beanName);
        }
        log.atLevel(this.sigewineOptions.getLogLevel()).log("Registering bean '{}' of class '{}'", (Object)beanName, (Object)clazz.getName());
        this.beans.put(beanName, instance);
    }

    protected Object recursiveOnUnknownBean(Class<?> clazz) {
        if (Collection.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Cannot inject collection of type " + clazz.getName() + ", please use TypedCollection");
        }
        Preconditions.checkAnnotated(clazz, RomaritimeBean.class);
        String beanName = this.getBeanName(clazz.getAnnotation(RomaritimeBean.class), clazz.getName());
        log.atLevel(this.sigewineOptions.getLogLevel()).log("Recursively injecting beans into class bean '{}' of class '{}'", (Object)beanName, (Object)clazz.getName());
        if (this.beans.containsKey(beanName)) {
            log.atLevel(this.sigewineOptions.getLogLevel()).log("Returning already registered bean '{}' of class '{}': '{}'", new Object[]{beanName, clazz.getName(), this.beans.get(beanName)});
            return this.beans.get(beanName);
        }
        this.registerClassBean(clazz, true);
        return this.syringeInternal(clazz, this::recursiveOnUnknownBean);
    }

    protected String getBeanName(RomaritimeBean romaritimeBean, String defaultName) {
        if (romaritimeBean != null && !romaritimeBean.name().isBlank()) {
            return romaritimeBean.name();
        }
        return defaultName;
    }

    protected Set<Object> getAllBeansThatAreAssignableFrom(Class<?> clazz) {
        HashSet<Object> beans = new HashSet<Object>();
        for (Map.Entry<String, Object> entry : this.beans.entrySet()) {
            if (!clazz.isAssignableFrom(entry.getValue().getClass())) continue;
            beans.add(entry.getValue());
        }
        return beans;
    }

    @Generated
    public SigewineOptions getSigewineOptions() {
        return this.sigewineOptions;
    }

    @Generated
    public Map<String, Object> getBeans() {
        return this.beans;
    }

    @Generated
    public List<Class<?>> getInitializeLaterMethodBeans() {
        return this.initializeLaterMethodBeans;
    }

    @Generated
    public Map<Class<?>, Object> getMethodBeanDeclaringClassCache() {
        return this.methodBeanDeclaringClassCache;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Sigewine)) {
            return false;
        }
        Sigewine other = (Sigewine)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SigewineOptions this$sigewineOptions = this.getSigewineOptions();
        SigewineOptions other$sigewineOptions = other.getSigewineOptions();
        if (this$sigewineOptions == null ? other$sigewineOptions != null : !this$sigewineOptions.equals(other$sigewineOptions)) {
            return false;
        }
        Map<String, Object> this$beans = this.getBeans();
        Map<String, Object> other$beans = other.getBeans();
        if (this$beans == null ? other$beans != null : !((Object)this$beans).equals(other$beans)) {
            return false;
        }
        List<Class<?>> this$initializeLaterMethodBeans = this.getInitializeLaterMethodBeans();
        List<Class<?>> other$initializeLaterMethodBeans = other.getInitializeLaterMethodBeans();
        if (this$initializeLaterMethodBeans == null ? other$initializeLaterMethodBeans != null : !((Object)this$initializeLaterMethodBeans).equals(other$initializeLaterMethodBeans)) {
            return false;
        }
        Map<Class<?>, Object> this$methodBeanDeclaringClassCache = this.getMethodBeanDeclaringClassCache();
        Map<Class<?>, Object> other$methodBeanDeclaringClassCache = other.getMethodBeanDeclaringClassCache();
        return !(this$methodBeanDeclaringClassCache == null ? other$methodBeanDeclaringClassCache != null : !((Object)this$methodBeanDeclaringClassCache).equals(other$methodBeanDeclaringClassCache));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Sigewine;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SigewineOptions $sigewineOptions = this.getSigewineOptions();
        result = result * 59 + ($sigewineOptions == null ? 43 : $sigewineOptions.hashCode());
        Map<String, Object> $beans = this.getBeans();
        result = result * 59 + ($beans == null ? 43 : ((Object)$beans).hashCode());
        List<Class<?>> $initializeLaterMethodBeans = this.getInitializeLaterMethodBeans();
        result = result * 59 + ($initializeLaterMethodBeans == null ? 43 : ((Object)$initializeLaterMethodBeans).hashCode());
        Map<Class<?>, Object> $methodBeanDeclaringClassCache = this.getMethodBeanDeclaringClassCache();
        result = result * 59 + ($methodBeanDeclaringClassCache == null ? 43 : ((Object)$methodBeanDeclaringClassCache).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Sigewine(sigewineOptions=" + String.valueOf(this.getSigewineOptions()) + ", beans=" + String.valueOf(this.getBeans()) + ", initializeLaterMethodBeans=" + String.valueOf(this.getInitializeLaterMethodBeans()) + ", methodBeanDeclaringClassCache=" + String.valueOf(this.getMethodBeanDeclaringClassCache()) + ")";
    }
}

