/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.chunk;

import com.google.common.io.Files;
import eus.ixa.ixa.pipe.chunk.Annotate;
import eus.ixa.ixa.pipe.chunk.eval.CrossValidator;
import eus.ixa.ixa.pipe.chunk.eval.Evaluate;
import eus.ixa.ixa.pipe.chunk.train.DefaultTrainer;
import eus.ixa.ixa.pipe.chunk.train.Flags;
import eus.ixa.ixa.pipe.chunk.train.InputOutputUtils;
import ixa.kaflib.KAFDocument;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Properties;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;
import opennlp.tools.chunker.ChunkerModel;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.util.TrainingParameters;
import org.jdom2.JDOMException;

public class CLI {
    private final String version = CLI.class.getPackage().getImplementationVersion();
    private final String commit = CLI.class.getPackage().getSpecificationVersion();
    private Namespace parsedArguments = null;
    private ArgumentParser argParser = ArgumentParsers.newArgumentParser("ixa-pipe-chunk-" + this.version + ".jar").description("ixa-pipe-chunk-" + this.version + " is a multilingual chunker developed by IXA NLP Group.\n");
    private Subparsers subParsers = this.argParser.addSubparsers().help("sub-command help");
    private Subparser annotateParser = this.subParsers.addParser("tag").help("Tagging CLI");
    private Subparser trainParser;
    private Subparser evalParser;
    private final Subparser crossValidateParser;
    public static final int DEFAULT_BEAM_SIZE = 3;

    public CLI() {
        this.loadAnnotateParameters();
        this.trainParser = this.subParsers.addParser("train").help("Training CLI");
        this.loadTrainingParameters();
        this.evalParser = this.subParsers.addParser("eval").help("Evaluation CLI");
        this.loadEvalParameters();
        this.crossValidateParser = this.subParsers.addParser("cross").help("Cross validation CLI");
        this.loadCrossValidateParameters();
    }

    public static void main(String[] args) throws IOException, JDOMException {
        CLI cmdLine = new CLI();
        cmdLine.parseCLI(args);
    }

    public final void parseCLI(String[] args) throws IOException, JDOMException {
        try {
            this.parsedArguments = this.argParser.parseArgs(args);
            System.err.println("CLI options: " + this.parsedArguments);
            if (args[0].equals("tag")) {
                this.annotate(System.in, System.out);
            } else if (args[0].equals("eval")) {
                this.eval();
            } else if (args[0].equals("train")) {
                this.train();
            } else if (args[0].equals("cross")) {
                this.crossValidate();
            }
        }
        catch (ArgumentParserException e) {
            this.argParser.handleError(e);
            System.out.println("Run java -jar target/ixa-pipe-chunk-" + this.version + ".jar (tag|train|eval|cross) -help for details");
            System.exit(1);
        }
    }

    public final void annotate(InputStream inputStream, OutputStream outputStream) throws IOException, JDOMException {
        String lang;
        String model = this.parsedArguments.get("model") == null ? "baseline" : this.parsedArguments.getString("model");
        String outputFormat = (String)this.parsedArguments.get("outputFormat");
        BufferedReader breader = null;
        BufferedWriter bwriter = null;
        breader = new BufferedReader(new InputStreamReader(System.in, "UTF-8"));
        bwriter = new BufferedWriter(new OutputStreamWriter((OutputStream)System.out, "UTF-8"));
        KAFDocument kaf = KAFDocument.createFromStream(breader);
        if (this.parsedArguments.getString("language") != null) {
            lang = this.parsedArguments.getString("language");
            if (!kaf.getLang().equalsIgnoreCase(lang)) {
                System.err.println("Language parameter in NAF and CLI do not match!!");
                System.exit(1);
            }
        } else {
            lang = kaf.getLang();
        }
        Properties properties = this.setAnnotateProperties(model, lang);
        Annotate annotator = new Annotate(properties);
        if (outputFormat.equalsIgnoreCase("conll")) {
            bwriter.write(annotator.annotateChunksToCoNLL(kaf));
        } else {
            KAFDocument.LinguisticProcessor newLp = kaf.addLinguisticProcessor("terms", "ixa-pipe-chunk-" + Files.getNameWithoutExtension(model) + this.version + "-" + this.commit);
            newLp.setBeginTimestamp();
            annotator.chunkToKAF(kaf);
            newLp.setEndTimestamp();
            bwriter.write(kaf.toString());
        }
        bwriter.close();
        breader.close();
    }

    private void loadAnnotateParameters() {
        this.annotateParser.addArgument("-m", "--model").required(true).help("Choose model to perform chunk tagging.");
        this.annotateParser.addArgument("-l", "--lang").choices("en").required(false).help("Choose a language to perform annotation with ixa-pipe-chunk.");
        this.annotateParser.addArgument("-o", "--outputFormat").required(false).choices("naf", "conll").setDefault("naf").help("Choose between NAF and conll format; it defaults to NAF.\n");
    }

    public final void train() throws IOException {
        String paramFile = this.parsedArguments.getString("params");
        TrainingParameters params = InputOutputUtils.loadTrainingParameters(paramFile);
        String outModel = null;
        if (params.getSettings().get("OutputModel") == null || params.getSettings().get("OutputModel").length() == 0) {
            outModel = Files.getNameWithoutExtension(paramFile) + ".bin";
            params.put("OutputModel", outModel);
        } else {
            outModel = Flags.getModel(params);
        }
        DefaultTrainer chunkerTrainer = new DefaultTrainer(params);
        ChunkerModel trainedModel = chunkerTrainer.train(params);
        CmdLineUtil.writeModel("ixa-pipe-chunk", new File(outModel), trainedModel);
    }

    private void loadTrainingParameters() {
        this.trainParser.addArgument("-p", "--params").required(true).help("Load the training parameters file\n");
    }

    public final void eval() throws IOException {
        String testFile = this.parsedArguments.getString("testSet");
        String model = this.parsedArguments.getString("model");
        Evaluate evaluator = new Evaluate(testFile, model);
        if (this.parsedArguments.getString("evalReport") != null) {
            if (this.parsedArguments.getString("evalReport").equalsIgnoreCase("brief")) {
                evaluator.evaluate();
            } else if (this.parsedArguments.getString("evalReport").equalsIgnoreCase("error")) {
                evaluator.evalError();
            } else if (this.parsedArguments.getString("evalReport").equalsIgnoreCase("detailed")) {
                evaluator.detailEvaluate();
            }
        } else {
            evaluator.detailEvaluate();
        }
    }

    public final void loadEvalParameters() {
        this.evalParser.addArgument("-m", "--model").required(true).help("Choose model");
        this.evalParser.addArgument("-t", "--testSet").required(true).help("Input testset for evaluation");
        this.evalParser.addArgument("--evalReport").required(false).choices("brief", "detailed", "error").help("Choose type of evaluation report; defaults to detailed");
    }

    public final void crossValidate() throws IOException {
        String paramFile = this.parsedArguments.getString("params");
        TrainingParameters params = InputOutputUtils.loadTrainingParameters(paramFile);
        CrossValidator crossValidator = new CrossValidator(params);
        crossValidator.crossValidate(params);
    }

    private void loadCrossValidateParameters() {
        this.crossValidateParser.addArgument("-p", "--params").required(true).help("Load the Cross validation parameters file\n");
    }

    private Properties setAnnotateProperties(String model, String language) {
        Properties annotateProperties = new Properties();
        annotateProperties.setProperty("model", model);
        annotateProperties.setProperty("language", language);
        return annotateProperties;
    }
}

