/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.chunk.train;

import eus.ixa.ixa.pipe.chunk.train.Flags;
import eus.ixa.ixa.pipe.chunk.train.InputOutputUtils;
import eus.ixa.ixa.pipe.chunk.train.Trainer;
import java.io.IOException;
import opennlp.tools.chunker.ChunkSample;
import opennlp.tools.chunker.ChunkSampleStream;
import opennlp.tools.chunker.ChunkerEvaluationMonitor;
import opennlp.tools.chunker.ChunkerEvaluator;
import opennlp.tools.chunker.ChunkerFactory;
import opennlp.tools.chunker.ChunkerME;
import opennlp.tools.chunker.ChunkerModel;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.TrainingParameters;

public abstract class AbstractTrainer
implements Trainer {
    private String lang;
    private ObjectStream<ChunkSample> trainSamples;
    private ObjectStream<ChunkSample> testSamples;
    private ChunkerFactory chunkerFactory;

    public AbstractTrainer(TrainingParameters params) throws IOException {
        this.lang = Flags.getLanguage(params);
        String trainData = Flags.getDataSet("TrainSet", params);
        String testData = Flags.getDataSet("TestSet", params);
        ObjectStream<String> trainStream = InputOutputUtils.readFileIntoMarkableStreamFactory(trainData);
        this.trainSamples = new ChunkSampleStream(trainStream);
        ObjectStream<String> testStream = InputOutputUtils.readFileIntoMarkableStreamFactory(testData);
        this.testSamples = new ChunkSampleStream(testStream);
    }

    @Override
    public final ChunkerModel train(TrainingParameters params) {
        if (this.getChunkerFactory() == null) {
            throw new IllegalStateException("Classes derived from AbstractTrainer must  create a ChunkerFactory features!");
        }
        ChunkerModel trainedModel = null;
        ChunkerEvaluator chunkerEvaluator = null;
        try {
            trainedModel = ChunkerME.train(this.lang, this.trainSamples, params, this.getChunkerFactory());
            ChunkerME chunker = new ChunkerME(trainedModel);
            chunkerEvaluator = new ChunkerEvaluator(chunker, new ChunkerEvaluationMonitor[0]);
            chunkerEvaluator.evaluate(this.testSamples);
        }
        catch (IOException e) {
            System.err.println("IO error while loading traing and test sets!");
            e.printStackTrace();
            System.exit(1);
        }
        System.out.println("Final result: " + chunkerEvaluator.getFMeasure());
        return trainedModel;
    }

    protected final ChunkerFactory getChunkerFactory() {
        return this.chunkerFactory;
    }

    protected final void setChunkerFactory(ChunkerFactory aChunkerFactory) {
        this.chunkerFactory = aChunkerFactory;
    }
}

