/*
 * Decompiled with CFR 0.152.
 */
package ixa.kaflib;

import ixa.kaflib.Annotation;
import ixa.kaflib.AnnotationContainer;
import ixa.kaflib.CLink;
import ixa.kaflib.Chunk;
import ixa.kaflib.Comment;
import ixa.kaflib.Coref;
import ixa.kaflib.Dep;
import ixa.kaflib.Entity;
import ixa.kaflib.ExternalRef;
import ixa.kaflib.Factuality;
import ixa.kaflib.Factvalue;
import ixa.kaflib.Feature;
import ixa.kaflib.IdentifiableAnnotation;
import ixa.kaflib.KAFDocument;
import ixa.kaflib.KAFNotValidException;
import ixa.kaflib.LinkedEntity;
import ixa.kaflib.Mark;
import ixa.kaflib.NonTerminal;
import ixa.kaflib.Opinion;
import ixa.kaflib.Predicate;
import ixa.kaflib.PredicateAnchor;
import ixa.kaflib.Relation;
import ixa.kaflib.Relational;
import ixa.kaflib.Span;
import ixa.kaflib.Statement;
import ixa.kaflib.TLink;
import ixa.kaflib.TLinkReferable;
import ixa.kaflib.Term;
import ixa.kaflib.Terminal;
import ixa.kaflib.Timex3;
import ixa.kaflib.Topic;
import ixa.kaflib.Tree;
import ixa.kaflib.TreeNode;
import ixa.kaflib.WF;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;
import org.jdom2.CDATA;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.LineSeparator;
import org.jdom2.output.XMLOutputter;

class ReadWriteManager {
    ReadWriteManager() {
    }

    static KAFDocument load(File file) throws IOException, JDOMException, KAFNotValidException {
        SAXBuilder builder = new SAXBuilder();
        Document document = builder.build(file);
        Element rootElem = document.getRootElement();
        return ReadWriteManager.DOMToKAF(document);
    }

    static KAFDocument load(Reader stream) throws IOException, JDOMException, KAFNotValidException {
        SAXBuilder builder = new SAXBuilder();
        Document document = builder.build(stream);
        Element rootElem = document.getRootElement();
        return ReadWriteManager.DOMToKAF(document);
    }

    static void save(KAFDocument kaf, String filename) {
        try {
            File file = new File(filename);
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF8"));
            out.write(ReadWriteManager.kafToStr(kaf));
            ((Writer)out).flush();
        }
        catch (Exception e) {
            System.out.println("Error writing to file");
        }
    }

    static void print(KAFDocument kaf) {
        try {
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)System.out, "UTF8"));
            out.write(ReadWriteManager.kafToStr(kaf));
            ((Writer)out).flush();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    static String kafToStr(KAFDocument kaf) {
        XMLOutputter out = new XMLOutputter(Format.getPrettyFormat().setLineSeparator(LineSeparator.UNIX).setTextMode(Format.TextMode.TRIM_FULL_WHITE));
        Document jdom = ReadWriteManager.KAFToDOM(kaf);
        return out.outputString(jdom);
    }

    private static KAFDocument DOMToKAF(Document dom) throws KAFNotValidException {
        Span<Term> span;
        Element spanElem;
        List<Element> factualityElems;
        String toId;
        String fromId;
        String targetId;
        Object id;
        Term targetTerm;
        boolean isHead;
        HashMap<String, WF> wfIndex = new HashMap<String, WF>();
        HashMap<String, Term> termIndex = new HashMap<String, Term>();
        HashMap<String, Object> relationalIndex = new HashMap<String, Object>();
        HashMap<String, Predicate> predicateIndex = new HashMap<String, Predicate>();
        HashMap<String, Timex3> timexIndex = new HashMap<String, Timex3>();
        Element rootElem = dom.getRootElement();
        String lang = ReadWriteManager.getAttribute("lang", rootElem, Namespace.XML_NAMESPACE);
        String kafVersion = ReadWriteManager.getAttribute("version", rootElem);
        KAFDocument kaf = new KAFDocument(lang, kafVersion);
        List<Element> rootChildrenElems = rootElem.getChildren();
        Element elem = rootElem.getChild("nafHeader");
        if (elem != null) {
            Element element;
            List<Element> lpsElems = elem.getChildren("linguisticProcessors");
            for (Element element2 : lpsElems) {
                String layer = ReadWriteManager.getAttribute("layer", element2);
                List<Element> lpElems = element2.getChildren();
                for (Element lpElem : lpElems) {
                    String hostname;
                    String version;
                    String string;
                    String string2;
                    String name = ReadWriteManager.getAttribute("name", lpElem);
                    KAFDocument.LinguisticProcessor linguisticProcessor = kaf.addLinguisticProcessor(layer, name);
                    String timestamp = ReadWriteManager.getOptAttribute("timestamp", lpElem);
                    if (timestamp != null) {
                        linguisticProcessor.setTimestamp(timestamp);
                    }
                    if ((string2 = ReadWriteManager.getOptAttribute("beginTimestamp", lpElem)) != null) {
                        linguisticProcessor.beginTimestamp = string2;
                    }
                    if ((string = ReadWriteManager.getOptAttribute("endTimestamp", lpElem)) != null) {
                        linguisticProcessor.setEndTimestamp(string);
                    }
                    if ((version = ReadWriteManager.getOptAttribute("version", lpElem)) != null) {
                        linguisticProcessor.setVersion(version);
                    }
                    if ((hostname = ReadWriteManager.getOptAttribute("hostname", lpElem)) == null) continue;
                    linguisticProcessor.setHostname(hostname);
                }
            }
            Element fileDescElem = elem.getChild("fileDesc");
            if (fileDescElem != null) {
                String creationtime;
                String string;
                String string3;
                String filename;
                String string4;
                String location;
                String section;
                String publisher;
                String title;
                KAFDocument.FileDesc fileDesc = kaf.createFileDesc();
                String author = ReadWriteManager.getOptAttribute("author", fileDescElem);
                if (author != null) {
                    fileDesc.author = author;
                }
                if ((title = ReadWriteManager.getOptAttribute("title", fileDescElem)) != null) {
                    fileDesc.title = title;
                }
                if ((publisher = ReadWriteManager.getOptAttribute("publisher", fileDescElem)) != null) {
                    fileDesc.publisher = publisher;
                }
                if ((section = ReadWriteManager.getOptAttribute("section", fileDescElem)) != null) {
                    fileDesc.section = section;
                }
                if ((location = ReadWriteManager.getOptAttribute("location", fileDescElem)) != null) {
                    fileDesc.location = location;
                }
                if ((string4 = ReadWriteManager.getOptAttribute("magazine", fileDescElem)) != null) {
                    fileDesc.magazine = string4;
                }
                if ((filename = ReadWriteManager.getOptAttribute("filename", fileDescElem)) != null) {
                    fileDesc.filename = filename;
                }
                if ((string3 = ReadWriteManager.getOptAttribute("filetype", fileDescElem)) != null) {
                    fileDesc.filetype = string3;
                }
                if ((string = ReadWriteManager.getOptAttribute("pages", fileDescElem)) != null) {
                    fileDesc.pages = Integer.parseInt(string);
                }
                if ((creationtime = ReadWriteManager.getOptAttribute("creationtime", fileDescElem)) != null) {
                    fileDesc.creationtime = creationtime;
                }
            }
            if ((element = elem.getChild("public")) != null) {
                String uri;
                KAFDocument.Public pub = kaf.createPublic();
                String publicId = ReadWriteManager.getOptAttribute("publicId", element);
                if (publicId != null) {
                    pub.publicId = publicId;
                }
                if ((uri = ReadWriteManager.getOptAttribute("uri", element)) != null) {
                    pub.uri = uri;
                }
            }
            rootChildrenElems.remove(elem);
        }
        if ((elem = rootElem.getChild("raw")) != null) {
            kaf.setRawText(elem.getText());
            rootChildrenElems.remove(elem);
        }
        if ((elem = rootElem.getChild("text")) != null) {
            List<Element> wfElems = elem.getChildren();
            for (Element element : wfElems) {
                String string;
                String string5;
                String wid = ReadWriteManager.getAttribute("id", element);
                String wOffset = ReadWriteManager.getAttribute("offset", element);
                String wLength = ReadWriteManager.getAttribute("length", element);
                String wForm = element.getText();
                String wSent = ReadWriteManager.getAttribute("sent", element);
                WF wF = kaf.newWF(wid, Integer.valueOf(wOffset), Integer.valueOf(wLength), wForm, Integer.valueOf(wSent));
                String wPara = ReadWriteManager.getOptAttribute("para", element);
                if (wPara != null) {
                    wF.setPara(Integer.valueOf(wPara));
                }
                if ((string5 = ReadWriteManager.getOptAttribute("page", element)) != null) {
                    wF.setPage(Integer.valueOf(string5));
                }
                if ((string = ReadWriteManager.getOptAttribute("xpath", element)) != null) {
                    wF.setXpath(string);
                }
                wfIndex.put(wF.getId(), wF);
            }
            rootChildrenElems.remove(elem);
        }
        if ((elem = rootElem.getChild("terms")) != null) {
            List<Element> termElems = elem.getChildren();
            for (Element element : termElems) {
                ReadWriteManager.DOMToTerm(element, kaf, false, wfIndex, termIndex, null);
            }
            rootChildrenElems.remove(elem);
        }
        if ((elem = rootElem.getChild("entities")) != null) {
            List<Element> entityElems = elem.getChildren();
            for (Element element : entityElems) {
                List<Element> list;
                String entSource;
                String entId = ReadWriteManager.getAttribute("id", element);
                List<Element> referencesElem = element.getChildren("references");
                if (referencesElem.size() < 1) {
                    throw new IllegalStateException("Every entity must contain a 'references' element");
                }
                List<Element> spanElems = referencesElem.get(0).getChildren();
                if (spanElems.size() < 1) {
                    throw new IllegalStateException("Every entity must contain a 'span' element inside 'references'");
                }
                ArrayList<Span<Term>> references = new ArrayList<Span<Term>>();
                for (Element element3 : spanElems) {
                    Span<Term> span4 = kaf.newTermSpan();
                    List<Element> list2 = element3.getChildren();
                    if (list2.size() < 1) {
                        throw new IllegalStateException("Every span in an entity must contain at least one target inside");
                    }
                    for (Element targetElem : list2) {
                        String targetTermId = ReadWriteManager.getAttribute("id", targetElem);
                        Term targetTerm2 = termIndex.get(targetTermId);
                        if (targetTerm2 == null) {
                            throw new KAFNotValidException("Term " + targetTermId + " not found when loading entity " + entId);
                        }
                        isHead = ReadWriteManager.isHead(targetElem);
                        span4.addTarget(targetTerm2, isHead);
                    }
                    references.add(span4);
                }
                Entity newEntity = kaf.newEntity(entId, references);
                String string = ReadWriteManager.getOptAttribute("type", element);
                if (string != null) {
                    newEntity.setType(string);
                }
                if ((entSource = ReadWriteManager.getOptAttribute("source", element)) != null) {
                    newEntity.setSource(entSource);
                }
                if ((list = element.getChildren("externalReferences")).size() > 0) {
                    List<ExternalRef> list3 = ReadWriteManager.getExternalReferences(list.get(0), kaf);
                    newEntity.addExternalRefs(list3);
                }
                relationalIndex.put(newEntity.getId(), newEntity);
            }
            rootChildrenElems.remove(elem);
        }
        if ((elem = rootElem.getChild("constituency")) != null) {
            List<Element> treeElems = elem.getChildren("tree");
            for (Element element : treeElems) {
                Iterator<Object> nonTerminalElem2;
                String type = ReadWriteManager.getOptAttribute("type", element);
                HashMap<String, TreeNode> treeNodes = new HashMap<String, TreeNode>();
                HashMap<String, Boolean> rootNodes = new HashMap<String, Boolean>();
                List<Element> terminalElems = element.getChildren("t");
                for (Element element4 : terminalElems) {
                    String id2 = ReadWriteManager.getAttribute("id", element4);
                    Element element5 = element4.getChild("span");
                    if (element5 == null) {
                        throw new KAFNotValidException("Constituent non terminal nodes need a span");
                    }
                    Span<Term> span2 = ReadWriteManager.loadTermSpan(element5, termIndex, id2);
                    treeNodes.put(id2, kaf.newTerminal(id2, span2));
                    rootNodes.put(id2, true);
                }
                List<Element> nonTerminalElems = element.getChildren("nt");
                for (Iterator<Object> nonTerminalElem2 : nonTerminalElems) {
                    String string = ReadWriteManager.getAttribute("id", (Element)((Object)nonTerminalElem2));
                    String string6 = ReadWriteManager.getAttribute("label", nonTerminalElem2);
                    treeNodes.put(string, kaf.newNonTerminal(string, string6));
                    rootNodes.put(string, true);
                }
                List<Element> list = element.getChildren("edge");
                for (Element element6 : list) {
                    String string = ReadWriteManager.getAttribute("from", element6);
                    String toId2 = ReadWriteManager.getAttribute("to", element6);
                    String edgeId = ReadWriteManager.getOptAttribute("id", element6);
                    String head = ReadWriteManager.getOptAttribute("head", element6);
                    isHead = head != null && head.equals("yes");
                    TreeNode parentNode = (TreeNode)treeNodes.get(toId2);
                    TreeNode childNode = (TreeNode)treeNodes.get(string);
                    if (parentNode == null || childNode == null) {
                        throw new KAFNotValidException("There is a problem with the edge(" + string + ", " + toId2 + "). One of its targets doesn't exist.");
                    }
                    try {
                        ((NonTerminal)parentNode).addChild(childNode);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    rootNodes.put(string, false);
                    if (edgeId != null) {
                        childNode.setEdgeId(edgeId);
                    }
                    if (!isHead) continue;
                    ((NonTerminal)childNode).setHead(isHead);
                }
                nonTerminalElem2 = rootNodes.entrySet().iterator();
                while (nonTerminalElem2.hasNext()) {
                    Map.Entry entry = (Map.Entry)nonTerminalElem2.next();
                    if (!((Boolean)entry.getValue()).booleanValue()) continue;
                    TreeNode treeNode = (TreeNode)treeNodes.get(entry.getKey());
                    if (type == null) {
                        kaf.newConstituent(treeNode);
                        continue;
                    }
                    kaf.newConstituent(treeNode, type);
                }
            }
            rootChildrenElems.remove(elem);
        }
        if ((elem = rootElem.getChild("chunks")) != null) {
            List<Element> chunkElems = elem.getChildren();
            for (Element element : chunkElems) {
                String string;
                String chunkId = ReadWriteManager.getAttribute("id", element);
                String headId = ReadWriteManager.getAttribute("head", element);
                Term chunkHead = termIndex.get(headId);
                if (chunkHead == null) {
                    throw new KAFNotValidException("Term " + headId + " not found when loading chunk " + chunkId);
                }
                Element spanElem5 = element.getChild("span");
                if (spanElem5 == null) {
                    throw new IllegalStateException("Every chunk must contain a span element");
                }
                List<Element> chunksTermElems = spanElem5.getChildren("target");
                Span<Term> span3 = kaf.newTermSpan();
                for (Element element7 : chunksTermElems) {
                    String string7 = ReadWriteManager.getAttribute("id", element7);
                    boolean isHead2 = ReadWriteManager.isHead(element7);
                    targetTerm = termIndex.get(string7);
                    if (targetTerm == null) {
                        throw new KAFNotValidException("Term " + string7 + " not found when loading chunk " + chunkId);
                    }
                    span3.addTarget(targetTerm, targetTerm == chunkHead || isHead2);
                }
                if (!span3.hasTarget(chunkHead)) {
                    throw new KAFNotValidException("The head of the chunk is not in it's span.");
                }
                Chunk newChunk = kaf.newChunk(chunkId, span3);
                String string8 = ReadWriteManager.getOptAttribute("phrase", element);
                if (string8 != null) {
                    newChunk.setPhrase(string8);
                }
                if ((string = ReadWriteManager.getOptAttribute("case", element)) == null) continue;
                newChunk.setCase(string);
            }
            rootChildrenElems.remove(elem);
        }
        if ((elem = rootElem.getChild("coreferences")) != null) {
            List<Element> corefElems = elem.getChildren();
            for (Element element : corefElems) {
                List<Element> list;
                String coId = ReadWriteManager.getAttribute("id", element);
                List<Element> spanElems = element.getChildren("span");
                if (spanElems.size() < 1) {
                    throw new IllegalStateException("Every coref must contain a 'span' element inside 'references'");
                }
                ArrayList<Span<Term>> mentions = new ArrayList<Span<Term>>();
                for (Element spanElem6 : spanElems) {
                    Span<Term> span4 = kaf.newTermSpan();
                    List<Element> targetElems2 = spanElem6.getChildren();
                    if (targetElems2.size() < 1) {
                        throw new IllegalStateException("Every span in an entity must contain at least one target inside");
                    }
                    for (Element element8 : targetElems2) {
                        String targetTermId = ReadWriteManager.getAttribute("id", element8);
                        targetTerm = termIndex.get(targetTermId);
                        if (targetTerm == null) {
                            throw new KAFNotValidException("Term " + targetTermId + " not found when loading coref " + coId);
                        }
                        boolean isHead3 = ReadWriteManager.isHead(element8);
                        span4.addTarget(targetTerm, isHead3);
                    }
                    mentions.add(span4);
                }
                Coref newCoref = kaf.newCoref(coId, mentions);
                String corefType = ReadWriteManager.getOptAttribute("type", element);
                if (corefType != null) {
                    newCoref.setType(corefType);
                }
                if ((list = element.getChildren("externalReferences")).size() <= 0) continue;
                List<ExternalRef> externalRefs2 = ReadWriteManager.getExternalReferences(list.get(0), kaf);
                newCoref.addExternalRefs(externalRefs2);
            }
            rootChildrenElems.remove(elem);
        }
        if ((elem = rootElem.getChild("opinions")) != null) {
            List<Element> opinionElems = elem.getChildren("opinion");
            for (Element element : opinionElems) {
                Element spanElem7;
                Element opinionExpressionElem;
                Element opinionTargetElem;
                String refId;
                String opinionId = ReadWriteManager.getAttribute("id", element);
                Opinion opinion = kaf.newOpinion(opinionId);
                Element opinionHolderElem = element.getChild("opinion_holder");
                if (opinionHolderElem != null) {
                    Element spanElem8;
                    Span<Term> span2 = kaf.newTermSpan();
                    Opinion.OpinionHolder opinionHolder = opinion.createOpinionHolder(span2);
                    String string = ReadWriteManager.getOptAttribute("type", opinionHolderElem);
                    if (string != null) {
                        opinionHolder.setType(string);
                    }
                    if ((spanElem8 = opinionHolderElem.getChild("span")) != null) {
                        List<Element> list = spanElem8.getChildren("target");
                        for (Element targetElem : list) {
                            refId = ReadWriteManager.getOptAttribute("id", targetElem);
                            boolean isHead4 = ReadWriteManager.isHead(targetElem);
                            Term targetTerm3 = termIndex.get(refId);
                            if (targetTerm3 == null) {
                                throw new KAFNotValidException("Term " + refId + " not found when loading opinion " + opinionId);
                            }
                            span2.addTarget(targetTerm3, isHead4);
                        }
                    }
                }
                if ((opinionTargetElem = element.getChild("opinion_target")) != null) {
                    Span<Term> span6 = kaf.newTermSpan();
                    Opinion.OpinionTarget opinionTarget = opinion.createOpinionTarget(span6);
                    Element spanElem2 = opinionTargetElem.getChild("span");
                    if (spanElem2 != null) {
                        List<Element> list = spanElem2.getChildren("target");
                        for (Element targetElem : list) {
                            refId = ReadWriteManager.getOptAttribute("id", targetElem);
                            boolean isHead5 = ReadWriteManager.isHead(targetElem);
                            Term targetTerm2 = termIndex.get(refId);
                            if (targetTerm2 == null) {
                                throw new KAFNotValidException("Term " + refId + " not found when loading opinion " + opinionId);
                            }
                            span6.addTarget(targetTerm2, isHead5);
                        }
                    }
                }
                if ((opinionExpressionElem = element.getChild("opinion_expression")) == null) continue;
                Span<Term> span5 = kaf.newTermSpan();
                String polarity = ReadWriteManager.getOptAttribute("polarity", opinionExpressionElem);
                String string = ReadWriteManager.getOptAttribute("strength", opinionExpressionElem);
                String string9 = ReadWriteManager.getOptAttribute("subjectivity", opinionExpressionElem);
                String sentimentSemanticType = ReadWriteManager.getOptAttribute("sentiment_semantic_type", opinionExpressionElem);
                String sentimentProductFeature = ReadWriteManager.getOptAttribute("sentiment_product_feature", opinionExpressionElem);
                Opinion.OpinionExpression opinionExpression = opinion.createOpinionExpression(span5);
                if (polarity != null) {
                    opinionExpression.setPolarity(polarity);
                }
                if (string != null) {
                    opinionExpression.setStrength(string);
                }
                if (string9 != null) {
                    opinionExpression.setSubjectivity(string9);
                }
                if (sentimentSemanticType != null) {
                    opinionExpression.setSentimentSemanticType(sentimentSemanticType);
                }
                if (sentimentProductFeature != null) {
                    opinionExpression.setSentimentProductFeature(sentimentProductFeature);
                }
                if ((spanElem7 = opinionExpressionElem.getChild("span")) == null) continue;
                List<Element> targetElems3 = spanElem7.getChildren("target");
                for (Element targetElem : targetElems3) {
                    String refId2 = ReadWriteManager.getOptAttribute("id", targetElem);
                    boolean isHead6 = ReadWriteManager.isHead(targetElem);
                    Term targetTerm4 = termIndex.get(refId2);
                    if (targetTerm4 == null) {
                        throw new KAFNotValidException("Term " + refId2 + " not found when loading opinion " + opinionId);
                    }
                    span5.addTarget(targetTerm4, isHead6);
                }
            }
            rootChildrenElems.remove(elem);
        }
        if ((elem = rootElem.getChild("deps")) != null) {
            List<Element> depElems = elem.getChildren();
            for (Element element : depElems) {
                String fromId3 = ReadWriteManager.getAttribute("from", element);
                String toId3 = ReadWriteManager.getAttribute("to", element);
                Term from = termIndex.get(fromId3);
                if (from == null) {
                    throw new KAFNotValidException("Term " + fromId3 + " not found when loading Dep (" + fromId3 + ", " + toId3 + ")");
                }
                Term to = termIndex.get(toId3);
                if (to == null) {
                    throw new KAFNotValidException("Term " + toId3 + " not found when loading Dep (" + fromId3 + ", " + toId3 + ")");
                }
                String rfunc = ReadWriteManager.getAttribute("rfunc", element);
                Dep dep = kaf.newDep(from, to, rfunc);
                String depcase = ReadWriteManager.getOptAttribute("case", element);
                if (depcase == null) continue;
                dep.setCase(depcase);
            }
            rootChildrenElems.remove(elem);
        }
        if ((elem = rootElem.getChild("srl")) != null) {
            List<Element> predicateElems = elem.getChildren("predicate");
            for (Element element : predicateElems) {
                String string;
                List<Element> list;
                id = ReadWriteManager.getAttribute("id", element);
                Span<Term> span7 = kaf.newTermSpan();
                Element spanElem2 = element.getChild("span");
                if (spanElem2 != null) {
                    List<Element> targetElems4 = spanElem2.getChildren("target");
                    for (Element element9 : targetElems4) {
                        targetId = ReadWriteManager.getAttribute("id", element9);
                        boolean bl = ReadWriteManager.isHead(element9);
                        Term term = termIndex.get(targetId);
                        if (term == null) {
                            throw new KAFNotValidException("Term object " + targetId + " not found when loading predicate " + (String)id);
                        }
                        span7.addTarget(term, bl);
                    }
                }
                ArrayList<String> predTypes = new ArrayList<String>();
                List<Element> predTypeElems = element.getChildren("predType");
                for (Element predTypeElem : predTypeElems) {
                    String string10 = ReadWriteManager.getAttribute("uri", predTypeElem);
                    predTypes.add(string10);
                }
                Predicate predicate = kaf.newPredicate((String)id, span7);
                String uri = ReadWriteManager.getOptAttribute("uri", element);
                if (uri != null) {
                    predicate.setUri(uri);
                }
                if ((list = element.getChildren("externalReferences")).size() > 0) {
                    List<ExternalRef> list4 = ReadWriteManager.getExternalReferences(list.get(0), kaf);
                    predicate.addExternalRefs(list4);
                }
                if ((string = ReadWriteManager.getOptAttribute("confidence", element)) != null) {
                    predicate.setConfidence(Float.valueOf(string).floatValue());
                }
                List<Element> roleElems = element.getChildren("role");
                for (Element roleElem : roleElems) {
                    String rid = ReadWriteManager.getAttribute("id", roleElem);
                    String semRole = ReadWriteManager.getAttribute("semRole", roleElem);
                    Span<Term> roleSpan = kaf.newTermSpan();
                    Element roleSpanElem = roleElem.getChild("span");
                    if (roleSpanElem != null) {
                        List<Element> targetElems5 = roleSpanElem.getChildren("target");
                        for (Element targetElem3 : targetElems5) {
                            String targetId2 = ReadWriteManager.getAttribute("id", targetElem3);
                            boolean isHead8 = ReadWriteManager.isHead(targetElem3);
                            Term targetTerm6 = termIndex.get(targetId2);
                            if (targetTerm6 == null) {
                                throw new KAFNotValidException("Term object " + targetId2 + " not found when loading role " + rid);
                            }
                            roleSpan.addTarget(targetTerm6, isHead8);
                        }
                    }
                    Predicate.Role newRole = kaf.newRole(rid, predicate, semRole, roleSpan);
                    List<Element> rExternalReferencesElems = roleElem.getChildren("externalReferences");
                    if (rExternalReferencesElems.size() > 0) {
                        List<ExternalRef> externalRefs3 = ReadWriteManager.getExternalReferences(rExternalReferencesElems.get(0), kaf);
                        newRole.addExternalRefs(externalRefs3);
                    }
                    predicate.addRole(newRole);
                }
                predicateIndex.put(predicate.getId(), predicate);
            }
            rootChildrenElems.remove(elem);
        }
        if ((elem = rootElem.getChild("timeExpressions")) != null) {
            List<Element> timex3Elems = elem.getChildren();
            HashMap uncompleteBeginPointRefs = new HashMap();
            HashMap<Timex3, String> hashMap = new HashMap<Timex3, String>();
            for (Element timex3Elem : timex3Elems) {
                Element spanElem9;
                String timex3Comment;
                String timex3AnchorTimeId;
                String timex3Mod;
                String timex3ValueFromFunction;
                String timex3Value;
                String timex3TempFunc;
                String timex3FuncInDoc;
                String string;
                String string11;
                String timex3EndPointId;
                String timex3Id = ReadWriteManager.getAttribute("id", timex3Elem);
                String timex3Type = ReadWriteManager.getAttribute("type", timex3Elem);
                Timex3 timex3 = kaf.newTimex3(timex3Id, timex3Type);
                String string12 = ReadWriteManager.getOptAttribute("beginPoint", timex3Elem);
                if (string12 != null) {
                    Timex3 beginPoint = (Timex3)timexIndex.get(string12);
                    if (beginPoint == null) {
                        uncompleteBeginPointRefs.put(timex3, string12);
                    } else {
                        timex3.setBeginPoint(beginPoint);
                    }
                }
                if ((timex3EndPointId = ReadWriteManager.getOptAttribute("endPoint", timex3Elem)) != null) {
                    Timex3 timex32 = (Timex3)timexIndex.get(timex3EndPointId);
                    if (timex32 == null) {
                        hashMap.put(timex3, timex3EndPointId);
                    } else {
                        timex3.setEndPoint(timex32);
                    }
                }
                if ((string11 = ReadWriteManager.getOptAttribute("quant", timex3Elem)) != null) {
                    timex3.setQuant(string11);
                }
                if ((string = ReadWriteManager.getOptAttribute("freq", timex3Elem)) != null) {
                    timex3.setFreq(string);
                }
                if ((timex3FuncInDoc = ReadWriteManager.getOptAttribute("functionInDocument", timex3Elem)) != null) {
                    timex3.setFunctionInDocument(timex3FuncInDoc);
                }
                if ((timex3TempFunc = ReadWriteManager.getOptAttribute("temporalFunction", timex3Elem)) != null) {
                    Boolean tempFunc = timex3TempFunc.equals("true");
                    timex3.setTemporalFunction(tempFunc);
                }
                if ((timex3Value = ReadWriteManager.getOptAttribute("value", timex3Elem)) != null) {
                    timex3.setValue(timex3Value);
                }
                if ((timex3ValueFromFunction = ReadWriteManager.getOptAttribute("valueFromFunction", timex3Elem)) != null) {
                    timex3.setValueFromFunction(timex3ValueFromFunction);
                }
                if ((timex3Mod = ReadWriteManager.getOptAttribute("mod", timex3Elem)) != null) {
                    timex3.setMod(timex3Mod);
                }
                if ((timex3AnchorTimeId = ReadWriteManager.getOptAttribute("anchorTimeId", timex3Elem)) != null) {
                    timex3.setAnchorTimeId(timex3AnchorTimeId);
                }
                if ((timex3Comment = ReadWriteManager.getOptAttribute("comment", timex3Elem)) != null) {
                    timex3.setComment(timex3Comment);
                }
                if ((spanElem9 = timex3Elem.getChild("span")) != null) {
                    Span<WF> timex3Span = kaf.newWFSpan();
                    for (Element targetElem : spanElem9.getChildren("target")) {
                        String targetId3 = ReadWriteManager.getAttribute("id", targetElem);
                        WF wf = wfIndex.get(targetId3);
                        if (wf == null) {
                            throw new KAFNotValidException("Word form " + targetId3 + " not found when loading timex3 " + timex3Id);
                        }
                        boolean isHead9 = ReadWriteManager.isHead(targetElem);
                        timex3Span.addTarget(wf, isHead9);
                    }
                    timex3.setSpan(timex3Span);
                }
                timexIndex.put(timex3.getId(), timex3);
            }
            for (Timex3 timex3 : uncompleteBeginPointRefs.keySet()) {
                timex3.setBeginPoint((Timex3)timexIndex.get(uncompleteBeginPointRefs.get(timex3)));
            }
            for (Timex3 timex3 : hashMap.keySet()) {
                timex3.setEndPoint((Timex3)timexIndex.get(hashMap.get(timex3)));
            }
            rootChildrenElems.remove(elem);
        }
        if ((elem = rootElem.getChild("temporalRelations")) != null) {
            List<Element> tLinkElems = elem.getChildren("tlink");
            for (Element element : tLinkElems) {
                String tlid = ReadWriteManager.getAttribute("id", element);
                fromId = ReadWriteManager.getAttribute("from", element);
                toId = ReadWriteManager.getAttribute("to", element);
                String fromType = ReadWriteManager.getAttribute("fromType", element);
                String toType = ReadWriteManager.getAttribute("toType", element);
                String string = ReadWriteManager.getAttribute("relType", element);
                TLinkReferable from = (TLinkReferable)((Object)(fromType.equals("event") ? (IdentifiableAnnotation)predicateIndex.get(fromId) : (IdentifiableAnnotation)timexIndex.get(fromId)));
                TLinkReferable tLinkReferable = (TLinkReferable)((Object)(toType.equals("event") ? (IdentifiableAnnotation)predicateIndex.get(toId) : (IdentifiableAnnotation)timexIndex.get(toId)));
                TLink tLink = kaf.newTLink(tlid, from, tLinkReferable, string);
            }
            Iterator<Element> predAnchorElems = elem.getChildren("predicateAnchor");
            Iterator iterator = predAnchorElems.iterator();
            while (iterator.hasNext()) {
                String string;
                String beginPointId;
                Element predAnchorElem = (Element)iterator.next();
                String id4 = ReadWriteManager.getAttribute("id", predAnchorElem);
                Element spanElem3 = predAnchorElem.getChild("span");
                Span<Predicate> predAnchorSpan = KAFDocument.newSpan();
                if (spanElem3 != null) {
                    for (Element element : spanElem3.getChildren("target")) {
                        targetId = ReadWriteManager.getAttribute("id", element);
                        Predicate predicate = (Predicate)predicateIndex.get(targetId);
                        if (predicate == null) {
                            throw new KAFNotValidException("Predicate " + targetId + " not found when loading PredicateAnchor " + id4);
                        }
                        boolean bl = ReadWriteManager.isHead(element);
                        predAnchorSpan.addTarget(predicate, bl);
                    }
                }
                PredicateAnchor newPa = kaf.newPredicateAnchor(id4, predAnchorSpan);
                String string13 = ReadWriteManager.getOptAttribute("anchorTime", predAnchorElem);
                if (string13 != null) {
                    Timex3 anchorTime = (Timex3)timexIndex.get(string13);
                    if (anchorTime == null) {
                        throw new IllegalStateException("Invalid timex ID (" + string13 + ") in predicateAnchor " + id4);
                    }
                    newPa.setAnchorTime(anchorTime);
                }
                if ((beginPointId = ReadWriteManager.getOptAttribute("beginPoint", predAnchorElem)) != null) {
                    Timex3 timex3 = (Timex3)timexIndex.get(beginPointId);
                    if (timex3 == null) {
                        throw new IllegalStateException("Invalid timex ID (" + beginPointId + ") in predicateAnchor " + id4);
                    }
                    newPa.setBeginPoint(timex3);
                }
                if ((string = ReadWriteManager.getOptAttribute("endPoint", predAnchorElem)) == null) continue;
                Timex3 timex3 = (Timex3)timexIndex.get(string);
                if (timex3 == null) {
                    throw new IllegalStateException("Invalid timex ID (" + string + ") in predicateAnchor " + id4);
                }
                newPa.setEndPoint(timex3);
            }
            rootChildrenElems.remove(elem);
        }
        if ((elem = rootElem.getChild("causalRelations")) != null) {
            List<Element> clinkElems = elem.getChildren("clink");
            for (Element element : clinkElems) {
                String clid = ReadWriteManager.getAttribute("id", element);
                fromId = ReadWriteManager.getAttribute("from", element);
                toId = ReadWriteManager.getAttribute("to", element);
                String relType = ReadWriteManager.getOptAttribute("relType", element);
                Predicate from = (Predicate)predicateIndex.get(fromId);
                Predicate predicate = (Predicate)predicateIndex.get(toId);
                CLink clink = kaf.newCLink(clid, from, predicate);
                if (relType == null) continue;
                clink.setRelType(relType);
            }
            rootChildrenElems.remove(elem);
        }
        if ((elem = rootElem.getChild("factualities")) != null) {
            factualityElems = elem.getChildren("factuality");
            for (Element element : factualityElems) {
                id = ReadWriteManager.getAttribute("id", element);
                spanElem = element.getChild("span");
                if (spanElem == null) {
                    throw new IllegalStateException("Every factuality must contain a 'span' element");
                }
                span = ReadWriteManager.loadTermSpan(spanElem, termIndex, (String)id);
                Factuality newFactuality = kaf.newFactuality((String)id, span);
                List<Element> factValElems = element.getChildren("factVal");
                for (Element factValElem : factValElems) {
                    newFactuality.addFactVal(ReadWriteManager.DOMToFactVal(factValElem, kaf));
                }
            }
            rootChildrenElems.remove(elem);
        }
        if ((elem = rootElem.getChild("factualityLayer")) != null) {
            factualityElems = elem.getChildren("factvalue");
            for (Element element : factualityElems) {
                id = ReadWriteManager.getAttribute("id", element);
                String prediction = ReadWriteManager.getAttribute("prediction", element);
                String confidenceStr = ReadWriteManager.getAttribute("confidence", element);
                Double confidence = null;
                if (confidenceStr != null) {
                    confidence = Double.parseDouble(confidenceStr);
                }
                Factvalue factuality = kaf.newFactvalue(wfIndex.get(id), prediction);
                if (confidence == null) continue;
                factuality.setConfidence(confidence);
            }
            rootChildrenElems.remove(elem);
        }
        if ((elem = rootElem.getChild("features")) != null) {
            String targetTermId;
            ArrayList<Span<Term>> references;
            Element referencesElem;
            String lemma;
            Element propertiesElem = elem.getChild("properties");
            Iterator<Element> categoriesElem = elem.getChild("categories");
            if (propertiesElem != null) {
                List<Element> list = propertiesElem.getChildren("property");
                for (Element propertyElem : list) {
                    String pid = ReadWriteManager.getAttribute("id", propertyElem);
                    lemma = ReadWriteManager.getAttribute("lemma", propertyElem);
                    referencesElem = propertyElem.getChild("references");
                    if (referencesElem == null) {
                        throw new IllegalStateException("Every property must contain a 'references' element");
                    }
                    List<Element> list5 = referencesElem.getChildren("span");
                    if (list5.size() < 1) {
                        throw new IllegalStateException("Every property must contain a 'span' element inside 'references'");
                    }
                    references = new ArrayList<Span<Term>>();
                    for (Element element : list5) {
                        Span<Term> span8 = kaf.newTermSpan();
                        List<Element> targetElems6 = element.getChildren();
                        if (targetElems6.size() < 1) {
                            throw new IllegalStateException("Every span in a property must contain at least one target inside");
                        }
                        for (Element targetElem : targetElems6) {
                            targetTermId = ReadWriteManager.getAttribute("id", targetElem);
                            Term targetTerm7 = termIndex.get(targetTermId);
                            if (targetTerm7 == null) {
                                throw new KAFNotValidException("Term " + targetTermId + " not found when loading property " + pid);
                            }
                            boolean isHead11 = ReadWriteManager.isHead(targetElem);
                            span8.addTarget(targetTerm7, isHead11);
                        }
                        references.add(span8);
                    }
                    Feature feature = kaf.newProperty(pid, lemma, references);
                    List<Element> list6 = propertyElem.getChildren("externalReferences");
                    if (list6.size() > 0) {
                        List<ExternalRef> externalRefs4 = ReadWriteManager.getExternalReferences(list6.get(0), kaf);
                        feature.addExternalRefs(externalRefs4);
                    }
                    relationalIndex.put(feature.getId(), feature);
                }
            }
            if (categoriesElem != null) {
                List<Element> list = ((Element)((Object)categoriesElem)).getChildren("category");
                for (Element categoryElem : list) {
                    String cid = ReadWriteManager.getAttribute("id", categoryElem);
                    lemma = ReadWriteManager.getAttribute("lemma", categoryElem);
                    referencesElem = categoryElem.getChild("references");
                    if (referencesElem == null) {
                        throw new IllegalStateException("Every category must contain a 'references' element");
                    }
                    List<Element> list7 = referencesElem.getChildren("span");
                    if (list7.size() < 1) {
                        throw new IllegalStateException("Every category must contain a 'span' element inside 'references'");
                    }
                    references = new ArrayList();
                    for (Element element : list7) {
                        Span<Term> span9 = kaf.newTermSpan();
                        List<Element> targetElems = element.getChildren();
                        if (targetElems.size() < 1) {
                            throw new IllegalStateException("Every span in a property must contain at least one target inside");
                        }
                        for (Element targetElem : targetElems) {
                            targetTermId = ReadWriteManager.getAttribute("id", targetElem);
                            Term targetTerm3 = termIndex.get(targetTermId);
                            if (targetTerm3 == null) {
                                throw new KAFNotValidException("Term " + targetTermId + " not found when loading category " + cid);
                            }
                            boolean isHead12 = ReadWriteManager.isHead(targetElem);
                            span9.addTarget(targetTerm3, isHead12);
                        }
                        references.add(span9);
                    }
                    Feature feature = kaf.newCategory(cid, lemma, references);
                    List<Element> list8 = categoryElem.getChildren("externalReferences");
                    if (list8.size() > 0) {
                        List<ExternalRef> externalRefs5 = ReadWriteManager.getExternalReferences(list8.get(0), kaf);
                        feature.addExternalRefs(externalRefs5);
                    }
                    relationalIndex.put(feature.getId(), feature);
                }
            }
            rootChildrenElems.remove(elem);
        }
        if ((elem = rootElem.getChild("relations")) != null) {
            List<Element> relationElems = elem.getChildren("relation");
            for (Element element : relationElems) {
                Relational relational;
                id = ReadWriteManager.getAttribute("id", element);
                fromId = ReadWriteManager.getAttribute("from", element);
                toId = ReadWriteManager.getAttribute("to", element);
                String confidenceStr = ReadWriteManager.getOptAttribute("confidence", element);
                float confidence = -1.0f;
                if (confidenceStr != null) {
                    confidence = Float.parseFloat(confidenceStr);
                }
                if ((relational = (Relational)relationalIndex.get(fromId)) == null) {
                    throw new KAFNotValidException("Entity/feature object " + fromId + " not found when loading relation " + (String)id);
                }
                Relational to = (Relational)relationalIndex.get(toId);
                if (to == null) {
                    throw new KAFNotValidException("Entity/feature object " + toId + " not found when loading relation " + (String)id);
                }
                Relation relation = kaf.newRelation((String)id, relational, to);
                if (!(confidence >= 0.0f)) continue;
                relation.setConfidence(confidence);
            }
            rootChildrenElems.remove(elem);
        }
        if ((elem = rootElem.getChild("topics")) != null) {
            List<Element> topicElems = elem.getChildren("topic");
            for (Element element : topicElems) {
                String URI2;
                String method;
                String value = element.getText();
                Topic topic = kaf.newTopic(value);
                String source = ReadWriteManager.getOptAttribute("source", element);
                if (source != null) {
                    topic.setSource(source);
                }
                if ((method = ReadWriteManager.getOptAttribute("method", element)) != null) {
                    topic.setMethod(method);
                }
                String confidenceStr = ReadWriteManager.getOptAttribute("confidence", element);
                float f = -1.0f;
                if (confidenceStr != null) {
                    f = Float.parseFloat(confidenceStr);
                    topic.setConfidence(Float.valueOf(f));
                }
                if ((URI2 = ReadWriteManager.getOptAttribute("uri", element)) == null) continue;
                topic.setURI(URI2);
            }
            rootChildrenElems.remove(elem);
        }
        if ((elem = rootElem.getChild("markables")) != null) {
            List<Element> markElems = elem.getChildren();
            for (Element element : markElems) {
                List<Element> externalReferencesElems5;
                String markcase;
                String tMorphofeat;
                String pos;
                String string;
                String string14;
                String sid = ReadWriteManager.getAttribute("id", element);
                spanElem = element.getChild("span");
                if (spanElem == null) {
                    throw new IllegalStateException("Every mark must contain a span element");
                }
                List<Element> marksWfElems = spanElem.getChildren("target");
                Span<WF> span6 = kaf.newWFSpan();
                for (Element element10 : marksWfElems) {
                    String wfId = ReadWriteManager.getAttribute("id", element10);
                    boolean bl = ReadWriteManager.isHead(element10);
                    WF wF = wfIndex.get(wfId);
                    if (wF == null) {
                        throw new KAFNotValidException("WF " + wfId + " not found when loading mark " + sid);
                    }
                    span6.addTarget(wF, bl);
                }
                String source = ReadWriteManager.getOptAttribute("source", element);
                Mark mark = source == null ? kaf.newMark(sid, span6) : kaf.newMark(sid, source, span6);
                Element sentimentElem = element.getChild("sentiment");
                if (sentimentElem != null) {
                    mark.setSentiment(ReadWriteManager.DOMToSentiment(sentimentElem, kaf));
                }
                if ((string14 = ReadWriteManager.getOptAttribute("type", element)) != null) {
                    mark.setType(string14);
                }
                if ((string = ReadWriteManager.getOptAttribute("lemma", element)) != null) {
                    mark.setLemma(string);
                }
                if ((pos = ReadWriteManager.getOptAttribute("pos", element)) != null) {
                    mark.setPos(pos);
                }
                if ((tMorphofeat = ReadWriteManager.getOptAttribute("morphofeat", element)) != null) {
                    mark.setMorphofeat(tMorphofeat);
                }
                if ((markcase = ReadWriteManager.getOptAttribute("case", element)) != null) {
                    mark.setCase(markcase);
                }
                if ((externalReferencesElems5 = element.getChildren("externalReferences")).size() <= 0) continue;
                List<ExternalRef> externalRefs6 = ReadWriteManager.getExternalReferences(externalReferencesElems5.get(0), kaf);
                mark.addExternalRefs(externalRefs6);
            }
            rootChildrenElems.remove(elem);
        }
        if ((elem = rootElem.getChild("attribution")) != null) {
            List<Element> statementElems = elem.getChildren("statement");
            for (Element element : statementElems) {
                Element element11;
                String statementId = ReadWriteManager.getAttribute("id", element);
                Element stTargetElem = element.getChild("statement_target");
                if (stTargetElem == null) {
                    throw new KAFNotValidException("Statement " + statementId + " does not contain the compulsory StatementTarget element.");
                }
                span = kaf.newTermSpan();
                Statement.StatementTarget target = kaf.newStatementTarget(span);
                Element spanElem12 = stTargetElem.getChild("span");
                if (spanElem12 != null) {
                    List<Element> list = spanElem12.getChildren("target");
                    for (Element element12 : list) {
                        String string = ReadWriteManager.getOptAttribute("id", element12);
                        boolean isHead14 = ReadWriteManager.isHead(element12);
                        targetTerm = termIndex.get(string);
                        if (targetTerm == null) {
                            throw new KAFNotValidException("Term " + string + " not found when loading statement " + statementId);
                        }
                        span.addTarget(targetTerm, isHead14);
                    }
                }
                Statement statement = kaf.newStatement(statementId, target);
                Element stSourceElem = element.getChild("statement_source");
                if (stSourceElem != null) {
                    Element element13 = stSourceElem.getChild("span");
                    if (element13 == null) {
                        throw new KAFNotValidException("StatementSource elements need to contain the span element");
                    }
                    Span<Term> span7 = ReadWriteManager.loadTermSpan(element13, termIndex, statementId);
                    statement.setSource(kaf.newStatementSource(span7));
                }
                if ((element11 = element.getChild("statement_cue")) == null) continue;
                Element element14 = element11.getChild("span");
                if (element14 == null) {
                    throw new KAFNotValidException("StatementCue elements need to contain the span element");
                }
                Span<Term> cueSpan = ReadWriteManager.loadTermSpan(element14, termIndex, statementId);
                statement.setCue(kaf.newStatementCue(cueSpan));
            }
            rootChildrenElems.remove(elem);
        }
        for (Element unknownLayerElem : rootChildrenElems) {
            kaf.addUnknownLayer(unknownLayerElem);
        }
        return kaf;
    }

    private static void DOMToTerm(Element termElem, KAFDocument kaf, boolean isComponent, Map<String, WF> wfIndex, Map<String, Term> termIndex, Term parentTerm) throws KAFNotValidException {
        List<Element> sentimentElems;
        String tMorphofeat;
        String pos;
        String lemma;
        String tid = ReadWriteManager.getAttribute("id", termElem);
        Element spanElem = termElem.getChild("span");
        List<Object> termsWfElems = new ArrayList();
        if (!isComponent) {
            if (spanElem == null) {
                throw new IllegalStateException("Every term must contain a span element");
            }
            termsWfElems = spanElem.getChildren("target");
        }
        Span<WF> span = kaf.newWFSpan();
        for (Element termsWfElem : termsWfElems) {
            String wfId = ReadWriteManager.getAttribute("id", termsWfElem);
            boolean isHead = ReadWriteManager.isHead(termsWfElem);
            WF wf = wfIndex.get(wfId);
            if (wf == null) {
                throw new KAFNotValidException("Wf " + wfId + " not found when loading term " + tid);
            }
            span.addTarget(wf, isHead);
        }
        Term newTerm = kaf.newTerm(tid, span, isComponent);
        String type = ReadWriteManager.getOptAttribute("type", termElem);
        if (type != null) {
            newTerm.setType(type);
        }
        if ((lemma = ReadWriteManager.getOptAttribute("lemma", termElem)) != null) {
            newTerm.setLemma(lemma);
        }
        if ((pos = ReadWriteManager.getOptAttribute("pos", termElem)) != null) {
            newTerm.setPos(pos);
        }
        if ((tMorphofeat = ReadWriteManager.getOptAttribute("morphofeat", termElem)) != null) {
            newTerm.setMorphofeat(tMorphofeat);
        }
        String tHead = ReadWriteManager.getOptAttribute("head", termElem);
        String termcase = ReadWriteManager.getOptAttribute("case", termElem);
        if (termcase != null) {
            newTerm.setCase(termcase);
        }
        if ((sentimentElems = termElem.getChildren("sentiment")).size() > 0) {
            Term.Sentiment sentiment = ReadWriteManager.DOMToSentiment(sentimentElems.get(0), kaf);
            newTerm.setSentiment(sentiment);
        }
        if (!isComponent) {
            List<Element> termsComponentElems = termElem.getChildren("component");
            for (Element termsComponentElem : termsComponentElems) {
                ReadWriteManager.DOMToTerm(termsComponentElem, kaf, true, wfIndex, termIndex, newTerm);
            }
        } else {
            parentTerm.addComponent(newTerm);
        }
        List<Element> externalReferencesElems = termElem.getChildren("externalReferences");
        if (externalReferencesElems.size() > 0) {
            List<ExternalRef> externalRefs = ReadWriteManager.getExternalReferences(externalReferencesElems.get(0), kaf);
            newTerm.addExternalRefs(externalRefs);
        }
        termIndex.put(newTerm.getId(), newTerm);
    }

    private static Term.Sentiment DOMToSentiment(Element sentimentElem, KAFDocument kaf) {
        String sentSentimentProductFeature;
        String sentSentimentMarker;
        String sentSentimentModifier;
        String sentSentimentSemanticType;
        String sentSubjectivity;
        String sentStrength;
        String sentPolarity;
        Term.Sentiment newSentiment = kaf.newSentiment();
        String sentResource = ReadWriteManager.getOptAttribute("resource", sentimentElem);
        if (sentResource != null) {
            newSentiment.setResource(sentResource);
        }
        if ((sentPolarity = ReadWriteManager.getOptAttribute("polarity", sentimentElem)) != null) {
            newSentiment.setPolarity(sentPolarity);
        }
        if ((sentStrength = ReadWriteManager.getOptAttribute("strength", sentimentElem)) != null) {
            newSentiment.setStrength(sentStrength);
        }
        if ((sentSubjectivity = ReadWriteManager.getOptAttribute("subjectivity", sentimentElem)) != null) {
            newSentiment.setSubjectivity(sentSubjectivity);
        }
        if ((sentSentimentSemanticType = ReadWriteManager.getOptAttribute("sentiment_semantic_type", sentimentElem)) != null) {
            newSentiment.setSentimentSemanticType(sentSentimentSemanticType);
        }
        if ((sentSentimentModifier = ReadWriteManager.getOptAttribute("sentiment_modifier", sentimentElem)) != null) {
            newSentiment.setSentimentModifier(sentSentimentModifier);
        }
        if ((sentSentimentMarker = ReadWriteManager.getOptAttribute("sentiment_marker", sentimentElem)) != null) {
            newSentiment.setSentimentMarker(sentSentimentMarker);
        }
        if ((sentSentimentProductFeature = ReadWriteManager.getOptAttribute("sentiment_product_feature", sentimentElem)) != null) {
            newSentiment.setSentimentProductFeature(sentSentimentProductFeature);
        }
        return newSentiment;
    }

    private static Factuality.FactVal DOMToFactVal(Element factValElem, KAFDocument kaf) {
        String confidence;
        String value = ReadWriteManager.getAttribute("value", factValElem);
        String resource = ReadWriteManager.getAttribute("resource", factValElem);
        Factuality.FactVal newFactVal = kaf.newFactVal(value, resource);
        String source = ReadWriteManager.getOptAttribute("source", factValElem);
        if (source != null) {
            newFactVal.setSource(source);
        }
        if ((confidence = ReadWriteManager.getOptAttribute("confidence", factValElem)) != null) {
            newFactVal.setConfidence(Float.valueOf(confidence));
        }
        return newFactVal;
    }

    private static Span<Term> loadTermSpan(Element spanElem, HashMap<String, Term> terms, String objId) throws KAFNotValidException {
        List<Element> targetElems = spanElem.getChildren("target");
        if (targetElems.size() < 1) {
            throw new KAFNotValidException("A span element can not be empty");
        }
        Span<Term> span = KAFDocument.newTermSpan();
        for (Element targetElem : targetElems) {
            String targetId = ReadWriteManager.getAttribute("id", targetElem);
            boolean isHead = ReadWriteManager.isHead(targetElem);
            Term targetTerm = terms.get(targetId);
            if (targetTerm == null) {
                throw new KAFNotValidException("Term object " + targetId + " not found when loading object " + objId);
            }
            span.addTarget(targetTerm, isHead);
        }
        return span;
    }

    private static Element createTermSpanElem(Span<Term> span) {
        Element spanElem = new Element("span");
        for (Term term : span.getTargets()) {
            Element targetElem = new Element("target");
            String targetId = term.getId();
            targetElem.setAttribute("id", targetId);
            if (span.isHead(term)) {
                targetElem.setAttribute("head", "yes");
            }
            spanElem.addContent(targetElem);
        }
        return spanElem;
    }

    private static List<ExternalRef> getExternalReferences(Element externalReferencesElem, KAFDocument kaf) {
        ArrayList<ExternalRef> externalRefs = new ArrayList<ExternalRef>();
        List<Element> externalRefElems = externalReferencesElem.getChildren();
        for (Element externalRefElem : externalRefElems) {
            ExternalRef externalRef = ReadWriteManager.getExternalRef(externalRefElem, kaf);
            externalRefs.add(externalRef);
        }
        return externalRefs;
    }

    private static ExternalRef getExternalRef(Element externalRefElem, KAFDocument kaf) {
        List<Element> sentimentElems;
        String source;
        String status;
        String reftype;
        String confidence;
        String resource = ReadWriteManager.getAttribute("resource", externalRefElem);
        ExternalRef newExternalRef = kaf.newExternalRef(resource);
        String references = ReadWriteManager.getOptAttribute("reference", externalRefElem);
        if (references != null) {
            newExternalRef.setReference(references);
        }
        if ((confidence = ReadWriteManager.getOptAttribute("confidence", externalRefElem)) != null) {
            newExternalRef.setConfidence(Float.valueOf(confidence));
        }
        if ((reftype = ReadWriteManager.getOptAttribute("reftype", externalRefElem)) != null) {
            newExternalRef.setReftype(reftype);
        }
        if ((status = ReadWriteManager.getOptAttribute("status", externalRefElem)) != null) {
            newExternalRef.setStatus(status);
        }
        if ((source = ReadWriteManager.getOptAttribute("source", externalRefElem)) != null) {
            newExternalRef.setSource(source);
        }
        if ((sentimentElems = externalRefElem.getChildren("sentiment")).size() > 0) {
            Term.Sentiment sentiment = ReadWriteManager.DOMToSentiment(sentimentElems.get(0), kaf);
            newExternalRef.setSentiment(sentiment);
        }
        List<Element> subRefElems = externalRefElem.getChildren("externalRef");
        for (Element subRefElem : subRefElems) {
            ExternalRef subRef = ReadWriteManager.getExternalRef(subRefElem, kaf);
            newExternalRef.addExternalRef(subRef);
        }
        return newExternalRef;
    }

    private static String getAttribute(String attName, Element elem) {
        String value = elem.getAttributeValue(attName);
        if (value == null) {
            throw new IllegalStateException(attName + " attribute must be defined for element " + elem.getName());
        }
        return value;
    }

    private static String getAttribute(String attName, Element elem, Namespace nmspace) {
        String value = elem.getAttributeValue(attName, nmspace);
        if (value == null) {
            throw new IllegalStateException(attName + " attribute must be defined for element " + elem.getName());
        }
        return value;
    }

    private static String getOptAttribute(String attName, Element elem) {
        String value = elem.getAttributeValue(attName);
        if (value == null) {
            return null;
        }
        return value;
    }

    private static boolean isHead(Element elem) {
        String value = elem.getAttributeValue("head");
        if (value == null) {
            return false;
        }
        return value.equals("yes");
    }

    /*
     * WARNING - void declaration
     */
    private static Document KAFToDOM(KAFDocument kaf) {
        List<Annotation> list;
        List<Annotation> list2;
        List<Annotation> list3;
        List<Annotation> list4;
        List<String> list5;
        List<Annotation> list6;
        List<Annotation> list7;
        Object span;
        Element targetElem;
        List<Annotation> opinions;
        List<Annotation> list8;
        List<Annotation> list9;
        List<Annotation> list10;
        List<Annotation> list11;
        List<Annotation> list12;
        List<Annotation> list13;
        Element spanElem;
        List<Annotation> list14;
        List<Annotation> list15;
        List<Annotation> list16;
        List<Annotation> marks;
        List<Annotation> terms;
        List<Annotation> text;
        KAFDocument.Public pub;
        AnnotationContainer annotationContainer = kaf.getAnnotationContainer();
        Element root = new Element("NAF");
        root.setAttribute("lang", kaf.getLang(), Namespace.XML_NAMESPACE);
        root.setAttribute("version", kaf.getVersion());
        Document doc = new Document(root);
        Element kafHeaderElem = new Element("nafHeader");
        root.addContent(kafHeaderElem);
        KAFDocument.FileDesc fd = kaf.getFileDesc();
        if (fd != null) {
            Element fdElem = new Element("fileDesc");
            if (fd.author != null) {
                fdElem.setAttribute("author", fd.author);
            }
            if (fd.creationtime != null) {
                fdElem.setAttribute("creationtime", fd.creationtime);
            }
            if (fd.title != null) {
                fdElem.setAttribute("title", fd.title);
            }
            if (fd.publisher != null) {
                fdElem.setAttribute("publisher", fd.publisher);
            }
            if (fd.section != null) {
                fdElem.setAttribute("section", fd.section);
            }
            if (fd.location != null) {
                fdElem.setAttribute("location", fd.location);
            }
            if (fd.magazine != null) {
                fdElem.setAttribute("magazine", fd.magazine);
            }
            if (fd.filename != null) {
                fdElem.setAttribute("filename", fd.filename);
            }
            if (fd.filetype != null) {
                fdElem.setAttribute("filetype", fd.filetype);
            }
            if (fd.pages != null) {
                fdElem.setAttribute("pages", Integer.toString(fd.pages));
            }
            kafHeaderElem.addContent(fdElem);
        }
        if ((pub = kaf.getPublic()) != null) {
            Element pubElem = new Element("public");
            if (pub.publicId != null) {
                pubElem.setAttribute("publicId", pub.publicId);
            }
            if (pub.uri != null) {
                pubElem.setAttribute("uri", pub.uri);
            }
            kafHeaderElem.addContent(pubElem);
        }
        Map<String, List<KAFDocument.LinguisticProcessor>> lps = kaf.getLinguisticProcessors();
        for (Map.Entry<String, List<KAFDocument.LinguisticProcessor>> entry : lps.entrySet()) {
            Element lpsElem = new Element("linguisticProcessors");
            lpsElem.setAttribute("layer", entry.getKey());
            for (KAFDocument.LinguisticProcessor linguisticProcessor : entry.getValue()) {
                Element element = new Element("lp");
                element.setAttribute("name", linguisticProcessor.name);
                if (linguisticProcessor.hasTimestamp()) {
                    element.setAttribute("timestamp", linguisticProcessor.timestamp);
                }
                if (linguisticProcessor.hasBeginTimestamp()) {
                    element.setAttribute("beginTimestamp", linguisticProcessor.beginTimestamp);
                }
                if (linguisticProcessor.hasEndTimestamp()) {
                    element.setAttribute("endTimestamp", linguisticProcessor.endTimestamp);
                }
                if (linguisticProcessor.hasVersion()) {
                    element.setAttribute("version", linguisticProcessor.version);
                }
                if (linguisticProcessor.hasHostname().booleanValue()) {
                    element.setAttribute("hostname", linguisticProcessor.hostname);
                }
                lpsElem.addContent(element);
            }
            kafHeaderElem.addContent(lpsElem);
        }
        String rawText = annotationContainer.getRawText();
        if (rawText.length() > 0) {
            Element rawElem = new Element("raw");
            CDATA cdataElem = new CDATA(rawText);
            rawElem.addContent(cdataElem);
            root.addContent(rawElem);
        }
        if ((text = annotationContainer.getLayer(KAFDocument.Layer.TEXT)).size() > 0) {
            Element textElem = new Element("text");
            for (WF wF : text) {
                Element element = new Element("wf");
                element.setAttribute("id", wF.getId());
                element.setAttribute("offset", Integer.toString(wF.getOffset()));
                element.setAttribute("length", Integer.toString(wF.getLength()));
                element.setAttribute("sent", Integer.toString(wF.getSent()));
                if (wF.hasPara()) {
                    element.setAttribute("para", Integer.toString(wF.getPara()));
                }
                if (wF.hasPage()) {
                    element.setAttribute("page", Integer.toString(wF.getPage()));
                }
                if (wF.hasXpath()) {
                    element.setAttribute("xpath", wF.getXpath());
                }
                element.setText(wF.getForm());
                textElem.addContent(element);
            }
            root.addContent(textElem);
        }
        if ((terms = annotationContainer.getLayer(KAFDocument.Layer.TERMS)).size() > 0) {
            Element termsElem = new Element("terms");
            for (Term term : terms) {
                ReadWriteManager.termToDOM(term, false, termsElem);
            }
            root.addContent(termsElem);
        }
        if ((marks = annotationContainer.getLayer(KAFDocument.Layer.MARKABLES)).size() > 0) {
            Element element = new Element("markables");
            for (Mark mark : marks) {
                Comment comment = new Comment(StringEscapeUtils.escapeXml11(mark.getStr()));
                element.addContent(comment);
                Element element2 = new Element("mark");
                element2.setAttribute("id", mark.getId());
                if (mark.hasSource()) {
                    element2.setAttribute("source", mark.getSource());
                }
                if (mark.hasType()) {
                    element2.setAttribute("type", mark.getType());
                }
                if (mark.hasLemma()) {
                    element2.setAttribute("lemma", mark.getLemma());
                }
                if (mark.hasPos()) {
                    element2.setAttribute("pos", mark.getPos());
                }
                if (mark.hasMorphofeat()) {
                    element2.setAttribute("morphofeat", mark.getMorphofeat());
                }
                if (mark.hasCase()) {
                    element2.setAttribute("case", mark.getCase());
                }
                if (mark.hasSentiment()) {
                    element2.addContent(ReadWriteManager.sentimentToDOM(mark.getSentiment()));
                }
                Element element3 = new Element("span");
                Span<WF> span2 = mark.getSpan();
                for (WF wF : span2.getTargets()) {
                    Element element4 = new Element("target");
                    element4.setAttribute("id", wF.getId());
                    if (wF == span2.getHead()) {
                        element4.setAttribute("head", "yes");
                    }
                    element3.addContent(element4);
                }
                element2.addContent(element3);
                List<ExternalRef> list17 = mark.getExternalRefs();
                if (list17.size() > 0) {
                    Element element5 = ReadWriteManager.externalReferencesToDOM(list17);
                    element2.addContent(element5);
                }
                element.addContent(element2);
            }
            root.addContent(element);
        }
        if ((list16 = annotationContainer.getLayer(KAFDocument.Layer.DEPS)).size() > 0) {
            Element element = new Element("deps");
            for (Dep dep : list16) {
                Comment comment = new Comment(StringEscapeUtils.escapeXml11(dep.getStr()));
                element.addContent(comment);
                Element element6 = new Element("dep");
                element6.setAttribute("from", dep.getFrom().getId());
                element6.setAttribute("to", dep.getTo().getId());
                element6.setAttribute("rfunc", dep.getRfunc());
                if (dep.hasCase()) {
                    element6.setAttribute("case", dep.getCase());
                }
                element.addContent(element6);
            }
            root.addContent(element);
        }
        if ((list15 = annotationContainer.getLayer(KAFDocument.Layer.CHUNKS)).size() > 0) {
            Element element = new Element("chunks");
            for (Chunk chunk : list15) {
                Comment comment = new Comment(StringEscapeUtils.escapeXml11(chunk.getStr()));
                element.addContent(comment);
                Element element7 = new Element("chunk");
                element7.setAttribute("id", chunk.getId());
                element7.setAttribute("head", chunk.getHead().getId());
                if (chunk.hasPhrase()) {
                    element7.setAttribute("phrase", chunk.getPhrase());
                }
                if (chunk.hasCase()) {
                    element7.setAttribute("case", chunk.getCase());
                }
                Element element8 = new Element("span");
                for (Term term : chunk.getTerms()) {
                    Element element9 = new Element("target");
                    element9.setAttribute("id", term.getId());
                    element8.addContent(element9);
                }
                element7.addContent(element8);
                element.addContent(element7);
            }
            root.addContent(element);
        }
        if ((list14 = annotationContainer.getLayer(KAFDocument.Layer.ENTITIES)).size() > 0) {
            Element element = new Element("entities");
            for (Entity entity : list14) {
                Element element10 = new Element("entity");
                element10.setAttribute("id", entity.getId());
                if (entity.hasType()) {
                    element10.setAttribute("type", entity.getType());
                }
                if (entity.hasSource()) {
                    element10.setAttribute("source", entity.getSource());
                }
                Element element11 = new Element("references");
                for (Span<Term> span3 : entity.getSpans()) {
                    Comment comment = new Comment(StringEscapeUtils.escapeXml11(entity.getSpanStr(span3)));
                    element11.addContent(comment);
                    spanElem = new Element("span");
                    for (Term term : span3.getTargets()) {
                        Element element12 = new Element("target");
                        element12.setAttribute("id", term.getId());
                        if (term == span3.getHead()) {
                            element12.setAttribute("head", "yes");
                        }
                        spanElem.addContent(element12);
                    }
                    element11.addContent(spanElem);
                }
                element10.addContent(element11);
                List<ExternalRef> list18 = entity.getExternalRefs();
                if (list18.size() > 0) {
                    Element element13 = ReadWriteManager.externalReferencesToDOM(list18);
                    element10.addContent(element13);
                }
                element.addContent(element10);
            }
            root.addContent(element);
        }
        if ((list13 = annotationContainer.getLayer(KAFDocument.Layer.COREFERENCES)).size() > 0) {
            Element element = new Element("coreferences");
            for (Coref coref : list13) {
                Element element14 = new Element("coref");
                element14.setAttribute("id", coref.getId());
                if (coref.hasType()) {
                    element14.setAttribute("type", coref.getType());
                }
                for (Span<Term> span4 : coref.getSpans()) {
                    Comment comment = new Comment(StringEscapeUtils.escapeXml11(coref.getSpanStr(span4)));
                    element14.addContent(comment);
                    Element spanElem2 = new Element("span");
                    for (Term term : span4.getTargets()) {
                        Element element15 = new Element("target");
                        element15.setAttribute("id", term.getId());
                        if (term == span4.getHead()) {
                            element15.setAttribute("head", "yes");
                        }
                        spanElem2.addContent(element15);
                    }
                    element14.addContent(spanElem2);
                }
                List<ExternalRef> list19 = coref.getExternalRefs();
                if (list19.size() > 0) {
                    Element element16 = ReadWriteManager.externalReferencesToDOM(list19);
                    element14.addContent(element16);
                }
                element.addContent(element14);
            }
            root.addContent(element);
        }
        if ((list12 = annotationContainer.getLayer(KAFDocument.Layer.TIME_EXPRESSIONS)).size() > 0) {
            Element element = new Element("timeExpressions");
            for (Timex3 timex3 : list12) {
                Element element17 = new Element("timex3");
                element17.setAttribute("id", timex3.getId());
                element17.setAttribute("type", timex3.getType());
                if (timex3.hasBeginPoint()) {
                    element17.setAttribute("beginPoint", timex3.getBeginPoint().getId());
                }
                if (timex3.hasEndPoint()) {
                    element17.setAttribute("endPoint", timex3.getEndPoint().getId());
                }
                if (timex3.hasQuant()) {
                    element17.setAttribute("quant", timex3.getQuant());
                }
                if (timex3.hasFreq()) {
                    element17.setAttribute("freq", timex3.getFreq());
                }
                if (timex3.hasFunctionInDocument()) {
                    element17.setAttribute("functionInDocument", timex3.getFunctionInDocument());
                }
                if (timex3.hasTemporalFunction()) {
                    String string = timex3.getTemporalFunction() != false ? "true" : "false";
                    element17.setAttribute("temporalFunction", string);
                }
                if (timex3.hasValue()) {
                    element17.setAttribute("value", timex3.getValue());
                }
                if (timex3.hasValueFromFunction()) {
                    element17.setAttribute("valueFromFunction", timex3.getValueFromFunction());
                }
                if (timex3.hasMod()) {
                    element17.setAttribute("mod", timex3.getMod());
                }
                if (timex3.hasAnchorTimeId()) {
                    element17.setAttribute("anchorTimeId", timex3.getAnchorTimeId());
                }
                if (timex3.hasComment()) {
                    element17.setAttribute("comment", timex3.getComment());
                }
                if (timex3.hasSpan()) {
                    Span<WF> span5 = timex3.getSpan();
                    Comment comment = new Comment(StringEscapeUtils.escapeXml11(timex3.getSpanStr(span5)));
                    element17.addContent(comment);
                    spanElem = new Element("span");
                    for (WF wF : span5.getTargets()) {
                        Element element18 = new Element("target");
                        element18.setAttribute("id", wF.getId());
                        if (wF == span5.getHead()) {
                            element18.setAttribute("head", "yes");
                        }
                        spanElem.addContent(element18);
                    }
                    element17.addContent(spanElem);
                }
                element.addContent(element17);
            }
            root.addContent(element);
        }
        if ((list11 = annotationContainer.getLayer(KAFDocument.Layer.FACTUALITIES)).size() > 0) {
            Element element = new Element("factualities");
            for (Factuality factuality : list11) {
                Element element19 = new Element("factuality");
                element19.setAttribute("id", factuality.getId());
                Span<Term> span6 = factuality.getSpan();
                Comment spanComment2 = new Comment(StringEscapeUtils.escapeXml11(factuality.getSpanStr(span6)));
                element19.addContent(spanComment2);
                Element element20 = new Element("span");
                for (Term term : span6.getTargets()) {
                    Element element21 = new Element("target");
                    element21.setAttribute("id", term.getId());
                    if (term == span6.getHead()) {
                        element21.setAttribute("head", "yes");
                    }
                    element20.addContent(element21);
                }
                element19.addContent(element20);
                for (Factuality.FactVal factVal : factuality.getFactVals()) {
                    element19.addContent(ReadWriteManager.factValToDOM(factVal));
                }
                element.addContent(element19);
            }
            root.addContent(element);
        }
        if ((list10 = annotationContainer.getLayer(KAFDocument.Layer.FACTUALITY_LAYER)).size() > 0) {
            Element element = new Element("factualitylayer");
            for (Factvalue factvalue : list10) {
                Element element22 = new Element("factvalue");
                element22.setAttribute("id", factvalue.getId());
                element22.setAttribute("prediction", factvalue.getPrediction());
                element22.setAttribute("confidence", Double.toString(factvalue.getConfidence()));
                element.addContent(element22);
            }
            root.addContent(element);
        }
        if ((list9 = annotationContainer.getLayer(KAFDocument.Layer.LINKED_ENTITIES)).size() > 0) {
            Element element = new Element("linkedEntities");
            for (LinkedEntity linkedEntity : list9) {
                Element lEnt = new Element("linkedEntity");
                lEnt.setAttribute("id", linkedEntity.getId());
                lEnt.setAttribute("resource", linkedEntity.getResource());
                lEnt.setAttribute("reference", linkedEntity.getReference());
                lEnt.setAttribute("confidence", Double.toString(linkedEntity.getConfidence()));
                Comment comment = new Comment(StringEscapeUtils.escapeXml11(linkedEntity.getSpanStr()));
                lEnt.addContent(comment);
                Element element23 = new Element("span");
                for (WF wF : linkedEntity.getWFs().getTargets()) {
                    Element element24 = new Element("target");
                    element24.setAttribute("id", wF.getId());
                    element23.addContent(element24);
                }
                lEnt.addContent(element23);
                element.addContent(lEnt);
            }
            root.addContent(element);
        }
        Element element = new Element("features");
        List<Annotation> list20 = annotationContainer.getLayer(KAFDocument.Layer.PROPERTIES);
        if (list20.size() > 0) {
            Element element25 = new Element("properties");
            for (Feature feature : list20) {
                Element element26 = new Element("property");
                element26.setAttribute("id", feature.getId());
                element26.setAttribute("lemma", feature.getLemma());
                List<Span<Term>> list21 = feature.getSpans();
                Element element27 = new Element("references");
                for (Span<Term> span7 : list21) {
                    Comment comment = new Comment(StringEscapeUtils.escapeXml11(feature.getSpanStr(span7)));
                    element27.addContent(comment);
                    Element element28 = new Element("span");
                    for (Term term : span7.getTargets()) {
                        Element targetElem8 = new Element("target");
                        targetElem8.setAttribute("id", term.getId());
                        if (term == span7.getHead()) {
                            targetElem8.setAttribute("head", "yes");
                        }
                        element28.addContent(targetElem8);
                    }
                    element27.addContent(element28);
                }
                element26.addContent(element27);
                element25.addContent(element26);
            }
            element.addContent(element25);
        }
        if ((list8 = annotationContainer.getLayer(KAFDocument.Layer.CATEGORIES)).size() > 0) {
            Element categoriesElem = new Element("categories");
            for (Feature feature : list8) {
                Element element29 = new Element("category");
                element29.setAttribute("id", feature.getId());
                element29.setAttribute("lemma", feature.getLemma());
                List<Span<Term>> list22 = feature.getSpans();
                Element element30 = new Element("references");
                for (Span<Term> span8 : list22) {
                    Comment comment = new Comment(StringEscapeUtils.escapeXml11(feature.getSpanStr(span8)));
                    element30.addContent(comment);
                    Element element31 = new Element("span");
                    for (Object term : span8.getTargets()) {
                        Element element32 = new Element("target");
                        element32.setAttribute("id", ((IdentifiableAnnotation)term).getId());
                        if (term == span8.getHead()) {
                            element32.setAttribute("head", "yes");
                        }
                        element31.addContent(element32);
                    }
                    element30.addContent(element31);
                }
                element29.addContent(element30);
                categoriesElem.addContent(element29);
            }
            element.addContent(categoriesElem);
        }
        if (element.getChildren().size() > 0) {
            root.addContent(element);
        }
        if ((opinions = annotationContainer.getLayer(KAFDocument.Layer.OPINIONS)).size() > 0) {
            Element element33 = new Element("opinions");
            for (Opinion opinion : opinions) {
                Opinion.OpinionExpression opinionExpression;
                Opinion.OpinionTarget opinionTarget;
                Element element34 = new Element("opinion");
                element34.setAttribute("id", opinion.getId());
                Opinion.OpinionHolder opinionHolder = opinion.getOpinionHolder();
                if (opinionHolder != null) {
                    Element element35 = new Element("opinion_holder");
                    if (opinionHolder.hasType()) {
                        element35.setAttribute("type", opinionHolder.getType());
                    }
                    Comment comment = new Comment(StringEscapeUtils.escapeXml11(opinion.getSpanStr(opinion.getOpinionHolder().getSpan())));
                    element35.addContent(comment);
                    List<Term> list23 = opinionHolder.getTerms();
                    Span<Term> span9 = opinionHolder.getSpan();
                    if (list23.size() > 0) {
                        Element element36 = new Element("span");
                        element35.addContent(element36);
                        for (Term term : list23) {
                            Element element37 = new Element("target");
                            element37.setAttribute("id", term.getId());
                            if (term == span9.getHead()) {
                                element37.setAttribute("head", "yes");
                            }
                            element36.addContent(element37);
                        }
                    }
                    element34.addContent(element35);
                }
                if ((opinionTarget = opinion.getOpinionTarget()) != null) {
                    Element element38 = new Element("opinion_target");
                    Comment comment = new Comment(StringEscapeUtils.escapeXml11(opinion.getSpanStr(opinion.getOpinionTarget().getSpan())));
                    element38.addContent(comment);
                    List<Term> list24 = opinionTarget.getTerms();
                    Span<Term> span10 = opinionTarget.getSpan();
                    if (list24.size() > 0) {
                        Element spanElem9 = new Element("span");
                        element38.addContent(spanElem9);
                        for (Term term : list24) {
                            targetElem = new Element("target");
                            targetElem.setAttribute("id", term.getId());
                            if (term == span10.getHead()) {
                                targetElem.setAttribute("head", "yes");
                            }
                            spanElem9.addContent(targetElem);
                        }
                    }
                    element34.addContent(element38);
                }
                if ((opinionExpression = opinion.getOpinionExpression()) != null) {
                    Element element39 = new Element("opinion_expression");
                    Comment comment = new Comment(StringEscapeUtils.escapeXml11(opinion.getSpanStr(opinion.getOpinionExpression().getSpan())));
                    element39.addContent(comment);
                    if (opinionExpression.hasPolarity()) {
                        element39.setAttribute("polarity", opinionExpression.getPolarity());
                    }
                    if (opinionExpression.hasStrength()) {
                        element39.setAttribute("strength", opinionExpression.getStrength());
                    }
                    if (opinionExpression.hasSubjectivity()) {
                        element39.setAttribute("subjectivity", opinionExpression.getSubjectivity());
                    }
                    if (opinionExpression.hasSentimentSemanticType()) {
                        element39.setAttribute("sentiment_semantic_type", opinionExpression.getSentimentSemanticType());
                    }
                    if (opinionExpression.hasSentimentProductFeature()) {
                        element39.setAttribute("sentiment_product_feature", opinionExpression.getSentimentProductFeature());
                    }
                    List<Term> list25 = opinionExpression.getTerms();
                    span = opinionExpression.getSpan();
                    if (list25.size() > 0) {
                        Element element40 = new Element("span");
                        element39.addContent(element40);
                        for (Term target : list25) {
                            Element targetElem10 = new Element("target");
                            targetElem10.setAttribute("id", target.getId());
                            if (target == ((Span)span).getHead()) {
                                targetElem10.setAttribute("head", "yes");
                            }
                            element40.addContent(targetElem10);
                        }
                    }
                    element34.addContent(element39);
                }
                element33.addContent(element34);
            }
            root.addContent(element33);
        }
        if ((list7 = annotationContainer.getLayer(KAFDocument.Layer.RELATIONS)).size() > 0) {
            Element element41 = new Element("relations");
            for (Relation relation : list7) {
                Comment comment = new Comment(StringEscapeUtils.escapeXml11(relation.getStr()));
                element41.addContent(comment);
                Element element42 = new Element("relation");
                element42.setAttribute("id", relation.getId());
                element42.setAttribute("from", relation.getFrom().getId());
                element42.setAttribute("to", relation.getTo().getId());
                if (relation.hasConfidence()) {
                    element42.setAttribute("confidence", String.valueOf(relation.getConfidence()));
                }
                element41.addContent(element42);
            }
            root.addContent(element41);
        }
        if ((list6 = annotationContainer.getLayer(KAFDocument.Layer.SRL)).size() > 0) {
            Element element43 = new Element("srl");
            for (Predicate predicate : list6) {
                List<ExternalRef> list26;
                Span<Term> span11;
                Comment comment = new Comment(StringEscapeUtils.escapeXml11(predicate.getStr()));
                element43.addContent(comment);
                Element element44 = new Element("predicate");
                element44.setAttribute("id", predicate.getId());
                if (predicate.hasUri()) {
                    element44.setAttribute("uri", predicate.getUri());
                }
                if (predicate.hasConfidence()) {
                    element44.setAttribute("confidence", Float.toString(predicate.getConfidence()));
                }
                if ((span11 = predicate.getSpan()).getTargets().size() > 0) {
                    Comment comment2 = new Comment(StringEscapeUtils.escapeXml11(predicate.getSpanStr()));
                    Element element45 = new Element("span");
                    element44.addContent(comment2);
                    element44.addContent(element45);
                    for (Term term : span11.getTargets()) {
                        Element element46 = new Element("target");
                        element46.setAttribute("id", term.getId());
                        if (term == span11.getHead()) {
                            element46.setAttribute("head", "yes");
                        }
                        element45.addContent(element46);
                    }
                }
                if ((list26 = predicate.getExternalRefs()).size() > 0) {
                    Element element47 = ReadWriteManager.externalReferencesToDOM(list26);
                    element44.addContent(element47);
                }
                for (Predicate.Role role : predicate.getRoles()) {
                    List<ExternalRef> rExternalReferences;
                    Element element48 = new Element("role");
                    element48.setAttribute("id", role.getId());
                    element48.setAttribute("semRole", role.getSemRole());
                    Span<Term> span12 = role.getSpan();
                    if (span12.getTargets().size() > 0) {
                        Comment spanComment7 = new Comment(StringEscapeUtils.escapeXml11(role.getStr()));
                        Element spanElem11 = new Element("span");
                        element48.addContent(spanComment7);
                        element48.addContent(spanElem11);
                        for (Term term : span12.getTargets()) {
                            Element targetElem11 = new Element("target");
                            targetElem11.setAttribute("id", term.getId());
                            if (term == span12.getHead()) {
                                targetElem11.setAttribute("head", "yes");
                            }
                            spanElem11.addContent(targetElem11);
                        }
                    }
                    if ((rExternalReferences = role.getExternalRefs()).size() > 0) {
                        Element externalReferencesElem4 = ReadWriteManager.externalReferencesToDOM(rExternalReferences);
                        element48.addContent(externalReferencesElem4);
                    }
                    element44.addContent(element48);
                }
                element43.addContent(element44);
            }
            root.addContent(element43);
        }
        if ((list5 = annotationContainer.getGroupIDs(KAFDocument.AnnotationType.TREE)).size() > 0) {
            Element element49 = new Element("constituency");
            for (String string : list5) {
                List<Annotation> list27 = annotationContainer.getLayer(KAFDocument.Layer.CONSTITUENCY, string);
                for (Tree tree : list27) {
                    Element element50 = new Element("tree");
                    if (!tree.getType().equals("kaflib_default_group")) {
                        element50.setAttribute("type", tree.getType());
                    }
                    element49.addContent(element50);
                    LinkedList<NonTerminal> nonTerminals = new LinkedList<NonTerminal>();
                    LinkedList<Terminal> linkedList = new LinkedList<Terminal>();
                    ArrayList<Edge> arrayList = new ArrayList<Edge>();
                    TreeNode rootNode = tree.getRoot();
                    ReadWriteManager.extractTreeNodes(rootNode, nonTerminals, linkedList, arrayList);
                    Collections.sort(nonTerminals, new Comparator<NonTerminal>(){

                        @Override
                        public int compare(NonTerminal nt1, NonTerminal nt2) {
                            if (ReadWriteManager.cmpId(nt1.getId(), nt2.getId()) < 0) {
                                return -1;
                            }
                            if (nt1.getId().equals(nt2.getId())) {
                                return 0;
                            }
                            return 1;
                        }
                    });
                    Collections.sort(linkedList, new Comparator<Terminal>(){

                        @Override
                        public int compare(Terminal t1, Terminal t2) {
                            if (ReadWriteManager.cmpId(t1.getId(), t2.getId()) < 0) {
                                return -1;
                            }
                            if (t1.getId().equals(t2.getId())) {
                                return 0;
                            }
                            return 1;
                        }
                    });
                    Comment ntCom = new Comment("Non-terminals");
                    element50.addContent(ntCom);
                    for (NonTerminal nonTerminal : nonTerminals) {
                        Element nodeElem = new Element("nt");
                        nodeElem.setAttribute("id", nonTerminal.getId());
                        nodeElem.setAttribute("label", nonTerminal.getLabel());
                        element50.addContent(nodeElem);
                    }
                    Comment tCom = new Comment("Terminals");
                    element50.addContent(tCom);
                    for (Terminal node3 : linkedList) {
                        Element nodeElem = new Element("t");
                        nodeElem.setAttribute("id", node3.getId());
                        nodeElem.addContent(ReadWriteManager.createTermSpanElem(node3.getSpan()));
                        Comment tStrCom = new Comment(StringEscapeUtils.escapeXml11(node3.getStr()));
                        element50.addContent(tStrCom);
                        element50.addContent(nodeElem);
                    }
                    Comment comment = new Comment("Tree edges");
                    element50.addContent(comment);
                    for (Edge edge : arrayList) {
                        Element edgeElem = new Element("edge");
                        if (edge.id != null) {
                            edgeElem.setAttribute("id", edge.id);
                        }
                        edgeElem.setAttribute("from", edge.from);
                        edgeElem.setAttribute("to", edge.to);
                        if (edge.head) {
                            edgeElem.setAttribute("head", "yes");
                        }
                        element50.addContent(edgeElem);
                    }
                }
            }
            root.addContent(element49);
        }
        if ((list4 = annotationContainer.getLayer(KAFDocument.Layer.TEMPORAL_RELATIONS)).size() > 0) {
            Element element51 = new Element("temporalRelations");
            for (Annotation annotation : list4) {
                if (annotation instanceof TLink) {
                    TLink tLink = (TLink)annotation;
                    Comment comment = new Comment(StringEscapeUtils.escapeXml11(tLink.getRelType() + "(" + tLink.getFrom().getId() + ", " + tLink.getTo().getId() + ")"));
                    element51.addContent(comment);
                    Element element52 = new Element("tlink");
                    element52.setAttribute("id", tLink.getId());
                    element52.setAttribute("from", tLink.getFrom().getId());
                    element52.setAttribute("to", tLink.getTo().getId());
                    element52.setAttribute("fromType", tLink.getFromType());
                    element52.setAttribute("toType", tLink.getToType());
                    element52.setAttribute("relType", tLink.getRelType());
                    element51.addContent(element52);
                    continue;
                }
                if (!(annotation instanceof PredicateAnchor)) continue;
                PredicateAnchor predicateAnchor = (PredicateAnchor)annotation;
                Element element53 = new Element("predicateAnchor");
                element53.setAttribute("id", predicateAnchor.getId());
                if (predicateAnchor.hasAnchorTime()) {
                    element53.setAttribute("anchorTime", predicateAnchor.getAnchorTime().getId());
                }
                if (predicateAnchor.hasBeginPoint()) {
                    element53.setAttribute("beginPoint", predicateAnchor.getBeginPoint().getId());
                }
                if (predicateAnchor.hasEndPoint()) {
                    element53.setAttribute("endPoint", predicateAnchor.getEndPoint().getId());
                }
                Element element54 = new Element("span");
                span = predicateAnchor.getSpan();
                for (Predicate predicate : ((Span)span).getTargets()) {
                    targetElem = new Element("target");
                    targetElem.setAttribute("id", predicate.getId());
                    if (predicate == ((Span)span).getHead()) {
                        targetElem.setAttribute("head", "yes");
                    }
                    element54.addContent(targetElem);
                }
                element53.addContent(element54);
                element51.addContent(element53);
            }
            root.addContent(element51);
        }
        if ((list3 = annotationContainer.getLayer(KAFDocument.Layer.CAUSAL_RELATIONS)).size() > 0) {
            Element element55 = new Element("causalRelations");
            for (CLink cLink : list3) {
                void var32_315;
                String string = "";
                if (cLink.hasRelType()) {
                    String string2 = string + cLink.getRelType();
                }
                String string3 = (String)var32_315 + "(" + cLink.getFrom().getId() + ", " + cLink.getTo().getId() + ")";
                Comment comment = new Comment(StringEscapeUtils.escapeXml11(string3));
                element55.addContent(comment);
                Element cLinkElem = new Element("clink");
                cLinkElem.setAttribute("id", cLink.getId());
                cLinkElem.setAttribute("from", cLink.getFrom().getId());
                cLinkElem.setAttribute("to", cLink.getTo().getId());
                if (cLink.hasRelType()) {
                    cLinkElem.setAttribute("relType", cLink.getRelType());
                }
                element55.addContent(cLinkElem);
            }
            root.addContent(element55);
        }
        if ((list2 = annotationContainer.getLayer(KAFDocument.Layer.TOPICS)).size() > 0) {
            Element element56 = new Element("topics");
            for (Topic topic : list2) {
                Element element57 = new Element("topic");
                element57.setText(topic.getTopicValue());
                if (topic.hasSource()) {
                    element57.setAttribute("source", topic.getSource());
                }
                if (topic.hasMethod()) {
                    element57.setAttribute("method", topic.getMethod());
                }
                if (topic.hasURI()) {
                    element57.setAttribute("uri", topic.getURI());
                }
                if (topic.hasConfidence()) {
                    element57.setAttribute("confidence", Double.toString(topic.getConfidence().floatValue()));
                }
                element56.addContent(element57);
            }
            root.addContent(element56);
        }
        if ((list = annotationContainer.getLayer(KAFDocument.Layer.ATTRIBUTION)).size() > 0) {
            Element element58 = new Element("attribution");
            for (Statement statement : list) {
                Element statementElem = new Element("statement");
                statementElem.setAttribute("id", statement.getId());
                Statement.StatementTarget statementTarget = statement.getTarget();
                Element element59 = new Element("statement_target");
                statementElem.addContent(element59);
                element59.addContent(ReadWriteManager.spanToDOM(statementTarget.getSpan()));
                if (statement.hasSource().booleanValue()) {
                    Statement.StatementSource stSource = statement.getSource();
                    Element stSourceElem = new Element("statement_source");
                    statementElem.addContent(stSourceElem);
                    stSourceElem.addContent(ReadWriteManager.spanToDOM(stSource.getSpan()));
                }
                if (statement.hasCue().booleanValue()) {
                    Statement.StatementCue stCue = statement.getCue();
                    Element stCueElem = new Element("statement_cue");
                    statementElem.addContent(stCueElem);
                    stCueElem.addContent(ReadWriteManager.spanToDOM(stCue.getSpan()));
                }
                element58.addContent(statementElem);
            }
            root.addContent(element58);
        }
        Set<Element> set = annotationContainer.getUnknownLayers();
        for (Element element60 : set) {
            element60.detach();
            root.addContent(element60);
        }
        return doc;
    }

    private static <T extends IdentifiableAnnotation> Element spanToDOM(Span<T> span) {
        Element spanElem = new Element("span");
        for (IdentifiableAnnotation target : span.getTargets()) {
            Element targetElem = new Element("target");
            targetElem.setAttribute("id", target.getId());
            if (target == span.getHead()) {
                targetElem.setAttribute("head", "yes");
            }
            spanElem.addContent(targetElem);
        }
        return spanElem;
    }

    private static void termToDOM(Term term, boolean isComponent, Element termsElem) {
        List<ExternalRef> externalReferences;
        if (!isComponent) {
            Comment termComment = new Comment(StringEscapeUtils.escapeXml11(term.getStr()));
            termsElem.addContent(termComment);
        }
        String tag = isComponent ? "component" : "term";
        Element termElem = new Element(tag);
        termElem.setAttribute("id", term.getId());
        if (term.hasType()) {
            termElem.setAttribute("type", term.getType());
        }
        if (term.hasLemma()) {
            termElem.setAttribute("lemma", StringEscapeUtils.escapeXml11(term.getLemma()));
        }
        if (term.hasPos()) {
            termElem.setAttribute("pos", term.getPos());
        }
        if (term.hasMorphofeat()) {
            termElem.setAttribute("morphofeat", term.getMorphofeat());
        }
        if (term.hasHead()) {
            termElem.setAttribute("head", term.getHead().getId());
        }
        if (term.hasCase()) {
            termElem.setAttribute("case", term.getCase());
        }
        if (term.hasSentiment()) {
            Term.Sentiment sentiment = term.getSentiment();
            Element sentimentElem = ReadWriteManager.sentimentToDOM(sentiment);
            termElem.addContent(sentimentElem);
        }
        if (!isComponent) {
            Element spanElem = new Element("span");
            Span<WF> span = term.getSpan();
            for (WF target : term.getWFs()) {
                Element targetElem = new Element("target");
                targetElem.setAttribute("id", target.getId());
                if (target == span.getHead()) {
                    targetElem.setAttribute("head", "yes");
                }
                spanElem.addContent(targetElem);
            }
            termElem.addContent(spanElem);
            List<Term> components = term.getComponents();
            if (components.size() > 0) {
                for (Term component : components) {
                    ReadWriteManager.termToDOM(component, true, termElem);
                }
            }
        }
        if ((externalReferences = term.getExternalRefs()).size() > 0) {
            Element externalReferencesElem = ReadWriteManager.externalReferencesToDOM(externalReferences);
            termElem.addContent(externalReferencesElem);
        }
        termsElem.addContent(termElem);
    }

    private static void extractTreeNodes(TreeNode node, List<NonTerminal> nonTerminals, List<Terminal> terminals, List<Edge> edges) {
        if (node instanceof NonTerminal) {
            nonTerminals.add((NonTerminal)node);
            List<TreeNode> treeNodes = ((NonTerminal)node).getChildren();
            for (TreeNode child : treeNodes) {
                edges.add(new Edge(child, node));
                ReadWriteManager.extractTreeNodes(child, nonTerminals, terminals, edges);
            }
        } else {
            terminals.add((Terminal)node);
        }
    }

    private static Element externalReferencesToDOM(List<ExternalRef> externalRefs) {
        Element externalReferencesElem = new Element("externalReferences");
        for (ExternalRef externalRef : externalRefs) {
            Element externalRefElem = ReadWriteManager.externalRefToDOM(externalRef);
            externalReferencesElem.addContent(externalRefElem);
        }
        return externalReferencesElem;
    }

    private static Element externalRefToDOM(ExternalRef externalRef) {
        Element externalRefElem = new Element("externalRef");
        externalRefElem.setAttribute("resource", externalRef.getResource());
        if (externalRef.hasReference()) {
            externalRefElem.setAttribute("reference", externalRef.getReference());
        }
        if (externalRef.hasConfidence()) {
            externalRefElem.setAttribute("confidence", Float.toString(externalRef.getConfidence().floatValue()));
        }
        if (externalRef.hasReftype()) {
            externalRefElem.setAttribute("reftype", externalRef.getReftype());
        }
        if (externalRef.hasStatus()) {
            externalRefElem.setAttribute("status", externalRef.getStatus());
        }
        if (externalRef.hasSource()) {
            externalRefElem.setAttribute("source", externalRef.getSource());
        }
        if (externalRef.hasSentiment()) {
            Element sentimentElem = ReadWriteManager.sentimentToDOM(externalRef.getSentiment());
            externalRefElem.addContent(sentimentElem);
        }
        for (ExternalRef subExternalRef : externalRef.getExternalRefs()) {
            Element subExternalRefElem = ReadWriteManager.externalRefToDOM(subExternalRef);
            externalRefElem.addContent(subExternalRefElem);
        }
        return externalRefElem;
    }

    private static Element sentimentToDOM(Term.Sentiment sentiment) {
        Element sentimentElem = new Element("sentiment");
        if (sentiment.hasResource()) {
            sentimentElem.setAttribute("resource", sentiment.getResource());
        }
        if (sentiment.hasPolarity()) {
            sentimentElem.setAttribute("polarity", sentiment.getPolarity());
        }
        if (sentiment.hasStrength()) {
            sentimentElem.setAttribute("strength", sentiment.getStrength());
        }
        if (sentiment.hasSubjectivity()) {
            sentimentElem.setAttribute("subjectivity", sentiment.getSubjectivity());
        }
        if (sentiment.hasSentimentSemanticType()) {
            sentimentElem.setAttribute("sentiment_semantic_type", sentiment.getSentimentSemanticType());
        }
        if (sentiment.hasSentimentModifier()) {
            sentimentElem.setAttribute("sentiment_modifier", sentiment.getSentimentModifier());
        }
        if (sentiment.hasSentimentMarker()) {
            sentimentElem.setAttribute("sentiment_marker", sentiment.getSentimentMarker());
        }
        if (sentiment.hasSentimentProductFeature()) {
            sentimentElem.setAttribute("sentiment_product_feature", sentiment.getSentimentProductFeature());
        }
        return sentimentElem;
    }

    private static Element factValToDOM(Factuality.FactVal factVal) {
        Element factValElem = new Element("factVal");
        factValElem.setAttribute("value", factVal.getValue());
        factValElem.setAttribute("resource", factVal.getResource());
        if (factVal.hasSource()) {
            factValElem.setAttribute("source", factVal.getSource());
        }
        if (factVal.hasConfidence()) {
            factValElem.setAttribute("confidence", factVal.getConfidence().toString());
        }
        return factValElem;
    }

    private static int cmpId(String id1, String id2) {
        int nbr2;
        int nbr1 = ReadWriteManager.extractNumberFromId(id1);
        if (nbr1 < (nbr2 = ReadWriteManager.extractNumberFromId(id2))) {
            return -1;
        }
        if (nbr1 == nbr2) {
            return 0;
        }
        return 1;
    }

    private static int extractNumberFromId(String id) {
        Matcher matcher = Pattern.compile("^[a-z]*_?(\\d+)$").matcher(id);
        if (!matcher.find()) {
            throw new IllegalStateException("IdManager doesn't recognise the given id's (" + id + ") format. Should be [a-z]*_?[0-9]+");
        }
        return Integer.valueOf(matcher.group(1));
    }

    private static class Edge {
        String id;
        String from;
        String to;
        boolean head;

        Edge(TreeNode from, TreeNode to) {
            if (from.hasEdgeId()) {
                this.id = from.getEdgeId();
            }
            this.from = from.getId();
            this.to = to.getId();
            this.head = from.getHead();
        }
    }
}

