/*
 * Decompiled with CFR 0.152.
 */
package ixa.kaflib;

import ixa.kaflib.Annotation;
import ixa.kaflib.KAFDocument;
import ixa.kaflib.SentenceLevelAnnotation;
import ixa.kaflib.Span;
import ixa.kaflib.Term;
import ixa.kaflib.TreeNode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Terminal
extends TreeNode
implements SentenceLevelAnnotation {
    private Span<Term> span;

    Terminal(String id, Span<Term> span) {
        super(id, false, true);
        this.span = span;
    }

    public Span<Term> getSpan() {
        return this.span;
    }

    private String getStrValue() {
        String str = "";
        for (Term term : this.span.getTargets()) {
            if (!str.isEmpty()) {
                str = str + " ";
            }
            str = str + term.getStr();
        }
        return str;
    }

    public String getStr() {
        String strValue = this.getStrValue();
        if (strValue.startsWith("-") || strValue.endsWith("-")) {
            return strValue.replace("-", "- ");
        }
        if (strValue.contains("--")) {
            return strValue.replace("--", "-");
        }
        return strValue;
    }

    @Override
    public void addChild(TreeNode tn) throws Exception {
        throw new Exception("It is not possible to add child nodes to Terminal nodes.");
    }

    @Override
    public List<TreeNode> getChildren() {
        return null;
    }

    @Override
    Map<KAFDocument.AnnotationType, List<Annotation>> getReferencedAnnotations() {
        HashMap<KAFDocument.AnnotationType, List<Annotation>> referenced = new HashMap<KAFDocument.AnnotationType, List<Annotation>>();
        referenced.put(KAFDocument.AnnotationType.TERM, this.getSpan().getTargets());
        return referenced;
    }

    @Override
    public Integer getSent() {
        return this.getSpan().getFirstTarget().getSent();
    }

    @Override
    public Integer getPara() {
        return this.getSpan().getFirstTarget().getPara();
    }
}

