/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.chunk;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import opennlp.tools.chunker.ChunkerME;
import opennlp.tools.chunker.ChunkerModel;
import opennlp.tools.util.Span;

public class ChunkTagger {
    private ChunkerME chunkerTagger;
    private static ConcurrentHashMap<String, ChunkerModel> chunkerModels = new ConcurrentHashMap();

    public ChunkTagger(Properties properties) {
        String lang = properties.getProperty("language");
        String model = properties.getProperty("model");
        ChunkerModel posModel = this.loadModel(lang, model);
        this.chunkerTagger = new ChunkerME(posModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChunkerModel loadModel(String lang, String model) {
        long lStartTime = new Date().getTime();
        try {
            ConcurrentHashMap<String, ChunkerModel> concurrentHashMap = chunkerModels;
            synchronized (concurrentHashMap) {
                if (!chunkerModels.containsKey(lang)) {
                    chunkerModels.put(lang, new ChunkerModel((InputStream)new FileInputStream(model)));
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        long lEndTime = new Date().getTime();
        long difference = lEndTime - lStartTime;
        System.err.println("ixa-pipe-chunk model loaded in: " + difference + " miliseconds ... [DONE]");
        return chunkerModels.get(lang);
    }

    public String[] chunkToString(String[] tokens, String[] posTags) {
        String[] chunks = this.chunkerTagger.chunk(tokens, posTags);
        return chunks;
    }

    public Span[] chunk(String[] tokens, String[] posTags) {
        Span[] chunks = this.chunkerTagger.chunkAsSpans(tokens, posTags);
        return chunks;
    }
}

