/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.chunk.eval;

import eus.ixa.ixa.pipe.chunk.train.Flags;
import eus.ixa.ixa.pipe.chunk.train.InputOutputUtils;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import opennlp.tools.chunker.ChunkSample;
import opennlp.tools.chunker.ChunkSampleStream;
import opennlp.tools.chunker.ChunkerCrossValidator;
import opennlp.tools.chunker.ChunkerEvaluationMonitor;
import opennlp.tools.chunker.ChunkerFactory;
import opennlp.tools.cmdline.chunker.ChunkEvaluationErrorListener;
import opennlp.tools.cmdline.chunker.ChunkerDetailedFMeasureListener;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.TrainingParameters;
import opennlp.tools.util.eval.EvaluationMonitor;

public class CrossValidator {
    private final String lang;
    private final ObjectStream<ChunkSample> trainSamples;
    private final int folds;
    private ChunkerFactory chunkerFactory;
    private final List<EvaluationMonitor<ChunkSample>> listeners = new LinkedList<EvaluationMonitor<ChunkSample>>();
    ChunkerDetailedFMeasureListener detailedListener;

    public CrossValidator(TrainingParameters params) throws IOException {
        this.lang = Flags.getLanguage(params);
        String trainData = Flags.getDataSet("TrainSet", params);
        ObjectStream<String> trainStream = InputOutputUtils.readFileIntoMarkableStreamFactory(trainData);
        this.trainSamples = new ChunkSampleStream(trainStream);
        this.folds = Flags.getFolds(params);
        this.createChunkerFactory(params);
        this.getEvalListeners(params);
    }

    private void createChunkerFactory(TrainingParameters params) {
        String featureSet = Flags.getFeatureSet(params);
        this.chunkerFactory = featureSet.equalsIgnoreCase("Opennlp") ? new ChunkerFactory() : new ChunkerFactory();
    }

    private void getEvalListeners(TrainingParameters params) {
        if (((String)params.getSettings().get("EvaluationType")).equalsIgnoreCase("error")) {
            this.listeners.add((EvaluationMonitor<ChunkSample>)new ChunkEvaluationErrorListener());
        }
        if (((String)params.getSettings().get("EvaluationType")).equalsIgnoreCase("detailed")) {
            this.detailedListener = new ChunkerDetailedFMeasureListener();
            this.listeners.add((EvaluationMonitor<ChunkSample>)this.detailedListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void crossValidate(TrainingParameters params) {
        ChunkerCrossValidator validator = null;
        try {
            validator = this.getChunkerCrossValidator(params);
            validator.evaluate(this.trainSamples, this.folds);
        }
        catch (IOException e) {
            System.err.println("IO error while loading training set!");
            e.printStackTrace();
            System.exit(1);
        }
        finally {
            try {
                this.trainSamples.close();
            }
            catch (IOException e) {
                System.err.println("IO error with the train samples!");
            }
        }
        if (this.detailedListener == null) {
            System.out.println(validator.getFMeasure());
        } else {
            System.out.println(validator.getFMeasure());
        }
    }

    private ChunkerCrossValidator getChunkerCrossValidator(TrainingParameters params) {
        if (this.chunkerFactory == null) {
            throw new IllegalStateException("You must create the ChunkerFactory features!");
        }
        ChunkerCrossValidator validator = new ChunkerCrossValidator(this.lang, params, this.chunkerFactory, this.listeners.toArray(new ChunkerEvaluationMonitor[this.listeners.size()]));
        return validator;
    }
}

