/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.chunk.eval;

import eus.ixa.ixa.pipe.chunk.train.InputOutputUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import opennlp.tools.chunker.ChunkSample;
import opennlp.tools.chunker.ChunkSampleStream;
import opennlp.tools.chunker.Chunker;
import opennlp.tools.chunker.ChunkerEvaluationMonitor;
import opennlp.tools.chunker.ChunkerEvaluator;
import opennlp.tools.chunker.ChunkerME;
import opennlp.tools.chunker.ChunkerModel;
import opennlp.tools.cmdline.chunker.ChunkEvaluationErrorListener;
import opennlp.tools.cmdline.chunker.ChunkerDetailedFMeasureListener;
import opennlp.tools.util.ObjectStream;

public class Evaluate {
    private ObjectStream<ChunkSample> testSamples;
    private static ChunkerModel chunkerModel;
    private ChunkerME chunkerTagger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Evaluate(String testData, String model) throws IOException {
        ObjectStream<String> testStream = InputOutputUtils.readFileIntoMarkableStreamFactory(testData);
        this.testSamples = new ChunkSampleStream(testStream);
        FileInputStream trainedModelInputStream = null;
        try {
            if (chunkerModel == null) {
                trainedModelInputStream = new FileInputStream(model);
                chunkerModel = new ChunkerModel((InputStream)trainedModelInputStream);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (trainedModelInputStream != null) {
                try {
                    ((InputStream)trainedModelInputStream).close();
                }
                catch (IOException e) {
                    System.err.println("Could not load model!");
                }
            }
        }
        this.chunkerTagger = new ChunkerME(chunkerModel);
    }

    public final void evaluate() throws IOException {
        ChunkerEvaluator evaluator = new ChunkerEvaluator((Chunker)this.chunkerTagger, new ChunkerEvaluationMonitor[0]);
        evaluator.evaluate(this.testSamples);
        System.out.println(evaluator.getFMeasure());
    }

    public final void detailEvaluate() throws IOException {
        LinkedList<ChunkerDetailedFMeasureListener> listeners = new LinkedList<ChunkerDetailedFMeasureListener>();
        ChunkerDetailedFMeasureListener detailedFListener = new ChunkerDetailedFMeasureListener();
        listeners.add(detailedFListener);
        ChunkerEvaluator evaluator = new ChunkerEvaluator((Chunker)this.chunkerTagger, listeners.toArray(new ChunkerEvaluationMonitor[listeners.size()]));
        evaluator.evaluate(this.testSamples);
        System.out.println(detailedFListener.toString());
    }

    public final void evalError() throws IOException {
        LinkedList<ChunkEvaluationErrorListener> listeners = new LinkedList<ChunkEvaluationErrorListener>();
        listeners.add(new ChunkEvaluationErrorListener());
        ChunkerEvaluator evaluator = new ChunkerEvaluator((Chunker)this.chunkerTagger, listeners.toArray(new ChunkerEvaluationMonitor[listeners.size()]));
        evaluator.evaluate(this.testSamples);
        System.out.println(evaluator.getFMeasure());
    }
}

