/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.ml;

import com.google.common.io.Files;
import eus.ixa.ixa.pipe.ml.SequenceLabelerTrainer;
import eus.ixa.ixa.pipe.ml.ShiftReduceParserTrainer;
import eus.ixa.ixa.pipe.ml.eval.CrossValidator;
import eus.ixa.ixa.pipe.ml.eval.ParserEvaluate;
import eus.ixa.ixa.pipe.ml.eval.SequenceLabelerEvaluate;
import eus.ixa.ixa.pipe.ml.parse.ParserModel;
import eus.ixa.ixa.pipe.ml.sequence.SequenceLabelerModel;
import eus.ixa.ixa.pipe.ml.utils.Flags;
import eus.ixa.ixa.pipe.ml.utils.IOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.util.TrainingParameters;

public class CLI {
    private final String version = CLI.class.getPackage().getImplementationVersion();
    private Namespace parsedArguments = null;
    private ArgumentParser argParser = ArgumentParsers.newArgumentParser("ixa-pipe-ml-" + this.version + "-exec.jar").description("ixa-pipe-ml-" + this.version + " is a Machine Learning component to train and evaluate models for various IXA pipes tasks.\n");
    private Subparsers subParsers = this.argParser.addSubparsers().help("sub-command help");
    private Subparser seqTrainerParser = this.subParsers.addParser("sequenceTrainer").help("Sequence Labeler training CLI");
    private Subparser parserTrainerParser;
    private Subparser evalParser;
    private Subparser parsevalParser;
    private Subparser crossValidateParser;
    public static final String SEQ_TRAINER_NAME = "sequenceTrainer";
    public static final String PARSE_TRAINER_NAME = "parserTrainer";
    public static final String EVAL_PARSER_NAME = "eval";
    public static final String PARSEVAL_PARSER_NAME = "parseval";
    public static final String CROSS_PARSER_NAME = "cross";

    public CLI() {
        this.loadSeqLabelerTrainingParameters();
        this.parserTrainerParser = this.subParsers.addParser(PARSE_TRAINER_NAME).help("Constituent Parser training CLI");
        this.loadParserTrainingParameters();
        this.evalParser = this.subParsers.addParser(EVAL_PARSER_NAME).help("Evaluation CLI");
        this.loadEvalParameters();
        this.parsevalParser = this.subParsers.addParser(PARSEVAL_PARSER_NAME).help("Parseval CLI");
        this.loadParsevalParameters();
        this.crossValidateParser = this.subParsers.addParser(CROSS_PARSER_NAME).help("Cross validation CLI");
        this.loadCrossValidateParameters();
    }

    public static void main(String[] args) throws IOException {
        CLI cmdLine = new CLI();
        cmdLine.parseCLI(args);
    }

    public final void parseCLI(String[] args) throws IOException {
        try {
            this.parsedArguments = this.argParser.parseArgs(args);
            System.err.println("CLI options: " + this.parsedArguments);
            if (args[0].equals(EVAL_PARSER_NAME)) {
                this.eval();
            } else if (args[0].equals(PARSEVAL_PARSER_NAME)) {
                this.parseval();
            } else if (args[0].equals(SEQ_TRAINER_NAME)) {
                this.seqTrain();
            } else if (args[0].equals(PARSE_TRAINER_NAME)) {
                this.parserTrain();
            } else if (args[0].equals("CROSS_PARSER_NAME")) {
                this.crossValidate();
            }
        }
        catch (ArgumentParserException e) {
            this.argParser.handleError(e);
            System.out.println("Run java -jar target/ixa-pipe-ml-" + this.version + "-exec.jar (" + SEQ_TRAINER_NAME + "|" + PARSE_TRAINER_NAME + "|eval|parseval|cross) -help for details");
            System.exit(1);
        }
    }

    public final void seqTrain() throws IOException {
        String paramFile = this.parsedArguments.getString("params");
        TrainingParameters params = IOUtils.loadTrainingParameters(paramFile);
        String outModel = null;
        if (params.getSettings().get("OutputModel") == null || params.getSettings().get("OutputModel").length() == 0) {
            outModel = Files.getNameWithoutExtension(paramFile) + ".bin";
            params.put("OutputModel", outModel);
        } else {
            outModel = Flags.getModel(params);
        }
        SequenceLabelerTrainer nercTrainer = new SequenceLabelerTrainer(params);
        SequenceLabelerModel trainedModel = nercTrainer.train(params);
        CmdLineUtil.writeModel("ixa-pipe-ml", new File(outModel), trainedModel);
    }

    public final void parserTrain() throws IOException {
        ParserModel trainedModel;
        String paramFile = this.parsedArguments.getString("params");
        String taggerParamsFile = this.parsedArguments.getString("taggerParams");
        String chunkerParamsFile = this.parsedArguments.getString("chunkerParams");
        TrainingParameters params = IOUtils.loadTrainingParameters(paramFile);
        TrainingParameters chunkerParams = IOUtils.loadTrainingParameters(chunkerParamsFile);
        String outModel = null;
        if (params.getSettings().get("OutputModel") == null || params.getSettings().get("OutputModel").length() == 0) {
            outModel = Files.getNameWithoutExtension(paramFile) + ".bin";
            params.put("OutputModel", outModel);
        } else {
            outModel = Flags.getModel(params);
        }
        if (taggerParamsFile.endsWith(".bin")) {
            FileInputStream posModel = new FileInputStream(taggerParamsFile);
            ShiftReduceParserTrainer parserTrainer = new ShiftReduceParserTrainer(params, chunkerParams);
            trainedModel = parserTrainer.train(params, posModel, chunkerParams);
        } else {
            TrainingParameters taggerParams = IOUtils.loadTrainingParameters(taggerParamsFile);
            ShiftReduceParserTrainer parserTrainer = new ShiftReduceParserTrainer(params, taggerParams, chunkerParams);
            trainedModel = parserTrainer.train(params, taggerParams, chunkerParams);
        }
        CmdLineUtil.writeModel("ixa-pipe-ml", new File(outModel), trainedModel);
    }

    public final void eval() throws IOException {
        String metric = this.parsedArguments.getString("metric");
        String lang = this.parsedArguments.getString("language");
        String model = this.parsedArguments.getString("model");
        String testset = this.parsedArguments.getString("testset");
        String corpusFormat = this.parsedArguments.getString("corpusFormat");
        String netypes = this.parsedArguments.getString("types");
        String clearFeatures = this.parsedArguments.getString("clearFeatures");
        String unknownAccuracy = this.parsedArguments.getString("unknownAccuracy");
        Properties props = this.setEvalProperties(lang, model, testset, corpusFormat, netypes, clearFeatures, unknownAccuracy);
        SequenceLabelerEvaluate evaluator = new SequenceLabelerEvaluate(props);
        if (metric.equalsIgnoreCase("accuracy")) {
            evaluator.evaluateAccuracy();
        } else if (this.parsedArguments.getString("evalReport") != null) {
            if (this.parsedArguments.getString("evalReport").equalsIgnoreCase("brief")) {
                evaluator.evaluate();
            } else if (this.parsedArguments.getString("evalReport").equalsIgnoreCase("error")) {
                evaluator.evalError();
            } else if (this.parsedArguments.getString("evalReport").equalsIgnoreCase("detailed")) {
                evaluator.detailEvaluate();
            }
        } else {
            evaluator.detailEvaluate();
        }
    }

    public final void parseval() throws IOException {
        String lang = this.parsedArguments.getString("language");
        String model = this.parsedArguments.getString("model");
        String testset = this.parsedArguments.getString("testset");
        Properties props = this.setParsevalProperties(lang, model, testset);
        ParserEvaluate parserEvaluator = new ParserEvaluate(props);
        parserEvaluator.evaluate();
    }

    public final void crossValidate() throws IOException {
        String paramFile = this.parsedArguments.getString("params");
        TrainingParameters params = IOUtils.loadTrainingParameters(paramFile);
        CrossValidator crossValidator = new CrossValidator(params);
        crossValidator.crossValidate(params);
    }

    private void loadSeqLabelerTrainingParameters() {
        this.seqTrainerParser.addArgument("-p", "--params").required(true).help("Load the training parameters file\n");
    }

    private void loadParserTrainingParameters() {
        this.parserTrainerParser.addArgument("-p", "--params").required(true).help("Load the parsing training parameters file.\n");
        this.parserTrainerParser.addArgument("-t", "--taggerParams").required(false).help("Load the tagger training parameters file.\n");
        this.parserTrainerParser.addArgument("-c", "--chunkerParams").required(false).help("Load the chunker training parameters file.\n");
    }

    private void loadEvalParameters() {
        this.evalParser.addArgument("--metric").required(false).choices("accuracy", "fmeasure").setDefault("fmeasure").help("Choose evaluation metric for Sequence Labeler; it defaults to fmeasure.\n");
        this.evalParser.addArgument("-l", "--language").required(true).choices("de", "en", "es", "eu", "it", "nl").help("Choose language.\n");
        this.evalParser.addArgument("-m", "--model").required(false).setDefault("off").help("Pass the model to evaluate as a parameter.\n");
        this.evalParser.addArgument("-t", "--testset").required(true).help("The test or reference corpus.\n");
        this.evalParser.addArgument("--clearFeatures").required(false).choices("yes", "no", "docstart").setDefault("no").help("Reset the adaptive features; defaults to 'no'.\n");
        this.evalParser.addArgument("-f", "--corpusFormat").required(false).choices("conll02", "conll03", "lemmatizer", "tabulated").setDefault("conll02").help("Choose format of reference corpus; it defaults to conll02 format.\n");
        this.evalParser.addArgument("--evalReport").required(false).choices("brief", "detailed", "error").help("Choose level of detail of evaluation report; it defaults to detailed evaluation.\n");
        this.evalParser.addArgument("--types").required(false).setDefault("off").help("Choose which Sequence types used for evaluation; the argument must be a comma separated string; e.g., 'person,organization'.\n");
        this.evalParser.addArgument("-u", "--unknownAccuracy").required(false).setDefault("no").help("Pass the model training set to evaluate unknown and known word accuracy.\n");
    }

    private void loadParsevalParameters() {
        this.parsevalParser.addArgument("-l", "--language").required(true).choices("ca", "de", "en", "es", "eu", "fr", "it").help("Choose language.\n");
        this.parsevalParser.addArgument("-m", "--model").required(false).setDefault("off").help("Pass the model to evaluate as a parameter.\n");
        this.parsevalParser.addArgument("-t", "--testset").required(true).help("The test or reference corpus.\n");
        this.parsevalParser.addArgument("--clearFeatures").required(false).choices("yes", "no", "docstart").setDefault("no").help("Reset the adaptive features; defaults to 'no'.\n");
    }

    private void loadCrossValidateParameters() {
        this.crossValidateParser.addArgument("-p", "--params").required(true).help("Load the Cross validation parameters file\n");
    }

    private Properties setEvalProperties(String language, String model, String testset, String corpusFormat, String netypes, String clearFeatures, String unknownAccuracy) {
        Properties evalProperties = new Properties();
        evalProperties.setProperty("language", language);
        evalProperties.setProperty("model", model);
        evalProperties.setProperty("testset", testset);
        evalProperties.setProperty("corpusFormat", corpusFormat);
        evalProperties.setProperty("types", netypes);
        evalProperties.setProperty("clearFeatures", clearFeatures);
        evalProperties.setProperty("unknownAccuracy", unknownAccuracy);
        return evalProperties;
    }

    private Properties setParsevalProperties(String language, String model, String testset) {
        Properties parsevalProperties = new Properties();
        parsevalProperties.setProperty("language", language);
        parsevalProperties.setProperty("model", model);
        parsevalProperties.setProperty("testset", testset);
        return parsevalProperties;
    }
}

