/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.ml.features;

import eus.ixa.ixa.pipe.ml.resources.POSDictionary;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.featuregen.ArtifactToSerializerMapper;
import opennlp.tools.util.featuregen.CustomFeatureGenerator;
import opennlp.tools.util.featuregen.FeatureGeneratorResourceProvider;
import opennlp.tools.util.model.ArtifactSerializer;

public class POSDictionaryFeatureGenerator
extends CustomFeatureGenerator
implements ArtifactToSerializerMapper {
    private POSDictionary posDictionary;
    private Map<String, String> attributes;

    @Override
    public void createFeatures(List<String> features, String[] tokens, int index, String[] preds) {
        String posTag = this.posDictionary.getMostFrequentTag(tokens[index].toLowerCase());
        features.add(this.attributes.get("dict") + "=" + posTag);
    }

    @Override
    public void updateAdaptiveData(String[] tokens, String[] outcomes) {
    }

    @Override
    public void clearAdaptiveData() {
    }

    @Override
    public void init(Map<String, String> properties, FeatureGeneratorResourceProvider resourceProvider) throws InvalidFormatException {
        Object dictResource = resourceProvider.getResource(properties.get("dict"));
        if (!(dictResource instanceof POSDictionary)) {
            throw new InvalidFormatException("Not a POSDictionary resource for key: " + properties.get("dict"));
        }
        this.posDictionary = (POSDictionary)dictResource;
        this.attributes = properties;
    }

    @Override
    public Map<String, ArtifactSerializer<?>> getArtifactSerializerMapping() {
        HashMap<String, POSDictionary.POSDictionarySerializer> mapping = new HashMap<String, POSDictionary.POSDictionarySerializer>();
        mapping.put("posdictserializer", new POSDictionary.POSDictionarySerializer());
        return Collections.unmodifiableMap(mapping);
    }
}

