/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.ml.features;

import eus.ixa.ixa.pipe.ml.utils.Flags;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.featuregen.CustomFeatureGenerator;
import opennlp.tools.util.featuregen.FeatureGeneratorResourceProvider;
import opennlp.tools.util.featuregen.StringPattern;

public class TokenClassFeatureGenerator
extends CustomFeatureGenerator {
    private boolean isLower;
    private boolean isWordAndClassFeature;
    private static Pattern capPeriod = Pattern.compile("^[A-Z]\\.$");

    @Override
    public void createFeatures(List<String> features, String[] tokens, int index, String[] preds) {
        String wordClass = TokenClassFeatureGenerator.tokenShapeFeature(tokens[index]);
        features.add("wc=" + wordClass);
        if (this.isWordAndClassFeature) {
            if (this.isLower) {
                features.add("w&c=" + tokens[index].toLowerCase() + "," + wordClass);
            } else {
                features.add("w&c=" + tokens[index] + "," + wordClass);
            }
        }
    }

    public static String tokenShapeFeature(String token) {
        StringPattern pattern = StringPattern.recognize(token);
        String feat = pattern.isAllLowerCaseLetter() ? "lc" : (pattern.digits() == 2 ? "2d" : (pattern.digits() == 4 ? "4d" : (pattern.containsDigit() ? (pattern.containsLetters() ? "an" : (pattern.containsHyphen() ? "dd" : (pattern.containsSlash() ? "ds" : (pattern.containsComma() ? "dc" : (pattern.containsPeriod() ? "dp" : "num"))))) : (pattern.isAllCapitalLetter() && token.length() == 1 ? "sc" : (pattern.isAllCapitalLetter() ? "ac" : (capPeriod.matcher(token).find() ? "cp" : (pattern.isInitialCapitalLetter() ? "ic" : "other")))))));
        return feat;
    }

    @Override
    public void updateAdaptiveData(String[] tokens, String[] outcomes) {
    }

    @Override
    public void clearAdaptiveData() {
    }

    @Override
    public void init(Map<String, String> properties, FeatureGeneratorResourceProvider resourceProvider) throws InvalidFormatException {
        this.processRangeOptions(properties);
    }

    private void processRangeOptions(Map<String, String> properties) {
        String featuresRange = properties.get("range");
        String[] rangeArray = Flags.processTokenClassFeaturesRange(featuresRange);
        if (rangeArray[0].equalsIgnoreCase("lower")) {
            this.isLower = true;
        }
        if (rangeArray[1].equalsIgnoreCase("wac")) {
            this.isWordAndClassFeature = true;
        }
    }
}

