/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.ml.features;

import eus.ixa.ixa.pipe.ml.features.BigramClassFeatureGenerator;
import eus.ixa.ixa.pipe.ml.features.BrownBigramFeatureGenerator;
import eus.ixa.ixa.pipe.ml.features.BrownTokenClassFeatureGenerator;
import eus.ixa.ixa.pipe.ml.features.BrownTokenFeatureGenerator;
import eus.ixa.ixa.pipe.ml.features.CharacterNgramFeatureGenerator;
import eus.ixa.ixa.pipe.ml.features.ChunkBaselineContextGenerator;
import eus.ixa.ixa.pipe.ml.features.ClarkFeatureGenerator;
import eus.ixa.ixa.pipe.ml.features.DictionaryFeatureGenerator;
import eus.ixa.ixa.pipe.ml.features.FivegramClassFeatureGenerator;
import eus.ixa.ixa.pipe.ml.features.FourgramClassFeatureGenerator;
import eus.ixa.ixa.pipe.ml.features.LemmaBaselineContextGenerator;
import eus.ixa.ixa.pipe.ml.features.LemmaDictionaryFeatureGenerator;
import eus.ixa.ixa.pipe.ml.features.LemmaModelFeatureGenerator;
import eus.ixa.ixa.pipe.ml.features.MFSFeatureGenerator;
import eus.ixa.ixa.pipe.ml.features.OutcomePriorFeatureGenerator;
import eus.ixa.ixa.pipe.ml.features.POSBaselineContextGenerator;
import eus.ixa.ixa.pipe.ml.features.POSDictionaryFeatureGenerator;
import eus.ixa.ixa.pipe.ml.features.POSTagModelFeatureGenerator;
import eus.ixa.ixa.pipe.ml.features.PredicateContextFeatureGenerator;
import eus.ixa.ixa.pipe.ml.features.PrefixFeatureGenerator;
import eus.ixa.ixa.pipe.ml.features.Prev2MapFeatureGenerator;
import eus.ixa.ixa.pipe.ml.features.PreviousMapFeatureGenerator;
import eus.ixa.ixa.pipe.ml.features.PreviousMapTokenFeatureGenerator;
import eus.ixa.ixa.pipe.ml.features.SentenceFeatureGenerator;
import eus.ixa.ixa.pipe.ml.features.SuffixFeatureGenerator;
import eus.ixa.ixa.pipe.ml.features.SuperSenseFeatureGenerator;
import eus.ixa.ixa.pipe.ml.features.TokenClassFeatureGenerator;
import eus.ixa.ixa.pipe.ml.features.TokenFeatureGenerator;
import eus.ixa.ixa.pipe.ml.features.TrigramClassFeatureGenerator;
import eus.ixa.ixa.pipe.ml.features.Word2VecClusterFeatureGenerator;
import eus.ixa.ixa.pipe.ml.features.WordShapeSuperSenseFeatureGenerator;
import eus.ixa.ixa.pipe.ml.utils.Flags;
import eus.ixa.ixa.pipe.ml.utils.IOUtils;
import eus.ixa.ixa.pipe.ml.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import opennlp.tools.util.TrainingParameters;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public final class XMLFeatureDescriptor {
    private static int leftWindow = -1;
    private static int rightWindow = -1;

    private XMLFeatureDescriptor() {
    }

    public static int getLeftWindow() {
        return leftWindow;
    }

    public static int getRightWindow() {
        return rightWindow;
    }

    public static String createXMLFeatureDescriptor(TrainingParameters params) throws IOException {
        String endSuffix;
        String beginSuffix;
        Element mfsClassFeatureElement;
        String seqCodec;
        String mfsRange;
        String[] mfsResources;
        String mfsPath;
        String endPrefix;
        String beginPrefix;
        Element aggGenerators = new Element("generators");
        Document doc = new Document(aggGenerators);
        Element cached = new Element("cache");
        Element generators = new Element("generators");
        if (Flags.isTokenFeature(params)) {
            XMLFeatureDescriptor.setWindow(params);
            String tokenFeatureRange = Flags.getTokenFeaturesRange(params);
            Element tokenFeature = new Element("custom");
            tokenFeature.setAttribute("class", TokenFeatureGenerator.class.getName());
            tokenFeature.setAttribute("range", tokenFeatureRange);
            Element tokenWindow = new Element("window");
            tokenWindow.setAttribute("prevLength", Integer.toString(leftWindow));
            tokenWindow.setAttribute("nextLength", Integer.toString(rightWindow));
            tokenWindow.addContent(tokenFeature);
            generators.addContent(tokenWindow);
            System.err.println("-> Token features added!: Window range " + leftWindow + ":" + rightWindow);
        }
        if (Flags.isTokenClassFeature(params)) {
            XMLFeatureDescriptor.setWindow(params);
            String tokenClassFeatureRange = Flags.getTokenClassFeaturesRange(params);
            Element tokenClassFeature = new Element("custom");
            tokenClassFeature.setAttribute("class", TokenClassFeatureGenerator.class.getName());
            tokenClassFeature.setAttribute("range", tokenClassFeatureRange);
            Element tokenClassWindow = new Element("window");
            tokenClassWindow.setAttribute("prevLength", Integer.toString(leftWindow));
            tokenClassWindow.setAttribute("nextLength", Integer.toString(rightWindow));
            tokenClassWindow.addContent(tokenClassFeature);
            generators.addContent(tokenClassWindow);
            System.err.println("-> Token Class Features added!: Window range " + leftWindow + ":" + rightWindow);
        }
        if (Flags.isWordShapeSuperSenseFeature(params)) {
            XMLFeatureDescriptor.setWindow(params);
            Element wordShapeSuperSenseFeature = new Element("custom");
            wordShapeSuperSenseFeature.setAttribute("class", WordShapeSuperSenseFeatureGenerator.class.getName());
            Element wordShapeWindow = new Element("window");
            wordShapeWindow.setAttribute("prevLength", Integer.toString(leftWindow));
            wordShapeWindow.setAttribute("nextLength", Integer.toString(rightWindow));
            wordShapeWindow.addContent(wordShapeSuperSenseFeature);
            generators.addContent(wordShapeWindow);
            System.err.println("-> Word Shape SuperSense Features added!: Window range " + leftWindow + ":" + rightWindow);
        }
        if (Flags.isOutcomePriorFeature(params)) {
            Element outcomePriorFeature = new Element("custom");
            outcomePriorFeature.setAttribute("class", OutcomePriorFeatureGenerator.class.getName());
            generators.addContent(outcomePriorFeature);
            System.err.println("-> Outcome Prior Features added!");
        }
        if (Flags.isPreviousMapFeature(params)) {
            Element previousMapFeature = new Element("custom");
            previousMapFeature.setAttribute("class", PreviousMapFeatureGenerator.class.getName());
            generators.addContent(previousMapFeature);
            System.err.println("-> Previous Map Features added!");
        }
        if (Flags.isSentenceFeature(params)) {
            String beginSentence = Flags.getSentenceFeaturesBegin(params);
            String endSentence = Flags.getSentenceFeaturesEnd(params);
            Element sentenceFeature = new Element("custom");
            sentenceFeature.setAttribute("class", SentenceFeatureGenerator.class.getName());
            sentenceFeature.setAttribute("begin", beginSentence);
            sentenceFeature.setAttribute("end", endSentence);
            generators.addContent(sentenceFeature);
            System.err.println("-> Sentence Features added!");
        }
        if (Flags.isPrefixFeature(params)) {
            beginPrefix = Flags.getPrefixFeaturesBegin(params);
            endPrefix = Flags.getPrefixFeaturesEnd(params);
            Element prefixFeature = new Element("custom");
            prefixFeature.setAttribute("class", PrefixFeatureGenerator.class.getName());
            prefixFeature.setAttribute("begin", beginPrefix);
            prefixFeature.setAttribute("end", endPrefix);
            generators.addContent(prefixFeature);
            System.err.println("-> Prefix Features added!");
        }
        if (Flags.isSuffixFeature(params)) {
            String beginSuffix2 = Flags.getSuffixFeaturesBegin(params);
            String endSuffix2 = Flags.getSuffixFeaturesEnd(params);
            Element suffixFeature = new Element("custom");
            suffixFeature.setAttribute("class", SuffixFeatureGenerator.class.getName());
            suffixFeature.setAttribute("begin", beginSuffix2);
            suffixFeature.setAttribute("end", endSuffix2);
            generators.addContent(suffixFeature);
            System.err.println("-> Suffix Features added!");
        }
        if (Flags.isBigramClassFeature(params)) {
            Element bigramFeature = new Element("custom");
            bigramFeature.setAttribute("class", BigramClassFeatureGenerator.class.getName());
            generators.addContent(bigramFeature);
            System.err.println("-> Bigram Class Features added!");
        }
        if (Flags.isTrigramClassFeature(params)) {
            Element trigramFeature = new Element("custom");
            trigramFeature.setAttribute("class", TrigramClassFeatureGenerator.class.getName());
            generators.addContent(trigramFeature);
            System.err.println("-> Trigram Class Features added!");
        }
        if (Flags.isFourgramClassFeature(params)) {
            Element fourgramFeature = new Element("custom");
            fourgramFeature.setAttribute("class", FourgramClassFeatureGenerator.class.getName());
            generators.addContent(fourgramFeature);
            System.err.println("-> Fourgram Class Features added!");
        }
        if (Flags.isFivegramClassFeature(params)) {
            Element fivegramFeature = new Element("custom");
            fivegramFeature.setAttribute("class", FivegramClassFeatureGenerator.class.getName());
            generators.addContent(fivegramFeature);
            System.err.println("-> Fivegram Class Features added!");
        }
        if (Flags.isCharNgramClassFeature(params)) {
            String charngramRange = Flags.getCharNgramFeaturesRange(params);
            String[] rangeArray = Flags.processNgramRange(charngramRange);
            Element charngramFeature = new Element("custom");
            charngramFeature.setAttribute("class", CharacterNgramFeatureGenerator.class.getName());
            charngramFeature.setAttribute("minLength", rangeArray[0]);
            charngramFeature.setAttribute("maxLength", rangeArray[1]);
            generators.addContent(charngramFeature);
            System.err.println("-> CharNgram Class Features added!");
        }
        if (Flags.isDictionaryFeatures(params)) {
            XMLFeatureDescriptor.setWindow(params);
            String dictPath = Flags.getDictionaryFeatures(params);
            String seqCodec2 = Flags.getSequenceCodec(params);
            List<File> fileList = StringUtils.getFilesInDir(new File(dictPath));
            for (File dictFile : fileList) {
                Element dictFeatures = new Element("custom");
                dictFeatures.setAttribute("class", DictionaryFeatureGenerator.class.getName());
                dictFeatures.setAttribute("dict", IOUtils.normalizeLexiconName(dictFile.getName()));
                dictFeatures.setAttribute("seqCodec", seqCodec2);
                Element dictWindow = new Element("window");
                dictWindow.setAttribute("prevLength", Integer.toString(leftWindow));
                dictWindow.setAttribute("nextLength", Integer.toString(rightWindow));
                dictWindow.addContent(dictFeatures);
                generators.addContent(dictWindow);
            }
            System.err.println("-> Dictionary Features added!");
        }
        if (Flags.isBrownFeatures(params)) {
            XMLFeatureDescriptor.setWindow(params);
            Element prev2MapFeature = new Element("custom");
            prev2MapFeature.setAttribute("class", Prev2MapFeatureGenerator.class.getName());
            Element prevMapTokenFeature = new Element("custom");
            prevMapTokenFeature.setAttribute("class", PreviousMapTokenFeatureGenerator.class.getName());
            Element prevMapTokenWindow = new Element("window");
            prevMapTokenWindow.setAttribute("prevLength", Integer.toString(leftWindow));
            prevMapTokenWindow.setAttribute("nextLength", Integer.toString(rightWindow));
            prevMapTokenWindow.addContent(prevMapTokenFeature);
            String brownClusterPath = Flags.getBrownFeatures(params);
            List<File> brownClusterFiles = Flags.getClusterLexiconFiles(brownClusterPath);
            for (File brownClusterFile : brownClusterFiles) {
                Element brownBigramFeatures = new Element("custom");
                brownBigramFeatures.setAttribute("class", BrownBigramFeatureGenerator.class.getName());
                brownBigramFeatures.setAttribute("dict", IOUtils.normalizeLexiconName(brownClusterFile.getName()));
                generators.addContent(brownBigramFeatures);
                Element brownTokenFeature = new Element("custom");
                brownTokenFeature.setAttribute("class", BrownTokenFeatureGenerator.class.getName());
                brownTokenFeature.setAttribute("dict", IOUtils.normalizeLexiconName(brownClusterFile.getName()));
                Element brownTokenWindow = new Element("window");
                brownTokenWindow.setAttribute("prevLength", Integer.toString(leftWindow));
                brownTokenWindow.setAttribute("nextLength", Integer.toString(rightWindow));
                brownTokenWindow.addContent(brownTokenFeature);
                generators.addContent(brownTokenWindow);
                Element brownTokenClassFeature = new Element("custom");
                brownTokenClassFeature.setAttribute("class", BrownTokenClassFeatureGenerator.class.getName());
                brownTokenClassFeature.setAttribute("dict", IOUtils.normalizeLexiconName(brownClusterFile.getName()));
                Element brownTokenClassWindow = new Element("window");
                brownTokenClassWindow.setAttribute("prevLength", Integer.toString(leftWindow));
                brownTokenClassWindow.setAttribute("nextLength", Integer.toString(rightWindow));
                brownTokenClassWindow.addContent(brownTokenClassFeature);
                generators.addContent(brownTokenClassWindow);
            }
            System.err.println("-> Brown Cluster Features added!");
        }
        if (Flags.isClarkFeatures(params)) {
            XMLFeatureDescriptor.setWindow(params);
            String clarkClusterPath = Flags.getClarkFeatures(params);
            List<File> clarkClusterFiles = Flags.getClusterLexiconFiles(clarkClusterPath);
            for (File clarkCluster : clarkClusterFiles) {
                Element clarkFeatures = new Element("custom");
                clarkFeatures.setAttribute("class", ClarkFeatureGenerator.class.getName());
                clarkFeatures.setAttribute("dict", IOUtils.normalizeLexiconName(clarkCluster.getName()));
                Element clarkWindow = new Element("window");
                clarkWindow.setAttribute("prevLength", Integer.toString(leftWindow));
                clarkWindow.setAttribute("nextLength", Integer.toString(rightWindow));
                clarkWindow.addContent(clarkFeatures);
                generators.addContent(clarkWindow);
            }
            System.err.println("-> Clark Cluster Features added!");
        }
        if (Flags.isWord2VecClusterFeatures(params)) {
            XMLFeatureDescriptor.setWindow(params);
            String word2vecClusterPath = Flags.getWord2VecClusterFeatures(params);
            List<File> word2vecClusterFiles = Flags.getClusterLexiconFiles(word2vecClusterPath);
            for (File word2vecFile : word2vecClusterFiles) {
                Element word2vecClusterFeatures = new Element("custom");
                word2vecClusterFeatures.setAttribute("class", Word2VecClusterFeatureGenerator.class.getName());
                word2vecClusterFeatures.setAttribute("dict", IOUtils.normalizeLexiconName(word2vecFile.getName()));
                Element word2vecClusterWindow = new Element("window");
                word2vecClusterWindow.setAttribute("prevLength", Integer.toString(leftWindow));
                word2vecClusterWindow.setAttribute("nextLength", Integer.toString(rightWindow));
                word2vecClusterWindow.addContent(word2vecClusterFeatures);
                generators.addContent(word2vecClusterWindow);
            }
            System.err.println("-> Word2Vec Clusters Features added!");
        }
        if (Flags.isPOSTagModelFeatures(params)) {
            XMLFeatureDescriptor.setWindow(params);
            String posModelPath = Flags.getPOSTagModelFeatures(params);
            String posModelRange = Flags.getPOSTagModelFeaturesRange(params);
            Element posTagClassFeatureElement = new Element("custom");
            posTagClassFeatureElement.setAttribute("class", POSTagModelFeatureGenerator.class.getName());
            posTagClassFeatureElement.setAttribute("model", IOUtils.normalizeLexiconName(new File(posModelPath).getName()));
            posTagClassFeatureElement.setAttribute("range", posModelRange);
            Element posTagClassFeatureWindow = new Element("window");
            posTagClassFeatureWindow.setAttribute("prevLength", Integer.toString(leftWindow));
            posTagClassFeatureWindow.setAttribute("nextLength", Integer.toString(rightWindow));
            posTagClassFeatureWindow.addContent(posTagClassFeatureElement);
            generators.addContent(posTagClassFeatureWindow);
            System.err.println("-> POSTagModel Features added!");
        }
        if (Flags.isPOSDictionaryFeatures(params)) {
            XMLFeatureDescriptor.setWindow(params);
            String posDictPath = Flags.getPOSDictionaryFeatures(params);
            Element posDictFeatures = new Element("custom");
            posDictFeatures.setAttribute("class", POSDictionaryFeatureGenerator.class.getName());
            posDictFeatures.setAttribute("dict", IOUtils.normalizeLexiconName(new File(posDictPath).getName()));
            Element posDictWindow = new Element("window");
            posDictWindow.setAttribute("prevLength", Integer.toString(leftWindow));
            posDictWindow.setAttribute("nextLength", Integer.toString(rightWindow));
            posDictWindow.addContent(posDictFeatures);
            generators.addContent(posDictWindow);
            System.err.println("-> POSDictionary Features added!");
        }
        if (Flags.isLemmaModelFeatures(params)) {
            XMLFeatureDescriptor.setWindow(params);
            String lemmaModelPath = Flags.getLemmaModelFeatures(params);
            Element lemmaClassFeatureElement = new Element("custom");
            lemmaClassFeatureElement.setAttribute("class", LemmaModelFeatureGenerator.class.getName());
            lemmaClassFeatureElement.setAttribute("model", IOUtils.normalizeLexiconName(new File(lemmaModelPath).getName()));
            Element lemmaClassFeatureWindow = new Element("window");
            lemmaClassFeatureWindow.setAttribute("prevLength", Integer.toString(leftWindow));
            lemmaClassFeatureWindow.setAttribute("nextLength", Integer.toString(rightWindow));
            lemmaClassFeatureWindow.addContent(lemmaClassFeatureElement);
            generators.addContent(lemmaClassFeatureWindow);
            System.err.println("-> LemmaModel Features added!");
        }
        if (Flags.isLemmaDictionaryFeatures(params)) {
            XMLFeatureDescriptor.setWindow(params);
            String lemmaDictPath = Flags.getLemmaDictionaryFeatures(params);
            String[] lemmaDictResources = Flags.getLemmaDictionaryResources(lemmaDictPath);
            Element lemmaClassFeatureElement = new Element("custom");
            lemmaClassFeatureElement.setAttribute("class", LemmaDictionaryFeatureGenerator.class.getName());
            lemmaClassFeatureElement.setAttribute("model", IOUtils.normalizeLexiconName(new File(lemmaDictResources[0]).getName()));
            lemmaClassFeatureElement.setAttribute("dict", IOUtils.normalizeLexiconName(new File(lemmaDictResources[1]).getName()));
            Element lemmaClassFeatureWindow = new Element("window");
            lemmaClassFeatureWindow.setAttribute("prevLength", Integer.toString(leftWindow));
            lemmaClassFeatureWindow.setAttribute("nextLength", Integer.toString(rightWindow));
            lemmaClassFeatureWindow.addContent(lemmaClassFeatureElement);
            generators.addContent(lemmaClassFeatureWindow);
            System.err.println("-> LemmaDictionary Features added!");
        }
        if (Flags.isMFSFeatures(params)) {
            XMLFeatureDescriptor.setWindow(params);
            mfsPath = Flags.getMFSFeatures(params);
            mfsResources = Flags.getMFSResources(mfsPath);
            mfsRange = Flags.getMFSFeaturesRange(params);
            seqCodec = Flags.getSequenceCodec(params);
            mfsClassFeatureElement = new Element("custom");
            mfsClassFeatureElement.setAttribute("class", MFSFeatureGenerator.class.getName());
            mfsClassFeatureElement.setAttribute("model", IOUtils.normalizeLexiconName(new File(mfsResources[0]).getName()));
            mfsClassFeatureElement.setAttribute("dict", IOUtils.normalizeLexiconName(new File(mfsResources[1]).getName()));
            mfsClassFeatureElement.setAttribute("mfs", IOUtils.normalizeLexiconName(new File(mfsResources[2]).getName()));
            mfsClassFeatureElement.setAttribute("range", mfsRange);
            mfsClassFeatureElement.setAttribute("seqCodec", seqCodec);
            Element mfsClassFeatureWindow = new Element("window");
            mfsClassFeatureWindow.setAttribute("prevLength", Integer.toString(leftWindow));
            mfsClassFeatureWindow.setAttribute("nextLength", Integer.toString(rightWindow));
            mfsClassFeatureWindow.addContent(mfsClassFeatureElement);
            generators.addContent(mfsClassFeatureWindow);
            System.err.println("-> MFS Features added");
        }
        if (Flags.isSuperSenseFeatures(params)) {
            mfsPath = Flags.getSuperSenseFeatures(params);
            mfsResources = Flags.getSuperSenseResources(mfsPath);
            mfsRange = Flags.getSuperSenseFeaturesRange(params);
            seqCodec = Flags.getSequenceCodec(params);
            mfsClassFeatureElement = new Element("custom");
            mfsClassFeatureElement.setAttribute("class", SuperSenseFeatureGenerator.class.getName());
            mfsClassFeatureElement.setAttribute("model", IOUtils.normalizeLexiconName(new File(mfsResources[0]).getName()));
            mfsClassFeatureElement.setAttribute("dict", IOUtils.normalizeLexiconName(new File(mfsResources[1]).getName()));
            mfsClassFeatureElement.setAttribute("mfs", IOUtils.normalizeLexiconName(new File(mfsResources[2]).getName()));
            mfsClassFeatureElement.setAttribute("range", mfsRange);
            mfsClassFeatureElement.setAttribute("seqCodec", seqCodec);
            generators.addContent(mfsClassFeatureElement);
            System.err.println("-> SuperSense Features added!");
        }
        if (Flags.isPOSBaselineFeatures(params)) {
            beginPrefix = Flags.getPrefixBegin(params);
            endPrefix = Flags.getPrefixEnd(params);
            beginSuffix = Flags.getSuffixBegin(params);
            endSuffix = Flags.getSuffixEnd(params);
            Element posFeatureElement = new Element("custom");
            posFeatureElement.setAttribute("class", POSBaselineContextGenerator.class.getName());
            posFeatureElement.setAttribute("prefBegin", beginPrefix);
            posFeatureElement.setAttribute("prefEnd", endPrefix);
            posFeatureElement.setAttribute("sufBegin", beginSuffix);
            posFeatureElement.setAttribute("sufEnd", endSuffix);
            generators.addContent(posFeatureElement);
            System.err.println("-> POS Baseline Context Generator added!");
        }
        if (Flags.isLemmaBaselineFeatures(params)) {
            beginPrefix = Flags.getPrefixBegin(params);
            endPrefix = Flags.getPrefixEnd(params);
            beginSuffix = Flags.getSuffixBegin(params);
            endSuffix = Flags.getSuffixEnd(params);
            String posModel = Flags.getLemmaBaselineFeatures(params);
            String lemmaRange = Flags.getLemmaBaselineFeaturesRange(params);
            Element lemmaFeatureElement = new Element("custom");
            lemmaFeatureElement.setAttribute("class", LemmaBaselineContextGenerator.class.getName());
            lemmaFeatureElement.setAttribute("prefBegin", beginPrefix);
            lemmaFeatureElement.setAttribute("prefEnd", endPrefix);
            lemmaFeatureElement.setAttribute("sufBegin", beginSuffix);
            lemmaFeatureElement.setAttribute("sufEnd", endSuffix);
            lemmaFeatureElement.setAttribute("model", IOUtils.normalizeLexiconName(new File(posModel).getName()));
            lemmaFeatureElement.setAttribute("range", lemmaRange);
            generators.addContent(lemmaFeatureElement);
            System.err.println("-> Lemma Baseline Context Generator added!");
        }
        if (Flags.isChunkBaselineFeatures(params)) {
            String posModel = Flags.getChunkBaselineFeatures(params);
            Element chunkFeatureElement = new Element("custom");
            chunkFeatureElement.setAttribute("class", ChunkBaselineContextGenerator.class.getName());
            chunkFeatureElement.setAttribute("model", IOUtils.normalizeLexiconName(new File(posModel).getName()));
            generators.addContent(chunkFeatureElement);
            System.err.println("-> Chunk Baseline Context Generator added!");
        }
        if (Flags.isPredicateContextFeatures(params)) {
            String predicateContextFile = Flags.getPredicateContextFeatures(params);
            Element predicateContextFeatureElement = new Element("custom");
            predicateContextFeatureElement.setAttribute("class", PredicateContextFeatureGenerator.class.getName());
            predicateContextFeatureElement.setAttribute("dict", IOUtils.normalizeLexiconName(new File(predicateContextFile).getName()));
            generators.addContent(predicateContextFeatureElement);
            System.err.println("-> Predicate Context Generator added!");
        }
        aggGenerators.addContent(cached);
        cached.addContent(generators);
        XMLOutputter xmlOutput = new XMLOutputter();
        Format format = Format.getPrettyFormat();
        xmlOutput.setFormat(format);
        return xmlOutput.outputString(doc);
    }

    public static void setWindow(TrainingParameters params) {
        if (leftWindow == -1 || rightWindow == -1) {
            leftWindow = XMLFeatureDescriptor.getWindowRange(params).get(0);
            rightWindow = XMLFeatureDescriptor.getWindowRange(params).get(1);
        }
    }

    private static List<Integer> getWindowRange(TrainingParameters params) {
        ArrayList<Integer> windowRange = new ArrayList<Integer>();
        String windowParam = Flags.getWindow(params);
        String[] windowArray = windowParam.split("[ :-]");
        if (windowArray.length == 2) {
            windowRange.add(Integer.parseInt(windowArray[0]));
            windowRange.add(Integer.parseInt(windowArray[1]));
        }
        return windowRange;
    }
}

