/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.ml.parse;

import eus.ixa.ixa.pipe.ml.parse.AncoraHeadRules;
import eus.ixa.ixa.pipe.ml.parse.HeadRules;
import eus.ixa.ixa.pipe.ml.parse.PennTreebankHeadRules;
import eus.ixa.ixa.pipe.ml.sequence.SequenceLabelerModel;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import opennlp.tools.ml.model.AbstractModel;
import opennlp.tools.ml.model.MaxentModel;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.model.ArtifactSerializer;
import opennlp.tools.util.model.BaseModel;
import opennlp.tools.util.model.UncloseableInputStream;

public class ParserModel
extends BaseModel {
    private static final String COMPONENT_NAME = "shiftReducedParser";
    private static final String BUILD_MODEL_ENTRY_NAME = "build.model";
    private static final String CHECK_MODEL_ENTRY_NAME = "check.model";
    private static final String PARSER_TAGGER_MODEL_ENTRY_NAME = "parsertager.postagger";
    private static final String CHUNKER_TAGGER_MODEL_ENTRY_NAME = "parserchunker.chunker";
    private static final String HEAD_RULES_MODEL_ENTRY_NAME = "head-rules.headrules";

    public ParserModel(String languageCode, MaxentModel buildModel, MaxentModel checkModel, SequenceLabelerModel parserTagger, SequenceLabelerModel chunkerTagger, int beamSize, HeadRules headRules, Map<String, String> manifestInfoEntries) {
        super(COMPONENT_NAME, languageCode, manifestInfoEntries);
        Properties manifest = (Properties)this.artifactMap.get("manifest.properties");
        manifest.put("BeamSize", Integer.toString(beamSize));
        this.artifactMap.put(BUILD_MODEL_ENTRY_NAME, buildModel);
        this.artifactMap.put(CHECK_MODEL_ENTRY_NAME, checkModel);
        this.artifactMap.put(PARSER_TAGGER_MODEL_ENTRY_NAME, parserTagger);
        this.artifactMap.put(CHUNKER_TAGGER_MODEL_ENTRY_NAME, chunkerTagger);
        this.artifactMap.put(HEAD_RULES_MODEL_ENTRY_NAME, headRules);
        this.checkArtifactMap();
    }

    public ParserModel(String languageCode, MaxentModel buildModel, MaxentModel checkModel, SequenceLabelerModel parserTagger, SequenceLabelerModel chunkerTagger, int beamSize, HeadRules headRules) {
        this(languageCode, buildModel, checkModel, parserTagger, chunkerTagger, beamSize, headRules, null);
    }

    public ParserModel(InputStream in) throws IOException, InvalidFormatException {
        super(COMPONENT_NAME, in);
    }

    public ParserModel(File modelFile) throws IOException, InvalidFormatException {
        super(COMPONENT_NAME, modelFile);
    }

    public ParserModel(URL modelURL) throws IOException, InvalidFormatException {
        super(COMPONENT_NAME, modelURL);
    }

    @Override
    protected void createArtifactSerializers(Map<String, ArtifactSerializer> serializers) {
        super.createArtifactSerializers(serializers);
        if (this.getLanguage().equalsIgnoreCase("es")) {
            serializers.put("headrules", new AncoraHeadRules.AncoraHeadRulesSerializer());
        } else {
            serializers.put("headrules", new PennTreebankHeadRules.PennTreebankHeadRulesSerializer());
        }
        serializers.put("postagger", new SequenceLabelerModelSerializer());
        serializers.put("chunker", new SequenceLabelerModelSerializer());
    }

    public MaxentModel getBuildModel() {
        return (MaxentModel)this.artifactMap.get(BUILD_MODEL_ENTRY_NAME);
    }

    public MaxentModel getCheckModel() {
        return (MaxentModel)this.artifactMap.get(CHECK_MODEL_ENTRY_NAME);
    }

    public SequenceLabelerModel getParserTaggerModel() {
        return (SequenceLabelerModel)this.artifactMap.get(PARSER_TAGGER_MODEL_ENTRY_NAME);
    }

    public SequenceLabelerModel getParserChunkerModel() {
        return (SequenceLabelerModel)this.artifactMap.get(CHUNKER_TAGGER_MODEL_ENTRY_NAME);
    }

    public HeadRules getHeadRules() {
        return (HeadRules)this.artifactMap.get(HEAD_RULES_MODEL_ENTRY_NAME);
    }

    public int getBeamSize() {
        Properties manifest = (Properties)this.artifactMap.get("manifest.properties");
        String beamSizeString = manifest.getProperty("BeamSize");
        int beamSize = 20;
        if (beamSizeString != null) {
            beamSize = Integer.parseInt(beamSizeString);
        }
        return beamSize;
    }

    public ParserModel updateBuildModel(MaxentModel buildModel) {
        return new ParserModel(this.getLanguage(), buildModel, this.getCheckModel(), this.getParserTaggerModel(), this.getParserChunkerModel(), this.getBeamSize(), this.getHeadRules());
    }

    public ParserModel updateCheckModel(MaxentModel checkModel) {
        return new ParserModel(this.getLanguage(), this.getBuildModel(), checkModel, this.getParserTaggerModel(), this.getParserChunkerModel(), this.getBeamSize(), this.getHeadRules());
    }

    public ParserModel updateTaggerModel(SequenceLabelerModel taggerModel) {
        return new ParserModel(this.getLanguage(), this.getBuildModel(), this.getCheckModel(), taggerModel, this.getParserChunkerModel(), this.getBeamSize(), this.getHeadRules());
    }

    public ParserModel updateChunkerModel(SequenceLabelerModel chunkModel) {
        return new ParserModel(this.getLanguage(), this.getBuildModel(), this.getCheckModel(), this.getParserTaggerModel(), chunkModel, this.getBeamSize(), this.getHeadRules());
    }

    @Override
    protected void validateArtifactMap() throws InvalidFormatException {
        super.validateArtifactMap();
        if (!(this.artifactMap.get(BUILD_MODEL_ENTRY_NAME) instanceof AbstractModel)) {
            throw new InvalidFormatException("Missing the build model!");
        }
        if (!(this.artifactMap.get(CHECK_MODEL_ENTRY_NAME) instanceof AbstractModel)) {
            throw new InvalidFormatException("Missing the check model!");
        }
        if (!(this.artifactMap.get(PARSER_TAGGER_MODEL_ENTRY_NAME) instanceof SequenceLabelerModel)) {
            throw new InvalidFormatException("Missing the tagger model!");
        }
        if (!(this.artifactMap.get(CHUNKER_TAGGER_MODEL_ENTRY_NAME) instanceof SequenceLabelerModel)) {
            throw new InvalidFormatException("Missing the chunker model!");
        }
        if (!(this.artifactMap.get(HEAD_RULES_MODEL_ENTRY_NAME) instanceof HeadRules)) {
            throw new InvalidFormatException("Missing the head rules!");
        }
    }

    private static class SequenceLabelerModelSerializer
    implements ArtifactSerializer<SequenceLabelerModel> {
        private SequenceLabelerModelSerializer() {
        }

        @Override
        public SequenceLabelerModel create(InputStream in) throws IOException, InvalidFormatException {
            SequenceLabelerModel posModel = new SequenceLabelerModel(new UncloseableInputStream(in));
            return posModel;
        }

        @Override
        public void serialize(SequenceLabelerModel artifact, OutputStream out) throws IOException {
            artifact.serialize(out);
        }
    }
}

