/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.ml.resources;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.model.ArtifactSerializer;
import opennlp.tools.util.model.SerializableArtifact;

public class WordCluster
implements SerializableArtifact {
    private static final char spaceDelimiter = ' ';
    private Map<String, String> tokenToClusterMap = new HashMap<String, String>();

    public WordCluster(InputStream in) throws IOException {
        String line;
        BufferedReader breader = new BufferedReader(new InputStreamReader((InputStream)new BufferedInputStream(in), Charset.forName("UTF-8")));
        while ((line = breader.readLine()) != null) {
            int index = line.indexOf(32);
            String token = line.substring(0, index);
            String tokenClass = line.substring(index + 1).intern();
            this.tokenToClusterMap.put(token, tokenClass);
        }
    }

    public String lookupToken(String string) {
        return this.tokenToClusterMap.get(string);
    }

    public Map<String, String> getMap() {
        return this.tokenToClusterMap;
    }

    public void serialize(OutputStream out) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, "UTF-8"));
        for (Map.Entry<String, String> entry : this.tokenToClusterMap.entrySet()) {
            writer.write(entry.getKey() + ' ' + entry.getValue() + "\n");
        }
        ((Writer)writer).flush();
    }

    @Override
    public Class<?> getArtifactSerializerClass() {
        return WordClusterSerializer.class;
    }

    public static class WordClusterSerializer
    implements ArtifactSerializer<WordCluster> {
        @Override
        public WordCluster create(InputStream in) throws IOException, InvalidFormatException {
            return new WordCluster(in);
        }

        @Override
        public void serialize(WordCluster artifact, OutputStream out) throws IOException {
            artifact.serialize(out);
        }
    }
}

