/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.ml.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import opennlp.tools.util.TrainingParameters;

public class Flags {
    public static final boolean DEBUG = false;
    public static final String DEFAULT_FEATURE_FLAG = "no";
    public static final String DEFAULT_WINDOW = "2:2";
    public static final String DEFAULT_TOKEN_RANGE = "lower";
    public static final String DEFAULT_TOKENCLASS_RANGE = "lower,wac";
    public static final String DEFAULT_SENTENCE_BEGIN = "true";
    public static final String DEFAULT_SENTENCE_END = "false";
    public static final String DEFAULT_PREFIX_BEGIN = "3";
    public static final String DEFAULT_PREFIX_END = "4";
    public static final String DEFAULT_SUFFIX_BEGIN = "0";
    public static final String DEFAULT_SUFFIX_END = "4";
    public static final String CHAR_NGRAM_RANGE = "2:5";
    public static final String DEFAULT_POSTAG_RANGE = "pos,posclass";
    public static final String DEFAULT_MFS_RANGE = "pos,posclass,lemma,mfs,no";
    public static final String DEFAULT_SUPERSENSE_RANGE = "mfs,monosemic";
    public static final int DEFAULT_BEAM_SIZE = 3;
    public static final int DEFAULT_FOLDS_VALUE = 10;
    public static final String DEFAULT_EVALUATE_MODEL = "off";
    public static final String DEFAULT_SEQUENCE_TYPES = "off";
    public static final String DEFAULT_LEXER = "off";
    public static final int DEFAULT_DICT_CUTOFF = -1;
    public static final String DEFAULT_DICT_OPTION = "off";
    public static final String DEFAULT_DICT_PATH = "off";
    public static final String DEFAULT_OUTPUT_FORMAT = "naf";
    public static final String DEFAULT_SEQUENCE_CODEC = "BILOU";
    public static final String DEFAULT_EVAL_FORMAT = "conll02";
    public static final String DEFAULT_TASK = "ner";
    public static final String DEFAULT_HOSTNAME = "localhost";

    private Flags() {
    }

    public static String getComponent(TrainingParameters params) {
        String component = null;
        if (params.getSettings().get("Component") == null) {
            Flags.componentException();
        } else {
            component = params.getSettings().get("Component");
        }
        return component;
    }

    public static String getLanguage(TrainingParameters params) {
        String lang = null;
        if (params.getSettings().get("Language") == null) {
            Flags.langException();
        } else {
            lang = params.getSettings().get("Language");
        }
        return lang;
    }

    public static String getDataSet(String dataset, TrainingParameters params) {
        String trainSet = null;
        if (params.getSettings().get(dataset) == null) {
            Flags.datasetException();
        } else {
            trainSet = params.getSettings().get(dataset);
        }
        return trainSet;
    }

    public static String getModel(TrainingParameters params) {
        String model = null;
        if (params.getSettings().get("OutputModel") == null) {
            Flags.modelException();
        } else if (params.getSettings().get("OutputModel") != null && params.getSettings().get("OutputModel").length() == 0) {
            Flags.modelException();
        } else {
            model = params.getSettings().get("OutputModel");
        }
        return model;
    }

    public static String getCorpusFormat(TrainingParameters params) {
        String corpusFormat = null;
        if (params.getSettings().get("CorpusFormat") == null) {
            Flags.corpusFormatException();
        } else {
            corpusFormat = params.getSettings().get("CorpusFormat");
        }
        return corpusFormat;
    }

    public static String getOutputFormat(TrainingParameters params) {
        String outFormatOption = null;
        outFormatOption = params.getSettings().get("OutputFormat") != null ? params.getSettings().get("OutputFormat") : DEFAULT_OUTPUT_FORMAT;
        return outFormatOption;
    }

    public static Integer getBeamsize(TrainingParameters params) {
        Integer beamsize = null;
        beamsize = params.getSettings().get("BeamSize") == null ? Integer.valueOf(3) : Integer.valueOf(Integer.parseInt(params.getSettings().get("BeamSize")));
        return beamsize;
    }

    public static Integer getFolds(TrainingParameters params) {
        Integer beamsize = null;
        beamsize = params.getSettings().get("Folds") == null ? Integer.valueOf(10) : Integer.valueOf(Integer.parseInt(params.getSettings().get("Folds")));
        return beamsize;
    }

    public static String getSequenceCodec(TrainingParameters params) {
        String seqCodec = null;
        seqCodec = params.getSettings().get("SequenceCodec") == null ? DEFAULT_SEQUENCE_CODEC : params.getSettings().get("SequenceCodec");
        return seqCodec;
    }

    public static String getClearTrainingFeatures(TrainingParameters params) {
        String clearFeatures = null;
        clearFeatures = params.getSettings().get("ClearTrainingFeatures") == null ? DEFAULT_FEATURE_FLAG : params.getSettings().get("ClearTrainingFeatures");
        return clearFeatures;
    }

    public static String getClearEvaluationFeatures(TrainingParameters params) {
        String clearFeatures = null;
        clearFeatures = params.getSettings().get("ClearEvaluationFeatures") == null ? DEFAULT_FEATURE_FLAG : params.getSettings().get("ClearEvaluationFeatures");
        return clearFeatures;
    }

    public static String getWindow(TrainingParameters params) {
        String windowFlag = null;
        windowFlag = params.getSettings().get("Window") == null ? DEFAULT_WINDOW : params.getSettings().get("Window");
        return windowFlag;
    }

    public static String getTokenFeatures(TrainingParameters params) {
        String tokenFlag = null;
        tokenFlag = params.getSettings().get("TokenFeatures") != null ? params.getSettings().get("TokenFeatures") : DEFAULT_FEATURE_FLAG;
        return tokenFlag;
    }

    public static String getTokenFeaturesRange(TrainingParameters params) {
        String tokenRangeFlag = null;
        tokenRangeFlag = params.getSettings().get("TokenFeaturesRange") != null ? params.getSettings().get("TokenFeaturesRange") : DEFAULT_TOKEN_RANGE;
        return tokenRangeFlag;
    }

    public static String getTokenClassFeatures(TrainingParameters params) {
        String tokenClassFlag = null;
        tokenClassFlag = params.getSettings().get("TokenClassFeatures") != null ? params.getSettings().get("TokenClassFeatures") : DEFAULT_FEATURE_FLAG;
        return tokenClassFlag;
    }

    public static String getTokenClassFeaturesRange(TrainingParameters params) {
        String tokenRangeFlag = null;
        tokenRangeFlag = params.getSettings().get("TokenClassFeaturesRange") != null ? params.getSettings().get("TokenClassFeaturesRange") : DEFAULT_TOKENCLASS_RANGE;
        return tokenRangeFlag;
    }

    public static String[] processTokenClassFeaturesRange(String mfsFlag) {
        String[] mfsFlagArray = mfsFlag.split(",");
        if (mfsFlagArray.length != 2) {
            System.err.println("TokenClassFeaturesRange requires two fields but got " + mfsFlagArray.length);
            System.exit(1);
        }
        return mfsFlagArray;
    }

    public static String getWordShapeSuperSenseFeatures(TrainingParameters params) {
        String tokenClassFlag = null;
        tokenClassFlag = params.getSettings().get("WordShapeSuperSenseFeatures") != null ? params.getSettings().get("WordShapeSuperSenseFeatures") : DEFAULT_FEATURE_FLAG;
        return tokenClassFlag;
    }

    public static String getOutcomePriorFeatures(TrainingParameters params) {
        String outcomePriorFlag = null;
        outcomePriorFlag = params.getSettings().get("OutcomePriorFeatures") != null ? params.getSettings().get("OutcomePriorFeatures") : DEFAULT_FEATURE_FLAG;
        return outcomePriorFlag;
    }

    public static String getPreviousMapFeatures(TrainingParameters params) {
        String previousMapFlag = null;
        previousMapFlag = params.getSettings().get("PreviousMapFeatures") != null ? params.getSettings().get("PreviousMapFeatures") : DEFAULT_FEATURE_FLAG;
        return previousMapFlag;
    }

    public static String getSentenceFeatures(TrainingParameters params) {
        String sentenceFlag = null;
        sentenceFlag = params.getSettings().get("SentenceFeatures") != null ? params.getSettings().get("SentenceFeatures") : DEFAULT_FEATURE_FLAG;
        return sentenceFlag;
    }

    public static String getSentenceFeaturesBegin(TrainingParameters params) {
        String beginFlag = null;
        beginFlag = params.getSettings().get("SentenceFeaturesBegin") != null ? params.getSettings().get("SentenceFeaturesBegin") : DEFAULT_SENTENCE_BEGIN;
        return beginFlag;
    }

    public static String getSentenceFeaturesEnd(TrainingParameters params) {
        String endFlag = null;
        endFlag = params.getSettings().get("SentenceFeaturesEnd") != null ? params.getSettings().get("SentenceFeaturesEnd") : DEFAULT_SENTENCE_END;
        return endFlag;
    }

    public static String getPreffixFeatures(TrainingParameters params) {
        String prefixFlag = null;
        prefixFlag = params.getSettings().get("PrefixFeatures") != null ? params.getSettings().get("PrefixFeatures") : DEFAULT_FEATURE_FLAG;
        return prefixFlag;
    }

    public static String getPrefixFeaturesBegin(TrainingParameters params) {
        String beginFlag = null;
        beginFlag = params.getSettings().get("PrefixFeaturesBegin") != null ? params.getSettings().get("PrefixFeaturesBegin") : DEFAULT_PREFIX_BEGIN;
        return beginFlag;
    }

    public static String getPrefixFeaturesEnd(TrainingParameters params) {
        String endFlag = null;
        endFlag = params.getSettings().get("PrefixFeaturesEnd") != null ? params.getSettings().get("PrefixFeaturesEnd") : "4";
        return endFlag;
    }

    public static String getSuffixFeatures(TrainingParameters params) {
        String suffixFlag = null;
        suffixFlag = params.getSettings().get("SuffixFeatures") != null ? params.getSettings().get("SuffixFeatures") : DEFAULT_FEATURE_FLAG;
        return suffixFlag;
    }

    public static String getSuffixFeaturesBegin(TrainingParameters params) {
        String beginFlag = null;
        beginFlag = params.getSettings().get("SuffixFeaturesBegin") != null ? params.getSettings().get("SuffixFeaturesBegin") : DEFAULT_SUFFIX_BEGIN;
        return beginFlag;
    }

    public static String getSuffixFeaturesEnd(TrainingParameters params) {
        String endFlag = null;
        endFlag = params.getSettings().get("SuffixFeaturesEnd") != null ? params.getSettings().get("SuffixFeaturesEnd") : "4";
        return endFlag;
    }

    public static String getBigramClassFeatures(TrainingParameters params) {
        String bigramClassFlag = null;
        bigramClassFlag = params.getSettings().get("BigramClassFeatures") != null ? params.getSettings().get("BigramClassFeatures") : DEFAULT_FEATURE_FLAG;
        return bigramClassFlag;
    }

    public static String getTrigramClassFeatures(TrainingParameters params) {
        String trigramClassFlag = null;
        trigramClassFlag = params.getSettings().get("TrigramClassFeatures") != null ? params.getSettings().get("TrigramClassFeatures") : DEFAULT_FEATURE_FLAG;
        return trigramClassFlag;
    }

    public static String getFourgramClassFeatures(TrainingParameters params) {
        String fourgramClassFlag = null;
        fourgramClassFlag = params.getSettings().get("FourgramClassFeatures") != null ? params.getSettings().get("FourgramClassFeatures") : DEFAULT_FEATURE_FLAG;
        return fourgramClassFlag;
    }

    public static String getFivegramClassFeatures(TrainingParameters params) {
        String fivegramClassFlag = null;
        fivegramClassFlag = params.getSettings().get("FivegramClassFeatures") != null ? params.getSettings().get("FivegramClassFeatures") : DEFAULT_FEATURE_FLAG;
        return fivegramClassFlag;
    }

    public static String getCharNgramFeatures(TrainingParameters params) {
        String charNgramFlag = null;
        charNgramFlag = params.getSettings().get("CharNgramFeatures") != null ? params.getSettings().get("CharNgramFeatures") : DEFAULT_FEATURE_FLAG;
        return charNgramFlag;
    }

    public static String getCharNgramFeaturesRange(TrainingParameters params) {
        String charNgramRangeFlag = null;
        charNgramRangeFlag = params.getSettings().get("CharNgramFeaturesRange") != null ? params.getSettings().get("CharNgramFeaturesRange") : CHAR_NGRAM_RANGE;
        return charNgramRangeFlag;
    }

    public static String[] processNgramRange(String charngramRangeFlag) {
        String[] charngramArray = charngramRangeFlag.split("[ :-]");
        if (charngramArray.length != 2) {
            System.err.println("CharNgramFeaturesRange requires two fieds but got " + charngramArray.length);
            System.exit(1);
        }
        return charngramArray;
    }

    public static String getDictionaryFeatures(TrainingParameters params) {
        String dictionaryFlag = null;
        dictionaryFlag = params.getSettings().get("DictionaryFeatures") != null ? params.getSettings().get("DictionaryFeatures") : DEFAULT_FEATURE_FLAG;
        return dictionaryFlag;
    }

    public static String getClarkFeatures(TrainingParameters params) {
        String distSimFlag = null;
        distSimFlag = params.getSettings().get("ClarkClusterFeatures") != null ? params.getSettings().get("ClarkClusterFeatures") : DEFAULT_FEATURE_FLAG;
        return distSimFlag;
    }

    public static String getWord2VecClusterFeatures(TrainingParameters params) {
        String word2vecFlag = null;
        word2vecFlag = params.getSettings().get("Word2VecClusterFeatures") != null ? params.getSettings().get("Word2VecClusterFeatures") : DEFAULT_FEATURE_FLAG;
        return word2vecFlag;
    }

    public static String getBrownFeatures(TrainingParameters params) {
        String brownFlag = null;
        brownFlag = params.getSettings().get("BrownClusterFeatures") != null ? params.getSettings().get("BrownClusterFeatures") : DEFAULT_FEATURE_FLAG;
        return brownFlag;
    }

    public static String getPOSDictionaryFeatures(TrainingParameters params) {
        String dictionaryFlag = null;
        dictionaryFlag = params.getSettings().get("POSDictionaryFeatures") != null ? params.getSettings().get("POSDictionaryFeatures") : DEFAULT_FEATURE_FLAG;
        return dictionaryFlag;
    }

    public static String getPOSTagModelFeatures(TrainingParameters params) {
        String morphoFlag = null;
        morphoFlag = params.getSettings().get("POSTagModelFeatures") != null ? params.getSettings().get("POSTagModelFeatures") : DEFAULT_FEATURE_FLAG;
        return morphoFlag;
    }

    public static String getPOSTagModelFeaturesRange(TrainingParameters params) {
        String lemmaRangeFlag = null;
        lemmaRangeFlag = params.getSettings().get("POSTagModelFeaturesRange") != null ? params.getSettings().get("POSTagModelFeaturesRange") : DEFAULT_POSTAG_RANGE;
        return lemmaRangeFlag;
    }

    public static String[] processPOSTagModelFeaturesRange(String mfsFlag) {
        String[] mfsFlagArray = mfsFlag.split(",");
        if (mfsFlagArray.length != 2) {
            System.err.println("POSTagFeaturesRange requires two fields but got " + mfsFlagArray.length);
            System.exit(1);
        }
        return mfsFlagArray;
    }

    public static String getLemmaModelFeatures(TrainingParameters params) {
        String morphoFlag = null;
        morphoFlag = params.getSettings().get("LemmaModelFeatures") != null ? params.getSettings().get("LemmaModelFeatures") : DEFAULT_FEATURE_FLAG;
        return morphoFlag;
    }

    public static String getLemmaDictionaryFeatures(TrainingParameters params) {
        String morphoFlag = null;
        morphoFlag = params.getSettings().get("LemmaDictionaryFeatures") != null ? params.getSettings().get("LemmaDictionaryFeatures") : DEFAULT_FEATURE_FLAG;
        return morphoFlag;
    }

    public static String[] getLemmaDictionaryResources(String mfsFlag) {
        String[] mfsFlagArray = mfsFlag.split(",");
        if (mfsFlagArray.length != 2) {
            System.err.println("LemmaDictionary resources requires two fields but got " + mfsFlagArray.length);
            System.exit(1);
        }
        return mfsFlagArray;
    }

    public static String getSuperSenseFeatures(TrainingParameters params) {
        String mfsFlag = null;
        mfsFlag = params.getSettings().get("SuperSenseFeatures") != null ? params.getSettings().get("SuperSenseFeatures") : DEFAULT_FEATURE_FLAG;
        return mfsFlag;
    }

    public static String getPOSBaselineFeatures(TrainingParameters params) {
        String posFlag = null;
        posFlag = params.getSettings().get("POSBaselineFeatures") != null ? params.getSettings().get("POSBaselineFeatures") : DEFAULT_FEATURE_FLAG;
        return posFlag;
    }

    public static String getPrefixBegin(TrainingParameters params) {
        String beginFlag = null;
        beginFlag = params.getSettings().get("PrefixBegin") != null ? params.getSettings().get("PrefixBegin") : DEFAULT_PREFIX_BEGIN;
        return beginFlag;
    }

    public static String getPrefixEnd(TrainingParameters params) {
        String endFlag = null;
        endFlag = params.getSettings().get("PrefixEnd") != null ? params.getSettings().get("PrefixEnd") : "4";
        return endFlag;
    }

    public static String getSuffixBegin(TrainingParameters params) {
        String beginFlag = null;
        beginFlag = params.getSettings().get("SuffixBegin") != null ? params.getSettings().get("SuffixBegin") : DEFAULT_SUFFIX_BEGIN;
        return beginFlag;
    }

    public static String getSuffixEnd(TrainingParameters params) {
        String endFlag = null;
        endFlag = params.getSettings().get("SuffixEnd") != null ? params.getSettings().get("SuffixEnd") : "4";
        return endFlag;
    }

    public static String getMFSFeatures(TrainingParameters params) {
        String mfsFlag = null;
        mfsFlag = params.getSettings().get("MFSFeatures") != null ? params.getSettings().get("MFSFeatures") : DEFAULT_FEATURE_FLAG;
        return mfsFlag;
    }

    public static String getLemmaBaselineFeatures(TrainingParameters params) {
        String lemmaFlag = null;
        lemmaFlag = params.getSettings().get("LemmaBaselineFeatures") != null ? params.getSettings().get("LemmaBaselineFeatures") : DEFAULT_FEATURE_FLAG;
        return lemmaFlag;
    }

    public static String getLemmaBaselineFeaturesRange(TrainingParameters params) {
        String mfsRangeFlag = null;
        mfsRangeFlag = params.getSettings().get("LemmaBaselineFeaturesRange") != null ? params.getSettings().get("LemmaBaselineFeaturesRange") : DEFAULT_POSTAG_RANGE;
        return mfsRangeFlag;
    }

    public static String[] processLemmaBaselineFeaturesRange(String mfsFlag) {
        String[] mfsFlagArray = mfsFlag.split(",");
        if (mfsFlagArray.length != 2) {
            System.err.println("LemmaBaselineFeaturesRange requires two fields but got " + mfsFlagArray.length);
            System.exit(1);
        }
        return mfsFlagArray;
    }

    public static String getPredicateContextFeatures(TrainingParameters params) {
        String lemmaFlag = null;
        lemmaFlag = params.getSettings().get("PredicateContextFeatures") != null ? params.getSettings().get("PredicateContextFeatures") : DEFAULT_FEATURE_FLAG;
        return lemmaFlag;
    }

    public static String getChunkBaselineFeatures(TrainingParameters params) {
        String lemmaFlag = null;
        lemmaFlag = params.getSettings().get("ChunkBaselineFeatures") != null ? params.getSettings().get("ChunkBaselineFeatures") : DEFAULT_FEATURE_FLAG;
        return lemmaFlag;
    }

    public static String[] getSuperSenseResources(String mfsFlag) {
        String[] mfsFlagArray = mfsFlag.split(",");
        if (mfsFlagArray.length != 3) {
            System.err.println("SuperSense resources requires three fields but got " + mfsFlagArray.length);
            System.exit(1);
        }
        return mfsFlagArray;
    }

    public static String[] getMFSResources(String mfsFlag) {
        String[] mfsFlagArray = mfsFlag.split(",");
        if (mfsFlagArray.length != 3) {
            System.err.println("MFS resources requires three fields but got " + mfsFlagArray.length);
            System.exit(1);
        }
        return mfsFlagArray;
    }

    public static String getSuperSenseFeaturesRange(TrainingParameters params) {
        String mfsRangeFlag = null;
        mfsRangeFlag = params.getSettings().get("SuperSenseFeaturesRange") != null ? params.getSettings().get("SuperSenseFeaturesRange") : DEFAULT_SUPERSENSE_RANGE;
        return mfsRangeFlag;
    }

    public static String getMFSFeaturesRange(TrainingParameters params) {
        String mfsRangeFlag = null;
        mfsRangeFlag = params.getSettings().get("MFSFeaturesRange") != null ? params.getSettings().get("MFSFeaturesRange") : DEFAULT_SUPERSENSE_RANGE;
        return mfsRangeFlag;
    }

    public static String[] processSuperSenseFeaturesRange(String mfsFlag) {
        String[] mfsFlagArray = mfsFlag.split(",");
        if (mfsFlagArray.length != 2) {
            System.err.println("SuperSenseFeaturesRange requires two fields but got " + mfsFlagArray.length);
            System.exit(1);
        }
        return mfsFlagArray;
    }

    public static String[] processMFSFeaturesRange(String mfsFlag) {
        String[] mfsFlagArray = mfsFlag.split(",");
        if (mfsFlagArray.length != 5) {
            System.err.println("MFSFeaturesRange requires five fields but got " + mfsFlagArray.length);
            System.exit(1);
        }
        return mfsFlagArray;
    }

    public static List<File> getClusterLexiconFiles(String clusterPath) {
        String[] clusterPaths;
        ArrayList<File> clusterLexicons = new ArrayList<File>();
        for (String clusterName : clusterPaths = clusterPath.split(",")) {
            clusterLexicons.add(new File(clusterName));
        }
        return clusterLexicons;
    }

    public static String getHeadRulesFile(TrainingParameters params) {
        String headRulesFlag = null;
        if (params.getSettings().get("HeadRules") != null) {
            headRulesFlag = params.getSettings().get("HeadRules");
        } else {
            System.err.println("Specify head rules file to train the parser!!");
        }
        return headRulesFlag;
    }

    public static boolean isPredicateContextFeatures(TrainingParameters params) {
        String posFeatures = Flags.getPredicateContextFeatures(params);
        return !posFeatures.equalsIgnoreCase(DEFAULT_FEATURE_FLAG);
    }

    public static boolean isChunkBaselineFeatures(TrainingParameters params) {
        String posFeatures = Flags.getChunkBaselineFeatures(params);
        return !posFeatures.equalsIgnoreCase(DEFAULT_FEATURE_FLAG);
    }

    public static boolean isLemmaBaselineFeatures(TrainingParameters params) {
        String posFeatures = Flags.getLemmaBaselineFeatures(params);
        return !posFeatures.equalsIgnoreCase(DEFAULT_FEATURE_FLAG);
    }

    public static boolean isPOSBaselineFeatures(TrainingParameters params) {
        String posFeatures = Flags.getPOSBaselineFeatures(params);
        return !posFeatures.equalsIgnoreCase(DEFAULT_FEATURE_FLAG);
    }

    public static boolean isSuperSenseFeatures(TrainingParameters params) {
        String mfsFeatures = Flags.getSuperSenseFeatures(params);
        return !mfsFeatures.equalsIgnoreCase(DEFAULT_FEATURE_FLAG);
    }

    public static boolean isMFSFeatures(TrainingParameters params) {
        String mfsFeatures = Flags.getMFSFeatures(params);
        return !mfsFeatures.equalsIgnoreCase(DEFAULT_FEATURE_FLAG);
    }

    public static boolean isLemmaDictionaryFeatures(TrainingParameters params) {
        String morphoFeatures = Flags.getLemmaDictionaryFeatures(params);
        return !morphoFeatures.equalsIgnoreCase(DEFAULT_FEATURE_FLAG);
    }

    public static boolean isLemmaModelFeatures(TrainingParameters params) {
        String morphoFeatures = Flags.getLemmaModelFeatures(params);
        return !morphoFeatures.equalsIgnoreCase(DEFAULT_FEATURE_FLAG);
    }

    public static boolean isPOSDictionaryFeatures(TrainingParameters params) {
        String dictFeatures = Flags.getPOSDictionaryFeatures(params);
        return !dictFeatures.equalsIgnoreCase(DEFAULT_FEATURE_FLAG);
    }

    public static boolean isPOSTagModelFeatures(TrainingParameters params) {
        String morphoFeatures = Flags.getPOSTagModelFeatures(params);
        return !morphoFeatures.equalsIgnoreCase(DEFAULT_FEATURE_FLAG);
    }

    public static boolean isWord2VecClusterFeatures(TrainingParameters params) {
        String word2vecClusterFeatures = Flags.getWord2VecClusterFeatures(params);
        return !word2vecClusterFeatures.equalsIgnoreCase(DEFAULT_FEATURE_FLAG);
    }

    public static boolean isClarkFeatures(TrainingParameters params) {
        String clarkFeatures = Flags.getClarkFeatures(params);
        return !clarkFeatures.equalsIgnoreCase(DEFAULT_FEATURE_FLAG);
    }

    public static boolean isBrownFeatures(TrainingParameters params) {
        String brownFeatures = Flags.getBrownFeatures(params);
        return !brownFeatures.equalsIgnoreCase(DEFAULT_FEATURE_FLAG);
    }

    public static boolean isDictionaryFeatures(TrainingParameters params) {
        String dictFeatures = Flags.getDictionaryFeatures(params);
        return !dictFeatures.equalsIgnoreCase(DEFAULT_FEATURE_FLAG);
    }

    public static boolean isCharNgramClassFeature(TrainingParameters params) {
        String charngramParam = Flags.getCharNgramFeatures(params);
        return !charngramParam.equalsIgnoreCase(DEFAULT_FEATURE_FLAG);
    }

    public static boolean isFivegramClassFeature(TrainingParameters params) {
        String fivegramParam = Flags.getFivegramClassFeatures(params);
        return !fivegramParam.equalsIgnoreCase(DEFAULT_FEATURE_FLAG);
    }

    public static boolean isFourgramClassFeature(TrainingParameters params) {
        String fourgramParam = Flags.getFourgramClassFeatures(params);
        return !fourgramParam.equalsIgnoreCase(DEFAULT_FEATURE_FLAG);
    }

    public static boolean isTrigramClassFeature(TrainingParameters params) {
        String trigramParam = Flags.getTrigramClassFeatures(params);
        return !trigramParam.equalsIgnoreCase(DEFAULT_FEATURE_FLAG);
    }

    public static boolean isBigramClassFeature(TrainingParameters params) {
        String bigramParam = Flags.getBigramClassFeatures(params);
        return !bigramParam.equalsIgnoreCase(DEFAULT_FEATURE_FLAG);
    }

    public static boolean isSuffixFeature(TrainingParameters params) {
        String suffixParam = Flags.getSuffixFeatures(params);
        return !suffixParam.equalsIgnoreCase(DEFAULT_FEATURE_FLAG);
    }

    public static boolean isPrefixFeature(TrainingParameters params) {
        String prefixParam = Flags.getPreffixFeatures(params);
        return !prefixParam.equalsIgnoreCase(DEFAULT_FEATURE_FLAG);
    }

    public static boolean isSentenceFeature(TrainingParameters params) {
        String sentenceParam = Flags.getSentenceFeatures(params);
        return !sentenceParam.equalsIgnoreCase(DEFAULT_FEATURE_FLAG);
    }

    public static boolean isPreviousMapFeature(TrainingParameters params) {
        String previousMapParam = Flags.getPreviousMapFeatures(params);
        return !previousMapParam.equalsIgnoreCase(DEFAULT_FEATURE_FLAG);
    }

    public static boolean isOutcomePriorFeature(TrainingParameters params) {
        String outcomePriorParam = Flags.getOutcomePriorFeatures(params);
        return !outcomePriorParam.equalsIgnoreCase(DEFAULT_FEATURE_FLAG);
    }

    public static boolean isWordShapeSuperSenseFeature(TrainingParameters params) {
        String tokenParam = Flags.getWordShapeSuperSenseFeatures(params);
        return !tokenParam.equalsIgnoreCase(DEFAULT_FEATURE_FLAG);
    }

    public static boolean isTokenClassFeature(TrainingParameters params) {
        String tokenParam = Flags.getTokenClassFeatures(params);
        return !tokenParam.equalsIgnoreCase(DEFAULT_FEATURE_FLAG);
    }

    public static boolean isTokenFeature(TrainingParameters params) {
        String tokenParam = Flags.getTokenFeatures(params);
        return !tokenParam.equalsIgnoreCase(DEFAULT_FEATURE_FLAG);
    }

    public static void componentException() {
        System.err.println("Please provide a component name in the Component field in the parameters file!");
        System.exit(1);
    }

    public static void devSetException() {
        System.err.println("UseDevSet options in the parameters file if CrossEval is activated!");
        System.exit(1);
    }

    public static void modelException() {
        System.err.println("Please provide a model in the OutputModel field in the parameters file!");
        System.exit(1);
    }

    public static void langException() {
        System.err.println("Please fill in the Language field in the parameters file!");
        System.exit(1);
    }

    public static void datasetException() {
        System.err.println("Please specify your training/testing sets in the TrainSet and TestSet fields in the parameters file!");
        System.exit(1);
    }

    public static void corpusFormatException() {
        System.err.println("Please fill in CorpusFormat field in the parameters file!");
        System.exit(1);
    }

    public static void dictionaryException() {
        System.err.println("You need to set the --dictPath option to the dictionaries directory to use the dictTag option!");
        System.exit(1);
    }

    public static void dictionaryFeaturesException() {
        System.err.println("You need to specify the DictionaryFeatures in the parameters file to use the DictionaryPath!");
        System.exit(1);
    }
}

