/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.ml;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import eus.ixa.ixa.pipe.ml.sequence.SequenceLabel;
import eus.ixa.ixa.pipe.ml.sequence.SequenceLabelFactory;
import eus.ixa.ixa.pipe.ml.sequence.SequenceLabelerME;
import eus.ixa.ixa.pipe.ml.sequence.SequenceLabelerModel;
import eus.ixa.ixa.pipe.ml.utils.Span;
import eus.ixa.ixa.pipe.ml.utils.StringUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class StatisticalSequenceLabeler {
    private static ConcurrentHashMap<String, SequenceLabelerModel> seqModels = new ConcurrentHashMap();
    private SequenceLabelerME sequenceLabeler;
    private SequenceLabelFactory sequenceFactory;

    public StatisticalSequenceLabeler(Properties props) {
        String lang = props.getProperty("language");
        String model = props.getProperty("model");
        SequenceLabelerModel seqModel = this.loadModel(lang, model);
        this.sequenceLabeler = new SequenceLabelerME(seqModel);
    }

    public StatisticalSequenceLabeler(String model, String lang) {
        SequenceLabelerModel seqModel = this.loadModel(lang, model);
        this.sequenceLabeler = new SequenceLabelerME(seqModel);
    }

    public StatisticalSequenceLabeler(Properties props, SequenceLabelFactory aSeqFactory) {
        String lang = props.getProperty("language");
        String model = props.getProperty("model");
        this.sequenceFactory = aSeqFactory;
        SequenceLabelerModel seqModel = this.loadModel(lang, model);
        this.sequenceLabeler = new SequenceLabelerME(seqModel);
    }

    public StatisticalSequenceLabeler(String model, String lang, SequenceLabelFactory aSeqFactory) {
        this.sequenceFactory = aSeqFactory;
        SequenceLabelerModel seqModel = this.loadModel(lang, model);
        this.sequenceLabeler = new SequenceLabelerME(seqModel);
    }

    public final Span[] seqToSpans(String[] tokens) {
        Span[] annotatedText = this.sequenceLabeler.tag(tokens);
        ArrayList<Span> probSpans = new ArrayList<Span>(Arrays.asList(annotatedText));
        return probSpans.toArray(new Span[probSpans.size()]);
    }

    public final Span[] lemmatizeToSpans(String[] tokens) {
        Span[] seqSpans = this.sequenceLabeler.tag(tokens);
        StringUtils.decodeLemmasToSpans(tokens, seqSpans);
        return seqSpans;
    }

    public final String[] seqToStrings(String[] tokens) {
        String[] seqStrings = this.sequenceLabeler.tagToStrings(tokens);
        String[] decodedStringSequences = this.sequenceLabeler.decodeSequences(seqStrings);
        return decodedStringSequences;
    }

    public final List<SequenceLabel> getSequences(String[] tokens) {
        Span[] origSpans = this.sequenceLabeler.tag(tokens);
        Span[] seqSpans = SequenceLabelerME.dropOverlappingSpans(origSpans);
        List<SequenceLabel> sequences = this.getSequencesFromSpans(tokens, seqSpans);
        return sequences;
    }

    public final List<SequenceLabel> getLemmaSequences(String[] tokens) {
        Span[] origSpans = this.sequenceLabeler.tag(tokens);
        Span[] seqSpans = SequenceLabelerME.dropOverlappingSpans(origSpans);
        List<SequenceLabel> sequences = this.getLemmaSequencesFromSpans(tokens, seqSpans);
        return sequences;
    }

    public final List<SequenceLabel> getSequencesFromSpans(String[] tokens, Span[] seqSpans) {
        ArrayList<SequenceLabel> sequences = new ArrayList<SequenceLabel>();
        for (Span seqSpan : seqSpans) {
            String seqString = seqSpan.getCoveredText(tokens);
            String seqType = seqSpan.getType();
            SequenceLabel sequence = this.sequenceFactory.createSequence(seqString, seqType, seqSpan);
            sequences.add(sequence);
        }
        return sequences;
    }

    public final List<SequenceLabel> getLemmaSequencesFromSpans(String[] tokens, Span[] seqSpans) {
        ArrayList<SequenceLabel> sequences = new ArrayList<SequenceLabel>();
        for (Span seqSpan : seqSpans) {
            String seqString = seqSpan.getCoveredText(tokens);
            String decodedLemma = StringUtils.decodeShortestEditScript(seqString.toLowerCase(), seqSpan.getType());
            seqSpan.setType(decodedLemma);
            SequenceLabel sequence = this.sequenceFactory.createSequence(seqString, decodedLemma, seqSpan);
            sequences.add(sequence);
        }
        return sequences;
    }

    public final Span[][] getAllTags(String[] tokens) {
        Span[][] allPosTags = this.sequenceLabeler.tag(13, tokens);
        return allPosTags;
    }

    public ListMultimap<String, String> getMultipleLemmas(String[] tokens, Span[][] posTags) {
        ArrayListMultimap morphMap = ArrayListMultimap.create();
        for (int i = 0; i < posTags.length; ++i) {
            Span[] rowLemmas = this.sequenceLabeler.tag(tokens);
            String[] decodedLemmas = StringUtils.decodeLemmas(tokens, rowLemmas);
            for (int j = 0; j < decodedLemmas.length; ++j) {
                morphMap.put((Object)tokens[j], (Object)(posTags[i][j].getType() + "#" + decodedLemmas[j]));
            }
        }
        return morphMap;
    }

    public final void clearAdaptiveData() {
        this.sequenceLabeler.clearAdaptiveData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SequenceLabelerModel loadModel(String lang, String model) {
        long lStartTime = new Date().getTime();
        try {
            ConcurrentHashMap<String, SequenceLabelerModel> concurrentHashMap = seqModels;
            synchronized (concurrentHashMap) {
                if (!seqModels.containsKey(lang + model)) {
                    seqModels.put(lang + model, new SequenceLabelerModel(new FileInputStream(model)));
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        long lEndTime = new Date().getTime();
        long difference = lEndTime - lStartTime;
        System.err.println("IXA pipes Sequence model loaded in: " + difference + " miliseconds ... [DONE]");
        return seqModels.get(lang + model);
    }
}

