/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.ml.features;

import eus.ixa.ixa.pipe.ml.resources.SequenceModelResource;
import eus.ixa.ixa.pipe.ml.utils.Flags;
import eus.ixa.ixa.pipe.ml.utils.Span;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.featuregen.ArtifactToSerializerMapper;
import opennlp.tools.util.featuregen.CustomFeatureGenerator;
import opennlp.tools.util.featuregen.FeatureGeneratorResourceProvider;
import opennlp.tools.util.model.ArtifactSerializer;

public class LemmaBaselineContextGenerator
extends CustomFeatureGenerator
implements ArtifactToSerializerMapper {
    private Map<String, String> attributes;
    private SequenceModelResource posModelResource;
    private Span[] currentTags;
    private String[] currentSentence;
    private static Pattern hasCap = Pattern.compile("\\p{Upper}", 256);
    private static Pattern hasNum = Pattern.compile("\\p{Digit}", 256);
    private boolean isPos;
    private boolean isPosClass;

    private String[] getPrefixes(String lex) {
        Integer start = Integer.parseInt(this.attributes.get("prefBegin"));
        Integer end = Integer.parseInt(this.attributes.get("prefEnd"));
        String[] prefs = new String[end.intValue()];
        int ll = end;
        for (int li = start.intValue(); li < ll; ++li) {
            prefs[li] = lex.substring(0, Math.min(li + 1, lex.length()));
        }
        return prefs;
    }

    private String[] getSuffixes(String lex) {
        Integer start = Integer.parseInt(this.attributes.get("sufBegin"));
        Integer end = Integer.parseInt(this.attributes.get("sufEnd"));
        String[] suffs = new String[end.intValue()];
        int ll = end;
        for (int li = start.intValue(); li < ll; ++li) {
            suffs[li] = lex.substring(Math.max(lex.length() - li - 1, 0));
        }
        return suffs;
    }

    public void createFeatures(List<String> features, String[] tokens, int index, String[] previousOutcomes) {
        if (this.currentSentence != tokens) {
            this.currentSentence = tokens;
            this.currentTags = this.posModelResource.seqToSpans(tokens);
        }
        String posTag = this.currentTags[index].getType();
        String posTagClass = posTag.substring(0, 1);
        String p_1 = index < 1 ? "bos" : previousOutcomes[index - 1];
        String w0 = tokens[index];
        String w1 = index + 1 >= tokens.length ? "eos" : tokens[index + 1];
        features.add("p_1=" + p_1);
        features.add("w0=" + w0);
        features.add("w1=" + w1);
        this.addTokenShapeFeatures(features, w0);
        if (this.isPos) {
            features.add("t0=" + posTag);
        }
        if (this.isPosClass) {
            features.add("posTagClass=" + posTagClass);
            features.add("p_1,posTagClass=" + p_1 + "," + posTagClass);
        }
    }

    private void addTokenShapeFeatures(List<String> features, String lex) {
        String[] suffs = this.getSuffixes(lex);
        for (int i = 0; i < suffs.length; ++i) {
            features.add("suf=" + suffs[i]);
        }
        String[] prefs = this.getPrefixes(lex);
        for (int i = 0; i < prefs.length; ++i) {
            features.add("pre=" + prefs[i]);
        }
        if (lex.indexOf(45) != -1) {
            features.add("h");
        }
        if (hasCap.matcher(lex).find()) {
            features.add("c");
        }
        if (hasNum.matcher(lex).find()) {
            features.add("d");
        }
    }

    public void updateAdaptiveData(String[] tokens, String[] outcomes) {
    }

    public void clearAdaptiveData() {
    }

    public void init(Map<String, String> properties, FeatureGeneratorResourceProvider resourceProvider) throws InvalidFormatException {
        Object posResource = resourceProvider.getResource(properties.get("model"));
        if (!(posResource instanceof SequenceModelResource)) {
            throw new InvalidFormatException("Not a SequenceModelResource for key: " + properties.get("model"));
        }
        this.posModelResource = (SequenceModelResource)posResource;
        this.processRangeOptions(properties);
    }

    private void processRangeOptions(Map<String, String> properties) {
        String featuresRange = properties.get("range");
        String[] rangeArray = Flags.processLemmaBaselineFeaturesRange(featuresRange);
        if (rangeArray[0].equalsIgnoreCase("pos")) {
            this.isPos = true;
        }
        if (rangeArray[1].equalsIgnoreCase("posclass")) {
            this.isPosClass = true;
        }
        this.attributes = properties;
    }

    public Map<String, ArtifactSerializer<?>> getArtifactSerializerMapping() {
        HashMap<String, SequenceModelResource.SequenceModelResourceSerializer> mapping = new HashMap<String, SequenceModelResource.SequenceModelResourceSerializer>();
        mapping.put("seqmodelserializer", new SequenceModelResource.SequenceModelResourceSerializer());
        return Collections.unmodifiableMap(mapping);
    }
}

