/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.ml.features;

import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.featuregen.CustomFeatureGenerator;
import opennlp.tools.util.featuregen.FeatureGeneratorResourceProvider;

public class POSBaselineContextGenerator
extends CustomFeatureGenerator {
    private Map<String, String> attributes;
    private static Pattern hasCap = Pattern.compile("\\p{Upper}", 256);
    private static Pattern hasNum = Pattern.compile("\\p{Digit}", 256);

    private String[] getPrefixes(String lex) {
        Integer start = Integer.parseInt(this.attributes.get("prefBegin"));
        Integer end = Integer.parseInt(this.attributes.get("prefEnd"));
        String[] prefs = new String[end.intValue()];
        int ll = end;
        for (int li = start.intValue(); li < ll; ++li) {
            prefs[li] = lex.substring(0, Math.min(li + 1, lex.length()));
        }
        return prefs;
    }

    private String[] getSuffixes(String lex) {
        Integer start = Integer.parseInt(this.attributes.get("sufBegin"));
        Integer end = Integer.parseInt(this.attributes.get("sufEnd"));
        String[] suffs = new String[end.intValue()];
        int ll = end;
        for (int li = start.intValue(); li < ll; ++li) {
            suffs[li] = lex.substring(Math.max(lex.length() - li - 1, 0));
        }
        return suffs;
    }

    public void createFeatures(List<String> features, String[] tokens, int index, String[] previousOutcomes) {
        String p_1;
        String w_1;
        String p_2 = index < 2 ? "bos" : previousOutcomes[index - 2];
        if (index < 1) {
            w_1 = "bos";
            p_1 = "bos";
        } else {
            w_1 = tokens[index - 1];
            p_1 = previousOutcomes[index - 1];
        }
        String w0 = tokens[index];
        String w1 = index + 1 >= tokens.length ? "eos" : tokens[index + 1];
        features.add("w_1=" + w_1);
        features.add("w0=" + w0);
        features.add("w1=" + w1);
        features.add("w1,w0=" + w1 + "," + w0);
        features.add("w0,w1=" + w0 + "," + w1);
        features.add("p_1,p_2=" + p_1 + "," + p_2);
        this.addTokenShapeFeatures(features, w0);
    }

    private void addTokenShapeFeatures(List<String> features, String lex) {
        String[] suffs = this.getSuffixes(lex);
        for (int i = 0; i < suffs.length; ++i) {
            features.add("suf=" + suffs[i]);
        }
        String[] prefs = this.getPrefixes(lex);
        for (int i = 0; i < prefs.length; ++i) {
            features.add("pre=" + prefs[i]);
        }
        if (lex.indexOf(45) != -1) {
            features.add("h");
        }
        if (hasCap.matcher(lex).find()) {
            features.add("c");
        }
        if (hasNum.matcher(lex).find()) {
            features.add("d");
        }
    }

    public void updateAdaptiveData(String[] tokens, String[] outcomes) {
    }

    public void clearAdaptiveData() {
    }

    public void init(Map<String, String> properties, FeatureGeneratorResourceProvider resourceProvider) throws InvalidFormatException {
        this.attributes = properties;
    }
}

