/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.ml.features;

import eus.ixa.ixa.pipe.ml.resources.SequenceModelResource;
import eus.ixa.ixa.pipe.ml.utils.Flags;
import eus.ixa.ixa.pipe.ml.utils.Span;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.featuregen.ArtifactToSerializerMapper;
import opennlp.tools.util.featuregen.CustomFeatureGenerator;
import opennlp.tools.util.featuregen.FeatureGeneratorResourceProvider;
import opennlp.tools.util.model.ArtifactSerializer;

public class POSTagModelFeatureGenerator
extends CustomFeatureGenerator
implements ArtifactToSerializerMapper {
    private SequenceModelResource posModelResource;
    private String[] currentSentence;
    private Span[] currentTags;
    private boolean isPos;
    private boolean isPosClass;

    public void createFeatures(List<String> features, String[] tokens, int index, String[] previousOutcomes) {
        if (this.currentSentence != tokens) {
            this.currentSentence = tokens;
            this.currentTags = this.posModelResource.seqToSpans(tokens);
        }
        String posTag = this.currentTags[index].getType();
        if (this.isPos) {
            features.add("posTag=" + posTag);
        }
        if (this.isPosClass) {
            String posTagClass = posTag.substring(0, 1);
            features.add("posTagClass=" + posTagClass);
        }
    }

    public void updateAdaptiveData(String[] tokens, String[] outcomes) {
    }

    public void clearAdaptiveData() {
    }

    public void init(Map<String, String> properties, FeatureGeneratorResourceProvider resourceProvider) throws InvalidFormatException {
        Object posResource = resourceProvider.getResource(properties.get("model"));
        if (!(posResource instanceof SequenceModelResource)) {
            throw new InvalidFormatException("Not a SequenceModelResource for key: " + properties.get("model"));
        }
        this.posModelResource = (SequenceModelResource)posResource;
        this.processRangeOptions(properties);
    }

    private void processRangeOptions(Map<String, String> properties) {
        String featuresRange = properties.get("range");
        String[] rangeArray = Flags.processPOSTagModelFeaturesRange(featuresRange);
        if (rangeArray[0].equalsIgnoreCase("pos")) {
            this.isPos = true;
        }
        if (rangeArray[1].equalsIgnoreCase("posclass")) {
            this.isPosClass = true;
        }
    }

    public Map<String, ArtifactSerializer<?>> getArtifactSerializerMapping() {
        HashMap<String, SequenceModelResource.SequenceModelResourceSerializer> mapping = new HashMap<String, SequenceModelResource.SequenceModelResourceSerializer>();
        mapping.put("seqmodelserializer", new SequenceModelResource.SequenceModelResourceSerializer());
        return Collections.unmodifiableMap(mapping);
    }
}

