/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.ml.features;

import eus.ixa.ixa.pipe.ml.resources.WordCluster;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.featuregen.ArtifactToSerializerMapper;
import opennlp.tools.util.featuregen.CustomFeatureGenerator;
import opennlp.tools.util.featuregen.FeatureGeneratorResourceProvider;
import opennlp.tools.util.model.ArtifactSerializer;

public class Word2VecClusterFeatureGenerator
extends CustomFeatureGenerator
implements ArtifactToSerializerMapper {
    private WordCluster word2vecCluster;
    private static String unknownClass = "O";
    private Map<String, String> attributes;

    public void createFeatures(List<String> features, String[] tokens, int index, String[] previousOutcomes) {
        String wordClass = this.getWordClass(tokens[index].toLowerCase());
        features.add(this.attributes.get("dict") + "=" + wordClass);
    }

    private String getWordClass(String token) {
        String wordClass = this.word2vecCluster.lookupToken(token);
        if (wordClass == null) {
            wordClass = unknownClass;
        }
        return wordClass;
    }

    public void updateAdaptiveData(String[] tokens, String[] outcomes) {
    }

    public void clearAdaptiveData() {
    }

    public void init(Map<String, String> properties, FeatureGeneratorResourceProvider resourceProvider) throws InvalidFormatException {
        Object dictResource = resourceProvider.getResource(properties.get("dict"));
        if (!(dictResource instanceof WordCluster)) {
            throw new InvalidFormatException("Not a ClusterLexicon resource for key: " + properties.get("dict"));
        }
        this.word2vecCluster = (WordCluster)dictResource;
        this.attributes = properties;
    }

    public Map<String, ArtifactSerializer<?>> getArtifactSerializerMapping() {
        HashMap<String, WordCluster.WordClusterSerializer> mapping = new HashMap<String, WordCluster.WordClusterSerializer>();
        mapping.put("word2vecserializer", new WordCluster.WordClusterSerializer());
        return Collections.unmodifiableMap(mapping);
    }
}

