/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.ml.lemma;

import eus.ixa.ixa.pipe.ml.utils.Span;
import eus.ixa.ixa.pipe.ml.utils.StringUtils;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.model.ArtifactSerializer;
import opennlp.tools.util.model.SerializableArtifact;

public class DictionaryLemmatizer
implements SerializableArtifact {
    private static final char tabDelimiter = '\t';
    private final Map<List<String>, String> dictMap = new HashMap<List<String>, String>();
    String[] splitted = new String[64];

    public DictionaryLemmatizer(InputStream in) throws IOException {
        String line;
        BufferedReader breader = new BufferedReader(new InputStreamReader((InputStream)new BufferedInputStream(in), Charset.forName("UTF-8")));
        while ((line = breader.readLine()) != null) {
            StringUtils.splitLine(line, '\t', this.splitted);
            this.dictMap.put(Arrays.asList(this.splitted[0], this.splitted[2]), this.splitted[1]);
        }
    }

    public Map<List<String>, String> getDictMap() {
        return this.dictMap;
    }

    private List<String> getDictKeys(String word, String postag) {
        ArrayList<String> keys = new ArrayList<String>();
        keys.addAll(Arrays.asList(word.toLowerCase(), postag));
        return keys;
    }

    public List<String> lemmatize(String[] tokens, Span[] postags) {
        ArrayList<String> lemmas = new ArrayList<String>();
        for (int i = 0; i < tokens.length; ++i) {
            lemmas.add(this.apply(tokens[i], postags[i].getType()));
        }
        return lemmas;
    }

    public String apply(String word, String postag) {
        String lemma = null;
        List<String> keys = this.getDictKeys(word, postag);
        String keyValue = this.dictMap.get(keys);
        lemma = keyValue != null ? keyValue : "O";
        return lemma;
    }

    public void serialize(OutputStream out) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out));
        for (Map.Entry<List<String>, String> entry : this.dictMap.entrySet()) {
            writer.write(entry.getKey().get(0) + "\t" + entry.getValue() + "\t" + entry.getKey().get(1) + "\n");
        }
        ((Writer)writer).flush();
    }

    public Class<?> getArtifactSerializerClass() {
        return DictionaryLemmatizerSerializer.class;
    }

    public static class DictionaryLemmatizerSerializer
    implements ArtifactSerializer<DictionaryLemmatizer> {
        public DictionaryLemmatizer create(InputStream in) throws IOException, InvalidFormatException {
            return new DictionaryLemmatizer(in);
        }

        public void serialize(DictionaryLemmatizer artifact, OutputStream out) throws IOException {
            artifact.serialize(out);
        }
    }
}

