/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.ml.parse;

import eus.ixa.ixa.pipe.ml.parse.Parse;
import eus.ixa.ixa.pipe.ml.parse.ParserEvaluationMonitor;
import eus.ixa.ixa.pipe.ml.parse.ShiftReduceParser;
import eus.ixa.ixa.pipe.ml.utils.Span;
import java.util.ArrayList;
import java.util.Stack;
import opennlp.tools.util.eval.EvaluationMonitor;
import opennlp.tools.util.eval.Evaluator;
import opennlp.tools.util.eval.FMeasure;

public class ParserEvaluator
extends Evaluator<Parse> {
    private FMeasure fmeasure = new FMeasure();
    private final ShiftReduceParser parser;

    public ParserEvaluator(ShiftReduceParser aParser, ParserEvaluationMonitor ... monitors) {
        super((EvaluationMonitor[])monitors);
        this.parser = aParser;
    }

    private static Span[] getConstituencySpans(Parse parse) {
        Stack<Parse> stack = new Stack<Parse>();
        if (parse.getChildCount() > 0) {
            for (Parse child : parse.getChildren()) {
                stack.push(child);
            }
        }
        ArrayList<Span> consts = new ArrayList<Span>();
        while (!stack.isEmpty()) {
            Parse constSpan = (Parse)stack.pop();
            if (constSpan.isPosTag()) continue;
            Span span = constSpan.getSpan();
            consts.add(new Span(span.getStart(), span.getEnd(), constSpan.getType()));
            for (Parse child : constSpan.getChildren()) {
                stack.push(child);
            }
        }
        return consts.toArray(new Span[consts.size()]);
    }

    protected final Parse processSample(Parse reference) {
        String sentenceText = reference.getText();
        Parse[] predictions = ShiftReduceParser.parseLine(sentenceText, this.parser, 1);
        Parse prediction = null;
        if (predictions.length > 0) {
            prediction = predictions[0];
        }
        this.fmeasure.updateScores((Object[])ParserEvaluator.getConstituencySpans(reference), (Object[])ParserEvaluator.getConstituencySpans(prediction));
        return prediction;
    }

    public final FMeasure getFMeasure() {
        return this.fmeasure;
    }

    public static void main(String[] args) {
        String goldParseString = "(TOP (S (NP (NNS Sales) (NNS executives)) (VP (VBD were) (VP (VBG examing) (NP (DT the) (NNS figures)) (PP (IN with) (NP (JJ great) (NN care))) ))  (NP (NN yesterday)) (. .) ))";
        Object[] goldConsts = ParserEvaluator.getConstituencySpans(Parse.parseParse(goldParseString));
        String testParseString = "(TOP (S (NP (NNS Sales) (NNS executives)) (VP (VBD were) (VP (VBG examing) (NP (DT the) (NNS figures)) (PP (IN with) (NP (JJ great) (NN care) (NN yesterday))) ))  (. .) ))";
        Object[] testConsts = ParserEvaluator.getConstituencySpans(Parse.parseParse(testParseString));
        FMeasure measure = new FMeasure();
        measure.updateScores(goldConsts, testConsts);
        System.out.println(measure.toString());
    }
}

