/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.ml.pos;

public class TagSetMappingsToNAF {
    private TagSetMappingsToNAF() {
    }

    public static String setTermTypeNAF(String postag) {
        if (postag.startsWith("N") || postag.startsWith("V") || postag.startsWith("G") || postag.startsWith("A")) {
            return "open";
        }
        return "close";
    }

    public static String getNAFTagSet(String postag, String lang) {
        String tag = null;
        tag = lang.equalsIgnoreCase("de") ? TagSetMappingsToNAF.mapGermanCoNLL09TagSetToNAF(postag) : (lang.equalsIgnoreCase("en") ? TagSetMappingsToNAF.mapEnglishPennTagSetToNAF(postag) : (lang.equalsIgnoreCase("es") ? TagSetMappingsToNAF.mapSpanishAncoraTagSetToNAF(postag) : (lang.equalsIgnoreCase("eu") ? TagSetMappingsToNAF.mapUDTagSetToNAF(postag) : (lang.equalsIgnoreCase("gl") ? TagSetMappingsToNAF.mapGalicianCTAGTagSetToNAF(postag) : (lang.equalsIgnoreCase("fr") ? TagSetMappingsToNAF.mapFrenchCCTagSetToNAF(postag) : (lang.equalsIgnoreCase("it") ? TagSetMappingsToNAF.mapUDTagSetToNAF(postag) : (lang.equalsIgnoreCase("nl") ? TagSetMappingsToNAF.mapWotanTagSetToNAF(postag) : "O")))))));
        return tag;
    }

    private static String mapGermanCoNLL09TagSetToNAF(String postag) {
        if (postag.startsWith("ADV")) {
            return "A";
        }
        if (postag.startsWith("KO")) {
            return "C";
        }
        if (postag.equalsIgnoreCase("ART")) {
            return "D";
        }
        if (postag.startsWith("ADJ")) {
            return "G";
        }
        if (postag.equalsIgnoreCase("NN")) {
            return "N";
        }
        if (postag.startsWith("NE")) {
            return "R";
        }
        if (postag.startsWith("AP")) {
            return "P";
        }
        if (postag.startsWith("PD") || postag.startsWith("PI") || postag.startsWith("PP") || postag.startsWith("PR") || postag.startsWith("PW") || postag.startsWith("PA")) {
            return "Q";
        }
        if (postag.startsWith("V")) {
            return "V";
        }
        return "O";
    }

    private static String mapEnglishPennTagSetToNAF(String postag) {
        if (postag.startsWith("RB")) {
            return "A";
        }
        if (postag.equalsIgnoreCase("CC")) {
            return "C";
        }
        if (postag.startsWith("D") || postag.equalsIgnoreCase("PDT")) {
            return "D";
        }
        if (postag.startsWith("J")) {
            return "G";
        }
        if (postag.equalsIgnoreCase("NN") || postag.equalsIgnoreCase("NNS")) {
            return "N";
        }
        if (postag.startsWith("NNP")) {
            return "R";
        }
        if (postag.equalsIgnoreCase("TO") || postag.equalsIgnoreCase("IN")) {
            return "P";
        }
        if (postag.startsWith("PRP") || postag.startsWith("WP")) {
            return "Q";
        }
        if (postag.startsWith("V")) {
            return "V";
        }
        return "O";
    }

    private static String mapSpanishAncoraTagSetToNAF(String postag) {
        if (postag.equalsIgnoreCase("RG") || postag.equalsIgnoreCase("RN")) {
            return "A";
        }
        if (postag.equalsIgnoreCase("CC") || postag.equalsIgnoreCase("CS")) {
            return "C";
        }
        if (postag.startsWith("D")) {
            return "D";
        }
        if (postag.startsWith("A")) {
            return "G";
        }
        if (postag.startsWith("NC")) {
            return "N";
        }
        if (postag.startsWith("NP")) {
            return "R";
        }
        if (postag.startsWith("SP")) {
            return "P";
        }
        if (postag.startsWith("P")) {
            return "Q";
        }
        if (postag.startsWith("V")) {
            return "V";
        }
        return "O";
    }

    private static String mapUDTagSetToNAF(String postag) {
        if (postag.equalsIgnoreCase("ADV")) {
            return "A";
        }
        if (postag.equalsIgnoreCase("CONJ") || postag.equalsIgnoreCase("SCONJ")) {
            return "C";
        }
        if (postag.equalsIgnoreCase("DET")) {
            return "D";
        }
        if (postag.equalsIgnoreCase("ADJ")) {
            return "G";
        }
        if (postag.equalsIgnoreCase("NOUN")) {
            return "N";
        }
        if (postag.equalsIgnoreCase("PROPN")) {
            return "R";
        }
        if (postag.equalsIgnoreCase("ADP")) {
            return "P";
        }
        if (postag.equalsIgnoreCase("PRON")) {
            return "Q";
        }
        if (postag.startsWith("V")) {
            return "V";
        }
        return "O";
    }

    private static String mapFrenchCCTagSetToNAF(String postag) {
        if (postag.startsWith("ADV")) {
            return "A";
        }
        if (postag.equalsIgnoreCase("CC") || postag.equalsIgnoreCase("CS")) {
            return "C";
        }
        if (postag.startsWith("D") || postag.startsWith("I")) {
            return "D";
        }
        if (postag.startsWith("ADJ")) {
            return "G";
        }
        if (postag.startsWith("NC")) {
            return "N";
        }
        if (postag.startsWith("NPP")) {
            return "R";
        }
        if (postag.startsWith("PRO") || postag.startsWith("CL")) {
            return "Q";
        }
        if (postag.equalsIgnoreCase("P") || postag.equalsIgnoreCase("P+D") || postag.equalsIgnoreCase("P+PRO")) {
            return "P";
        }
        if (postag.startsWith("V")) {
            return "V";
        }
        return "O";
    }

    private static String mapGalicianCTAGTagSetToNAF(String postag) {
        if (postag.startsWith("R")) {
            return "A";
        }
        if (postag.equalsIgnoreCase("CC") || postag.equalsIgnoreCase("CS")) {
            return "C";
        }
        if (postag.startsWith("D") || postag.startsWith("G") || postag.startsWith("X") || postag.startsWith("Q") || postag.startsWith("T") || postag.startsWith("I") || postag.startsWith("M")) {
            return "D";
        }
        if (postag.startsWith("A")) {
            return "G";
        }
        if (postag.startsWith("NC")) {
            return "N";
        }
        if (postag.startsWith("NP")) {
            return "R";
        }
        if (postag.startsWith("S")) {
            return "P";
        }
        if (postag.startsWith("P")) {
            return "Q";
        }
        if (postag.startsWith("V")) {
            return "V";
        }
        return "O";
    }

    private static String mapWotanTagSetToNAF(String postag) {
        if (postag.equalsIgnoreCase("ADV")) {
            return "A";
        }
        if (postag.equalsIgnoreCase("CONJ") || postag.equalsIgnoreCase("SCONJ")) {
            return "C";
        }
        if (postag.equalsIgnoreCase("Art")) {
            return "D";
        }
        if (postag.equalsIgnoreCase("ADJ")) {
            return "G";
        }
        if (postag.equalsIgnoreCase("N")) {
            return "N";
        }
        if (postag.equalsIgnoreCase("PROPN")) {
            return "R";
        }
        if (postag.equalsIgnoreCase("Prep")) {
            return "P";
        }
        if (postag.equalsIgnoreCase("PRON")) {
            return "Q";
        }
        if (postag.startsWith("V")) {
            return "V";
        }
        return "O";
    }
}

