/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.ml.resources;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.TreeMultimap;
import eus.ixa.ixa.pipe.ml.utils.Span;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.model.ArtifactSerializer;
import opennlp.tools.util.model.SerializableArtifact;

public class MFSResource
implements SerializableArtifact {
    private static final char tabDelimiter = '\t';
    private ListMultimap<String, String> multiMap = ArrayListMultimap.create();

    public MFSResource(InputStream in) throws IOException {
        String line;
        BufferedReader breader = new BufferedReader(new InputStreamReader((InputStream)new BufferedInputStream(in), Charset.forName("UTF-8")));
        while ((line = breader.readLine()) != null) {
            int index = line.indexOf(9);
            String lemmaPos = line.substring(0, index);
            String freqSense = line.substring(index + 1).intern();
            this.multiMap.put((Object)lemmaPos, (Object)freqSense);
        }
    }

    public List<String> getFirstSenseBio(List<String> lemmas, Span[] posTags) {
        ArrayList<String> mostFrequentSenseList = new ArrayList<String>();
        String prefix = "-start";
        String mostFrequentSense = null;
        String searchSpan = null;
        for (int i = 0; i < lemmas.size(); ++i) {
            int j;
            mostFrequentSense = null;
            String pos = posTags[i].getType();
            for (j = lemmas.size() - 1; j >= i; --j) {
                String endPos = posTags[j].getType();
                searchSpan = this.createSpan(lemmas, i, j);
                String firstSpan = (searchSpan + "#" + pos.substring(0, 1)).toLowerCase();
                TreeMultimap<Integer, String> mfsMap = this.getOrderedMap(firstSpan);
                if (!mfsMap.isEmpty()) {
                    mostFrequentSense = this.getMFS(mfsMap);
                    break;
                }
                String lastSpan = (searchSpan + "#" + endPos.substring(0, 1)).toLowerCase();
                TreeMultimap<Integer, String> mfsMapEnd = this.getOrderedMap(lastSpan);
                if (mfsMapEnd.isEmpty()) continue;
                mostFrequentSense = this.getMFS(mfsMapEnd);
                break;
            }
            prefix = "-start";
            if (mostFrequentSense != null) {
                while (i < j) {
                    mostFrequentSenseList.add((mostFrequentSense + prefix).intern());
                    prefix = "-cont";
                    ++i;
                }
            }
            if (mostFrequentSense != null) {
                mostFrequentSenseList.add((mostFrequentSense + prefix).intern());
                continue;
            }
            mostFrequentSenseList.add("other");
        }
        return mostFrequentSenseList;
    }

    public List<String> getFirstSenseBilou(List<String> lemmas, Span[] posTags) {
        ArrayList<String> mostFrequentSenseList = new ArrayList<String>();
        String prefix = "-start";
        String mostFrequentSense = null;
        String searchSpan = null;
        for (int i = 0; i < lemmas.size(); ++i) {
            int j;
            mostFrequentSense = null;
            String pos = posTags[i].getType();
            for (j = lemmas.size() - 1; j >= i; --j) {
                String endPos = posTags[j].getType();
                searchSpan = this.createSpan(lemmas, i, j);
                String firstSpan = (searchSpan + "#" + pos.substring(0, 1)).toLowerCase();
                TreeMultimap<Integer, String> mfsMap = this.getOrderedMap(firstSpan);
                if (!mfsMap.isEmpty()) {
                    mostFrequentSense = this.getMFS(mfsMap);
                    break;
                }
                String lastSpan = (searchSpan + "#" + endPos.substring(0, 1)).toLowerCase();
                TreeMultimap<Integer, String> mfsMapEnd = this.getOrderedMap(lastSpan);
                if (mfsMapEnd.isEmpty()) continue;
                mostFrequentSense = this.getMFS(mfsMapEnd);
                break;
            }
            prefix = "-start";
            if (mostFrequentSense != null) {
                while (i < j) {
                    mostFrequentSenseList.add((mostFrequentSense + prefix).intern());
                    prefix = "-cont";
                    ++i;
                }
            }
            if (mostFrequentSense != null) {
                if (prefix.equals("-cont")) {
                    mostFrequentSenseList.add((mostFrequentSense + "-" + "last").intern());
                    continue;
                }
                if (!prefix.equals("-start")) continue;
                mostFrequentSenseList.add((mostFrequentSense + "-" + "unit").intern());
                continue;
            }
            mostFrequentSenseList.add("other");
        }
        return mostFrequentSenseList;
    }

    private String createSpan(List<String> lemmas, int from, int to) {
        String lemmaSpan = "";
        for (int i = from; i < to; ++i) {
            lemmaSpan = lemmaSpan + lemmas.get(i) + "_";
        }
        lemmaSpan = lemmaSpan + lemmas.get(to);
        return lemmaSpan;
    }

    public TreeMultimap<Integer, String> getOrderedMap(String lemmaPOSClass) {
        List mfsList = this.multiMap.get((Object)lemmaPOSClass);
        TreeMultimap mfsMap = TreeMultimap.create((Comparator)Ordering.natural().reverse(), (Comparator)Ordering.natural());
        if (!mfsList.isEmpty()) {
            this.getOrderedSenses(mfsList, (TreeMultimap<Integer, String>)mfsMap);
        }
        return mfsMap;
    }

    public void getOrderedSenses(List<String> mfsList, TreeMultimap<Integer, String> mfsResultsMap) {
        if (!mfsList.isEmpty()) {
            for (String mfsResult : mfsList) {
                String[] mfsEntry = mfsResult.split("#");
                mfsResultsMap.put((Object)Integer.valueOf(mfsEntry[0]), (Object)mfsEntry[1]);
            }
        }
    }

    public String getMFS(TreeMultimap<Integer, String> mfsMap) {
        NavigableSet mfs = mfsMap.get(mfsMap.keySet().first());
        return (String)mfs.first();
    }

    public TreeMultimap<Integer, String> getMFSRanking(String lemmaPOSClass, Integer rankSize) {
        TreeMultimap<Integer, String> mfsResultsMap = this.getOrderedMap(lemmaPOSClass);
        TreeMultimap mfsRankMap = TreeMultimap.create((Comparator)Ordering.natural().reverse(), (Comparator)Ordering.natural());
        for (Map.Entry freqSenseEntry : Iterables.limit((Iterable)mfsResultsMap.entries(), (int)rankSize)) {
            mfsRankMap.put(freqSenseEntry.getKey(), freqSenseEntry.getValue());
        }
        return mfsRankMap;
    }

    public void serialize(OutputStream out) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out));
        for (Map.Entry entry : this.multiMap.entries()) {
            writer.write((String)entry.getKey() + "\t" + (String)entry.getValue() + "\n");
        }
        ((Writer)writer).flush();
    }

    public Class<?> getArtifactSerializerClass() {
        return MFSResourceSerializer.class;
    }

    public static class MFSResourceSerializer
    implements ArtifactSerializer<MFSResource> {
        public MFSResource create(InputStream in) throws IOException, InvalidFormatException {
            return new MFSResource(in);
        }

        public void serialize(MFSResource artifact, OutputStream out) throws IOException {
            artifact.serialize(out);
        }
    }
}

