/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.ml.resources;

import com.google.common.collect.Ordering;
import com.google.common.collect.TreeMultimap;
import eus.ixa.ixa.pipe.ml.utils.StringUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableSet;
import java.util.concurrent.atomic.AtomicInteger;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.StringUtil;
import opennlp.tools.util.featuregen.StringPattern;
import opennlp.tools.util.model.ArtifactSerializer;
import opennlp.tools.util.model.SerializableArtifact;

public class POSDictionary
implements SerializableArtifact {
    private static final char tabDelimiter = '\t';
    private Map<String, Map<String, AtomicInteger>> newEntries = new HashMap<String, Map<String, AtomicInteger>>();
    String[] splitted = new String[64];

    public POSDictionary(InputStream in) throws IOException {
        String line;
        HashMap<String, Map<String, AtomicInteger>> newEntries = new HashMap<String, Map<String, AtomicInteger>>();
        BufferedReader breader = new BufferedReader(new InputStreamReader(in, Charset.forName("UTF-8")));
        while ((line = breader.readLine()) != null) {
            StringUtils.splitLine(line, '\t', this.splitted);
            POSDictionary.populatePOSMap(this.splitted, newEntries);
        }
    }

    private static void populatePOSMap(String[] lineArray, Map<String, Map<String, AtomicInteger>> newEntries) {
        if (lineArray.length == 2 && !StringPattern.recognize((String)lineArray[0]).containsDigit()) {
            String word = StringUtil.toLowerCase((CharSequence)lineArray[0]);
            if (!newEntries.containsKey(word)) {
                newEntries.put(word, new HashMap());
            }
            if (!newEntries.get(word).containsKey(lineArray[1])) {
                newEntries.get(word).put(lineArray[1], new AtomicInteger(1));
            } else {
                newEntries.get(word).get(lineArray[1]).incrementAndGet();
            }
        }
    }

    public String getMostFrequentTag(String word) {
        TreeMultimap<Integer, String> mfTagMap = this.getOrderedMap(word);
        String mfTag = null;
        if (!mfTagMap.isEmpty()) {
            NavigableSet mfTagSet = mfTagMap.get(mfTagMap.keySet().first());
            mfTag = (String)mfTagSet.first();
        } else {
            mfTag = "O";
        }
        return mfTag;
    }

    public TreeMultimap<Integer, String> getOrderedMap(String word) {
        Map<String, AtomicInteger> tagFreqsMap = this.newEntries.get(word);
        TreeMultimap mfTagMap = TreeMultimap.create((Comparator)Ordering.natural().reverse(), (Comparator)Ordering.natural());
        if (tagFreqsMap != null) {
            this.getOrderedTags(tagFreqsMap, (TreeMultimap<Integer, String>)mfTagMap);
        }
        return mfTagMap;
    }

    private void getOrderedTags(Map<String, AtomicInteger> tagFreqsMap, TreeMultimap<Integer, String> mfTagMap) {
        if (!tagFreqsMap.isEmpty() || tagFreqsMap != null) {
            for (Map.Entry<String, AtomicInteger> entry : tagFreqsMap.entrySet()) {
                mfTagMap.put((Object)entry.getValue().intValue(), (Object)entry.getKey());
            }
        }
    }

    public void serialize(OutputStream out) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out));
        for (Map.Entry<String, Map<String, AtomicInteger>> entry : this.newEntries.entrySet()) {
            writer.write(entry.getKey() + "\t" + entry.getValue().get(entry.getKey()) + "\n");
        }
        ((Writer)writer).flush();
    }

    public Class<?> getArtifactSerializerClass() {
        return POSDictionarySerializer.class;
    }

    public static class POSDictionarySerializer
    implements ArtifactSerializer<POSDictionary> {
        public POSDictionary create(InputStream in) throws IOException, InvalidFormatException {
            return new POSDictionary(in);
        }

        public void serialize(POSDictionary artifact, OutputStream out) throws IOException {
            artifact.serialize(out);
        }
    }
}

