/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.ml.resources;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.model.ArtifactSerializer;
import opennlp.tools.util.model.SerializableArtifact;

public class PredicateContext
implements SerializableArtifact {
    private static final Pattern tabPattern = Pattern.compile("\t");
    public static final Pattern dotInsideI = Pattern.compile("\u0130", 256);
    List<List<String>> predContexts = new ArrayList<List<String>>();

    public List<List<String>> getPredicateContext() {
        return this.predContexts;
    }

    public PredicateContext(InputStream in) throws IOException {
        String line;
        BufferedReader breader = new BufferedReader(new InputStreamReader(in, Charset.forName("UTF-8")));
        while ((line = breader.readLine()) != null) {
            String[] lineArray = tabPattern.split(line);
            this.populateLists(lineArray);
        }
    }

    private void populateLists(String[] lineArray) {
        if (lineArray.length == 3) {
            String normalizedToken = dotInsideI.matcher(lineArray[0]).replaceAll("i");
            String normalizedContext = dotInsideI.matcher(lineArray[1]).replaceAll("i");
            ArrayList<String> tokenValues = new ArrayList<String>();
            tokenValues.add(normalizedToken);
            tokenValues.add(normalizedContext);
            tokenValues.add(lineArray[2]);
            this.predContexts.add(tokenValues);
        }
    }

    public void serialize(OutputStream out) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out));
        for (List<String> entry : this.predContexts) {
            writer.write(entry.get(0) + "\t" + entry.get(1) + "\t" + entry.get(2) + "\n");
        }
        ((Writer)writer).flush();
    }

    public Class<?> getArtifactSerializerClass() {
        return PredicateContextSerializer.class;
    }

    public static class PredicateContextSerializer
    implements ArtifactSerializer<PredicateContext> {
        public PredicateContext create(InputStream in) throws IOException, InvalidFormatException {
            return new PredicateContext(in);
        }

        public void serialize(PredicateContext artifact, OutputStream out) throws IOException {
            artifact.serialize(out);
        }
    }
}

