/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.ml.sequence;

import eus.ixa.ixa.pipe.ml.sequence.SequenceLabelSample;
import eus.ixa.ixa.pipe.ml.utils.Span;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import opennlp.tools.util.FilterObjectStream;
import opennlp.tools.util.ObjectStream;

public class SequenceLabelSampleTypeFilter
extends FilterObjectStream<SequenceLabelSample, SequenceLabelSample> {
    private final Set<String> types;

    public SequenceLabelSampleTypeFilter(String[] types, ObjectStream<SequenceLabelSample> samples) {
        super(samples);
        this.types = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(types)));
    }

    public SequenceLabelSampleTypeFilter(Set<String> types, ObjectStream<SequenceLabelSample> samples) {
        super(samples);
        this.types = Collections.unmodifiableSet(new HashSet<String>(types));
    }

    public SequenceLabelSample read() throws IOException {
        SequenceLabelSample sample = (SequenceLabelSample)this.samples.read();
        if (sample != null) {
            ArrayList<Span> filteredNames = new ArrayList<Span>();
            for (Span name : sample.getSequences()) {
                if (!this.types.contains(name.getType())) continue;
                filteredNames.add(name);
            }
            return new SequenceLabelSample(sample.getId(), sample.getTokens(), filteredNames.toArray(new Span[filteredNames.size()]), null, sample.isClearAdaptiveDataSet());
        }
        return null;
    }
}

