/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.ml.sequence;

import eus.ixa.ixa.pipe.ml.sequence.BioCodec;
import eus.ixa.ixa.pipe.ml.sequence.DefaultSequenceLabelerContextGenerator;
import eus.ixa.ixa.pipe.ml.sequence.SequenceLabelSample;
import eus.ixa.ixa.pipe.ml.sequence.SequenceLabelerCodec;
import eus.ixa.ixa.pipe.ml.sequence.SequenceLabelerContextGenerator;
import eus.ixa.ixa.pipe.ml.utils.Span;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import opennlp.tools.ml.model.Event;
import opennlp.tools.util.AbstractEventStream;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.featuregen.AdaptiveFeatureGenerator;
import opennlp.tools.util.featuregen.AdditionalContextFeatureGenerator;
import opennlp.tools.util.featuregen.WindowFeatureGenerator;

public class SequenceLabelerEventStream
extends AbstractEventStream<SequenceLabelSample> {
    private SequenceLabelerContextGenerator contextGenerator;
    private AdditionalContextFeatureGenerator additionalContextFeatureGenerator = new AdditionalContextFeatureGenerator();
    private String type;
    private SequenceLabelerCodec<String> codec;

    public SequenceLabelerEventStream(ObjectStream<SequenceLabelSample> dataStream, String type, SequenceLabelerContextGenerator contextGenerator, SequenceLabelerCodec codec) {
        super(dataStream);
        this.codec = codec;
        if (codec == null) {
            this.codec = new BioCodec();
        }
        this.contextGenerator = contextGenerator;
        this.contextGenerator.addFeatureGenerator((AdaptiveFeatureGenerator)new WindowFeatureGenerator((AdaptiveFeatureGenerator)this.additionalContextFeatureGenerator, 8, 8));
        this.type = type != null ? type : "default";
    }

    public SequenceLabelerEventStream(ObjectStream<SequenceLabelSample> dataStream) {
        this(dataStream, null, new DefaultSequenceLabelerContextGenerator(new AdaptiveFeatureGenerator[0]), null);
    }

    @Deprecated
    public static String[] generateOutcomes(Span[] names, String type, int length) {
        String[] outcomes = new String[length];
        for (int i = 0; i < outcomes.length; ++i) {
            outcomes[i] = "other";
        }
        for (Span name : names) {
            outcomes[name.getStart()] = name.getType() == null ? type + "-" + "start" : name.getType() + "-" + "start";
            for (int i = name.getStart() + 1; i < name.getEnd(); ++i) {
                outcomes[i] = name.getType() == null ? type + "-" + "cont" : name.getType() + "-" + "cont";
            }
        }
        return outcomes;
    }

    public static List<Event> generateEvents(String[] sentence, String[] outcomes, SequenceLabelerContextGenerator cg) {
        ArrayList<Event> events = new ArrayList<Event>(outcomes.length);
        for (int i = 0; i < outcomes.length; ++i) {
            events.add(new Event(outcomes[i], cg.getContext(i, sentence, outcomes, null)));
        }
        cg.updateAdaptiveData(sentence, outcomes);
        return events;
    }

    protected Iterator<Event> createEvents(SequenceLabelSample sample) {
        if (sample.isClearAdaptiveDataSet()) {
            this.contextGenerator.clearAdaptiveData();
        }
        String[] outcomes = this.codec.encode(sample.getSequences(), sample.getTokens().length);
        this.additionalContextFeatureGenerator.setCurrentContext(sample.getAdditionalContext());
        String[] tokens = new String[sample.getTokens().length];
        for (int i = 0; i < sample.getTokens().length; ++i) {
            tokens[i] = sample.getTokens()[i];
        }
        return SequenceLabelerEventStream.generateEvents(tokens, outcomes, this.contextGenerator).iterator();
    }

    public static String[][] additionalContext(String[] tokens, Map<String, String> prevMap) {
        String[][] ac = new String[tokens.length][1];
        for (int ti = 0; ti < tokens.length; ++ti) {
            String pt = prevMap.get(tokens[ti]);
            ac[ti][0] = "pd=" + pt;
        }
        return ac;
    }
}

