/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.ml.sequence;

import eus.ixa.ixa.pipe.ml.sequence.BioCodec;
import eus.ixa.ixa.pipe.ml.sequence.SequenceLabelSample;
import eus.ixa.ixa.pipe.ml.sequence.SequenceLabeler;
import eus.ixa.ixa.pipe.ml.sequence.SequenceLabelerCodec;
import eus.ixa.ixa.pipe.ml.sequence.SequenceLabelerContextGenerator;
import eus.ixa.ixa.pipe.ml.sequence.SequenceLabelerEventStream;
import eus.ixa.ixa.pipe.ml.sequence.SequenceLabelerFactory;
import eus.ixa.ixa.pipe.ml.sequence.SequenceLabelerModel;
import eus.ixa.ixa.pipe.ml.sequence.SequenceLabelerSequenceStream;
import eus.ixa.ixa.pipe.ml.utils.Span;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import opennlp.tools.ml.EventModelSequenceTrainer;
import opennlp.tools.ml.EventTrainer;
import opennlp.tools.ml.SequenceTrainer;
import opennlp.tools.ml.TrainerFactory;
import opennlp.tools.ml.model.MaxentModel;
import opennlp.tools.ml.model.SequenceClassificationModel;
import opennlp.tools.ml.model.SequenceStream;
import opennlp.tools.util.BeamSearchContextGenerator;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.Sequence;
import opennlp.tools.util.SequenceValidator;
import opennlp.tools.util.TrainingParameters;
import opennlp.tools.util.featuregen.AdaptiveFeatureGenerator;
import opennlp.tools.util.featuregen.AdditionalContextFeatureGenerator;
import opennlp.tools.util.featuregen.BigramNameFeatureGenerator;
import opennlp.tools.util.featuregen.CachedFeatureGenerator;
import opennlp.tools.util.featuregen.OutcomePriorFeatureGenerator;
import opennlp.tools.util.featuregen.PreviousMapFeatureGenerator;
import opennlp.tools.util.featuregen.SentenceFeatureGenerator;
import opennlp.tools.util.featuregen.TokenClassFeatureGenerator;
import opennlp.tools.util.featuregen.TokenFeatureGenerator;
import opennlp.tools.util.featuregen.WindowFeatureGenerator;

public class SequenceLabelerME
implements SequenceLabeler {
    private static String[][] EMPTY = new String[0][0];
    public static final int DEFAULT_BEAM_SIZE = 3;
    private static final Pattern typedOutcomePattern = Pattern.compile("(.+)-\\w+");
    public static Pattern startPattern = Pattern.compile("(\\S+)-start", 256);
    public static Pattern contPattern = Pattern.compile("(\\S+)-cont", 256);
    public static Pattern lastPattern = Pattern.compile("(\\S+)-last", 256);
    public static Pattern unitPattern = Pattern.compile("(\\S+)-unit", 256);
    public static Pattern otherPattern = Pattern.compile("other");
    private SequenceLabelerCodec<String> seqCodec = new BioCodec();
    protected SequenceClassificationModel<String> model;
    protected SequenceLabelerContextGenerator contextGenerator;
    private Sequence bestSequence;
    private AdditionalContextFeatureGenerator additionalContextFeatureGenerator = new AdditionalContextFeatureGenerator();
    private SequenceValidator<String> sequenceValidator;

    public SequenceLabelerME(SequenceLabelerModel model) {
        SequenceLabelerFactory factory = model.getFactory();
        this.seqCodec = factory.createSequenceCodec();
        this.sequenceValidator = this.seqCodec.createSequenceValidator();
        this.model = model.getSequenceLabelerModel();
        this.contextGenerator = factory.createContextGenerator();
        this.contextGenerator.addFeatureGenerator((AdaptiveFeatureGenerator)new WindowFeatureGenerator((AdaptiveFeatureGenerator)this.additionalContextFeatureGenerator, 8, 8));
    }

    @Deprecated
    static AdaptiveFeatureGenerator createFeatureGenerator() {
        return new CachedFeatureGenerator(new AdaptiveFeatureGenerator[]{new WindowFeatureGenerator((AdaptiveFeatureGenerator)new TokenFeatureGenerator(), 2, 2), new WindowFeatureGenerator((AdaptiveFeatureGenerator)new TokenClassFeatureGenerator(true), 2, 2), new OutcomePriorFeatureGenerator(), new PreviousMapFeatureGenerator(), new BigramNameFeatureGenerator(), new SentenceFeatureGenerator(true, false)});
    }

    @Override
    public Span[] tag(String[] tokens) {
        return this.tag(tokens, EMPTY);
    }

    public Span[] tag(String[] tokens, String[][] additionalContext) {
        this.additionalContextFeatureGenerator.setCurrentContext(additionalContext);
        this.bestSequence = this.model.bestSequence((Object[])tokens, (Object[])additionalContext, (BeamSearchContextGenerator)this.contextGenerator, this.sequenceValidator);
        List c = this.bestSequence.getOutcomes();
        this.contextGenerator.updateAdaptiveData(tokens, c.toArray(new String[c.size()]));
        Span[] spans = this.seqCodec.decode(c);
        spans = this.setProbs(spans);
        return spans;
    }

    public String[] tagToStrings(String[] tokens) {
        this.bestSequence = this.model.bestSequence((Object[])tokens, null, (BeamSearchContextGenerator)this.contextGenerator, this.sequenceValidator);
        List c = this.bestSequence.getOutcomes();
        this.contextGenerator.updateAdaptiveData(tokens, c.toArray(new String[c.size()]));
        return c.toArray(new String[c.size()]);
    }

    public Span[][] tag(int numTaggings, String[] tokens) {
        Sequence[] bestSequences = this.model.bestSequences(numTaggings, (Object[])tokens, null, (BeamSearchContextGenerator)this.contextGenerator, this.sequenceValidator);
        Span[][] tags = new Span[bestSequences.length][];
        for (int i = 0; i < tags.length; ++i) {
            List c = bestSequences[i].getOutcomes();
            this.contextGenerator.updateAdaptiveData(tokens, c.toArray(new String[c.size()]));
            Span[] spans = this.seqCodec.decode(c);
            tags[i] = spans;
        }
        return tags;
    }

    public Sequence[] topKSequences(String[] tokens) {
        return this.model.bestSequences(3, (Object[])tokens, null, (BeamSearchContextGenerator)this.contextGenerator, this.sequenceValidator);
    }

    public Sequence[] topKSequences(String[] tokens, String[] tags, double minSequenceScore) {
        return this.model.bestSequences(3, (Object[])tokens, new Object[]{tags}, minSequenceScore, (BeamSearchContextGenerator)this.contextGenerator, this.sequenceValidator);
    }

    @Override
    public void clearAdaptiveData() {
        this.contextGenerator.clearAdaptiveData();
    }

    public void probs(double[] probs) {
        this.bestSequence.getProbs(probs);
    }

    public double[] probs() {
        return this.bestSequence.getProbs();
    }

    private Span[] setProbs(Span[] spans) {
        double[] probs = this.probs(spans);
        if (probs != null) {
            for (int i = 0; i < probs.length; ++i) {
                double prob = probs[i];
                spans[i] = new Span(spans[i], prob);
            }
        }
        return spans;
    }

    public double[] probs(Span[] spans) {
        double[] sprobs = new double[spans.length];
        double[] probs = this.bestSequence.getProbs();
        for (int si = 0; si < spans.length; ++si) {
            double p = 0.0;
            for (int oi = spans[si].getStart(); oi < spans[si].getEnd(); ++oi) {
                p += probs[oi];
            }
            sprobs[si] = p /= (double)spans[si].length();
        }
        return sprobs;
    }

    public static SequenceLabelerModel train(String languageCode, String type, ObjectStream<SequenceLabelSample> samples, TrainingParameters trainParams, SequenceLabelerFactory factory) throws IOException {
        String beamSizeString = (String)trainParams.getSettings().get("BeamSize");
        int beamSize = 3;
        if (beamSizeString != null) {
            beamSize = Integer.parseInt(beamSizeString);
        }
        HashMap<String, String> manifestInfoEntries = new HashMap<String, String>();
        MaxentModel nameFinderModel = null;
        SequenceClassificationModel seqModel = null;
        TrainerFactory.TrainerType trainerType = TrainerFactory.getTrainerType((Map)trainParams.getSettings());
        if (TrainerFactory.TrainerType.EVENT_MODEL_TRAINER.equals((Object)trainerType)) {
            SequenceLabelerEventStream eventStream = new SequenceLabelerEventStream(samples, type, factory.createContextGenerator(), factory.createSequenceCodec());
            EventTrainer trainer = TrainerFactory.getEventTrainer((Map)trainParams.getSettings(), manifestInfoEntries);
            nameFinderModel = trainer.train((ObjectStream)eventStream);
        } else if (TrainerFactory.TrainerType.EVENT_MODEL_SEQUENCE_TRAINER.equals((Object)trainerType)) {
            SequenceLabelerSequenceStream ss = new SequenceLabelerSequenceStream(samples, factory.createContextGenerator());
            EventModelSequenceTrainer trainer = TrainerFactory.getEventModelSequenceTrainer((Map)trainParams.getSettings(), manifestInfoEntries);
            nameFinderModel = trainer.train((SequenceStream)ss);
        } else if (TrainerFactory.TrainerType.SEQUENCE_TRAINER.equals((Object)trainerType)) {
            SequenceTrainer trainer = TrainerFactory.getSequenceModelTrainer((Map)trainParams.getSettings(), manifestInfoEntries);
            SequenceLabelerSequenceStream ss = new SequenceLabelerSequenceStream(samples, factory.createContextGenerator(), false);
            seqModel = trainer.train((SequenceStream)ss);
        } else {
            throw new IllegalStateException("Unexpected trainer type!");
        }
        if (seqModel != null) {
            return new SequenceLabelerModel(languageCode, (SequenceClassificationModel<String>)seqModel, factory.getFeatureGenerator(), factory.getResources(), manifestInfoEntries, factory.getSequenceCodec(), factory);
        }
        return new SequenceLabelerModel(languageCode, nameFinderModel, beamSize, factory.getFeatureGenerator(), factory.getResources(), manifestInfoEntries, factory.getSequenceCodec(), factory);
    }

    static final String extractNameType(String outcome) {
        Matcher matcher = typedOutcomePattern.matcher(outcome);
        if (matcher.matches()) {
            String nameType = matcher.group(1);
            return nameType;
        }
        return null;
    }

    public static Span[] dropOverlappingSpans(Span[] spans) {
        ArrayList sortedSpans = new ArrayList(spans.length);
        Collections.addAll(sortedSpans, spans);
        Collections.sort(sortedSpans);
        Iterator it = sortedSpans.iterator();
        Span lastSpan = null;
        while (it.hasNext()) {
            Span span = (Span)it.next();
            if (lastSpan != null && lastSpan.intersects(span)) {
                it.remove();
                span = lastSpan;
            }
            lastSpan = span;
        }
        return sortedSpans.toArray(new Span[sortedSpans.size()]);
    }

    public String[] decodeSequences(String[] preds) {
        ArrayList<String> decodedSequences = new ArrayList<String>();
        for (String pred : preds) {
            pred = startPattern.matcher(pred).replaceAll("B-$1");
            pred = contPattern.matcher(pred).replaceAll("I-$1");
            pred = lastPattern.matcher(pred).replaceAll("I-$1");
            pred = unitPattern.matcher(pred).replaceAll("B-$1");
            pred = otherPattern.matcher(pred).replaceAll("O");
            decodedSequences.add(pred);
        }
        return decodedSequences.toArray(new String[decodedSequences.size()]);
    }
}

