/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.ml.sequence;

import eus.ixa.ixa.pipe.ml.sequence.BioCodec;
import eus.ixa.ixa.pipe.ml.sequence.DefaultSequenceLabelerContextGenerator;
import eus.ixa.ixa.pipe.ml.sequence.SequenceLabelSample;
import eus.ixa.ixa.pipe.ml.sequence.SequenceLabelerCodec;
import eus.ixa.ixa.pipe.ml.sequence.SequenceLabelerContextGenerator;
import eus.ixa.ixa.pipe.ml.sequence.SequenceLabelerEventStream;
import eus.ixa.ixa.pipe.ml.sequence.SequenceLabelerME;
import eus.ixa.ixa.pipe.ml.sequence.SequenceLabelerModel;
import java.io.IOException;
import java.util.Collections;
import opennlp.tools.ml.model.AbstractModel;
import opennlp.tools.ml.model.Event;
import opennlp.tools.ml.model.MaxentModel;
import opennlp.tools.ml.model.Sequence;
import opennlp.tools.ml.model.SequenceStream;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.featuregen.AdaptiveFeatureGenerator;

public class SequenceLabelerSequenceStream
implements SequenceStream {
    private SequenceLabelerContextGenerator pcg;
    private final boolean useOutcomes;
    private ObjectStream<SequenceLabelSample> psi;
    private SequenceLabelerCodec<String> seqCodec;

    public SequenceLabelerSequenceStream(ObjectStream<SequenceLabelSample> psi) throws IOException {
        this(psi, new DefaultSequenceLabelerContextGenerator(new AdaptiveFeatureGenerator[]{null}), true);
    }

    public SequenceLabelerSequenceStream(ObjectStream<SequenceLabelSample> psi, AdaptiveFeatureGenerator featureGen) throws IOException {
        this(psi, new DefaultSequenceLabelerContextGenerator(featureGen), true);
    }

    public SequenceLabelerSequenceStream(ObjectStream<SequenceLabelSample> psi, AdaptiveFeatureGenerator featureGen, boolean useOutcomes) throws IOException {
        this(psi, new DefaultSequenceLabelerContextGenerator(featureGen), useOutcomes);
    }

    public SequenceLabelerSequenceStream(ObjectStream<SequenceLabelSample> psi, SequenceLabelerContextGenerator pcg) throws IOException {
        this(psi, pcg, true);
    }

    public SequenceLabelerSequenceStream(ObjectStream<SequenceLabelSample> psi, SequenceLabelerContextGenerator pcg, boolean useOutcomes) throws IOException {
        this(psi, pcg, useOutcomes, new BioCodec());
    }

    public SequenceLabelerSequenceStream(ObjectStream<SequenceLabelSample> psi, SequenceLabelerContextGenerator pcg, boolean useOutcomes, SequenceLabelerCodec<String> seqCodec) throws IOException {
        this.psi = psi;
        this.useOutcomes = useOutcomes;
        this.pcg = pcg;
        this.seqCodec = seqCodec;
    }

    public Event[] updateContext(Sequence sequence, AbstractModel model) {
        Sequence pss = sequence;
        SequenceLabelerME tagger = new SequenceLabelerME(new SequenceLabelerModel("x-unspecified", (MaxentModel)model, Collections.emptyMap(), null));
        String[] sentence = ((SequenceLabelSample)pss.getSource()).getTokens();
        String[] tags = this.seqCodec.encode(tagger.tag(sentence), sentence.length);
        Event[] events = new Event[sentence.length];
        SequenceLabelerEventStream.generateEvents(sentence, tags, this.pcg).toArray(events);
        return events;
    }

    public Sequence read() throws IOException {
        SequenceLabelSample sample = (SequenceLabelSample)this.psi.read();
        if (sample != null) {
            Object[] sentence = sample.getTokens();
            String[] tags = this.seqCodec.encode(sample.getSequences(), sentence.length);
            Event[] events = new Event[sentence.length];
            for (int i = 0; i < sentence.length; ++i) {
                String[] context = this.useOutcomes ? this.pcg.getContext(i, sentence, tags, null) : this.pcg.getContext(i, sentence, null, null);
                events[i] = new Event(tags[i], context);
            }
            Sequence sequence = new Sequence(events, (Object)sample);
            return sequence;
        }
        return null;
    }

    public void reset() throws IOException, UnsupportedOperationException {
        this.psi.reset();
    }

    public void close() throws IOException {
        this.psi.close();
    }
}

